/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class UpgradeFcurpriceHistoryServiceImpl
implements IUpgradeService {
    private static final int MAX_SIZE = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("start update fcurprice");
        this.dataHandle("t_er_expensedetail", result);
        this.dataHandle("t_er_pubreimexpdet", result);
        this.dataHandle("T_ER_ReimburseEntry", result);
        result.setLog("update fcurprice success !");
        return result;
    }

    private void dataHandle(final String tableName, final UpgradeResult result) {
        result.setLog("start update fcurprice for " + tableName + "... ");
        final DBRoute er = DBRoute.of((String)"er");
        DB.query((DBRoute)er, (String)("select  FDetailID, Fprice, Fexchangerate from " + tableName), (ResultSetHandler)new ResultSetHandler<Object>(){

            public Object handle(ResultSet resultSet) throws Exception {
                ArrayList<Object[]> queryObjs = new ArrayList<Object[]>(1000);
                ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(1000);
                while (resultSet.next()) {
                    Object[] queryObj = new Object[]{resultSet.getLong("FDetailID"), resultSet.getBigDecimal("Fprice"), resultSet.getBigDecimal("Fexchangerate")};
                    queryObjs.add(queryObj);
                    if (queryObjs.size() != 1000) continue;
                    for (Object[] qObj : queryObjs) {
                        Object[] updateObj = new Object[]{((BigDecimal)qObj[1]).multiply((BigDecimal)qObj[2]), qObj[0]};
                        updateObjs.add(updateObj);
                    }
                    DB.executeBatch((DBRoute)er, (String)("update " + tableName + " set Fcurprice = ? where FDetailID = ?"), updateObjs);
                    result.setLog("update 1000 record...");
                    queryObjs.clear();
                    updateObjs.clear();
                }
                if (!queryObjs.isEmpty()) {
                    for (Object[] qObj : queryObjs) {
                        Object[] updateObj = new Object[]{((BigDecimal)qObj[1]).multiply((BigDecimal)qObj[2]), qObj[0]};
                        updateObjs.add(updateObj);
                    }
                    DB.executeBatch((DBRoute)er, (String)("update " + tableName + " set Fcurprice = ? where FDetailID = ?"), updateObjs);
                    result.setLog("update " + queryObjs.size() + " record...");
                }
                return null;
            }
        });
        result.setLog(tableName + " update fcurprice success !");
    }
}

