/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UpgradeInvoiceOrderServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeInvoiceOrderServiceImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final int BATCH_UPDATE_COUNT = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DynamicObjectCollection invoiceorders = null;
        try {
            QFilter qFilter = new QFilter("invoicedate", ">=", (Object)this.simpleDateFormat.parse("2022-01-01"));
            invoiceorders = QueryServiceHelper.query((String)"er_invoiceorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
        }
        catch (ParseException e) {
            logger.info("UpgradeInvoiceOrderServiceImpl \u65f6\u95f4\u683c\u5f0f\u7c7b\u578b\u88c5\u6362\u9519\u8bef\u3002");
        }
        if (null == invoiceorders) {
            return result;
        }
        AtomicLong count = new AtomicLong(0L);
        CountDownLatch countDownLatch = null;
        ThreadPool threadPool = null;
        if (null != invoiceorders && invoiceorders.size() > 0) {
            try {
                threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeInvoiceOrderServiceImpl" + System.currentTimeMillis()), (int)10);
                logger.info("UpgradeInvoiceOrderServiceImpl invoiceorders.size():{}", (Object)invoiceorders.size());
                int times = invoiceorders.size() / 1000 + (invoiceorders.size() % 1000 == 0 ? 0 : 1);
                CountDownLatch finalCountDownLatch = countDownLatch = new CountDownLatch(times);
                int i = 0;
                int j = 0;
                while (j < times) {
                    int m = i;
                    ++j;
                    DynamicObjectCollection finalInvoiceorders = invoiceorders;
                    threadPool.execute(() -> {
                        try {
                            List dList = finalInvoiceorders.stream().skip(m).limit(1000L).collect(Collectors.toList());
                            for (DynamicObject dynamicObject : dList) {
                                DynamicObject invoiceorderbill = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)"er_invoiceorderbill");
                                if (null == invoiceorderbill) continue;
                                invoiceorderbill.set("server", (Object)dynamicObject.getString("server").trim());
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceorderbill});
                                count.addAndGet(1L);
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        finalCountDownLatch.countDown();
                    });
                    i += 1000;
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
                result.setLog("error " + exception.getMessage());
            }
        }
        boolean res = false;
        try {
            if (countDownLatch != null) {
                res = countDownLatch.await(3600L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setLog(result.getLog() + e.getMessage());
        }
        if (threadPool != null) {
            threadPool.close();
        }
        result.setLog(result.getLog() + "UpgradeReimburseImpl success : " + count.get());
        result.setSuccess(true);
        return result;
    }
}

