/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.invoicecloud.MetaDataInvoiceTypeEntryEnum;

public class UpgradeInvoiceTypeEKServiceImpl
implements IUpgradeService {
    private static final String serviceKey = "kd.fi.er.mservice.upgrade.UpgradeInvoiceTypeEKServiceImpl";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            ArrayList<MetaDataInvoiceTypeEntryEnum> entryEnums = new ArrayList<MetaDataInvoiceTypeEntryEnum>();
            entryEnums.add(MetaDataInvoiceTypeEntryEnum.DAILYREIMBURSEBILL_INVOICEENTRY);
            entryEnums.add(MetaDataInvoiceTypeEntryEnum.PUBLICREIMBURSEBILL_INVOICEENTRY);
            for (MetaDataInvoiceTypeEntryEnum entryEnum : entryEnums) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entryEnum.getBillName());
                String[] entries = entryEnum.getEntries();
                DynamicProperty property = null;
                for (String entry : entries) {
                    if (property == null) {
                        property = dt.getProperty(entry);
                        continue;
                    }
                    if (!(property instanceof EntryProp)) continue;
                    property = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperty(entry);
                }
                List comboItems = null;
                DynamicProperty invoiceTypeProp = property == null ? dt.getProperty(entryEnum.getFieldName()) : ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperty(entryEnum.getFieldName());
                if (invoiceTypeProp instanceof ComboProp) {
                    comboItems = ((ComboProp)invoiceTypeProp).getComboItems();
                }
                if (comboItems == null || comboItems.isEmpty()) continue;
                this.filterEkInvoiceType(comboItems);
            }
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo("error:" + e);
        }
        return result;
    }

    private void filterEkInvoiceType(List<ValueMapItem> comboItems) {
        ArrayList<Object> items = new ArrayList<Object>();
        DataSet rows = DB.queryDataSet((String)"key", (DBRoute)DBRoute.of((String)"er"), (String)"select typ.fnumber from t_er_invoicetype typ");
        for (Row row : rows) {
            String fnumber = row.getString("fnumber");
            Item item2 = new Item();
            item2.setNumber(fnumber);
            items.add(item2);
        }
        LinkedList<Object[]> argsMain = new LinkedList<Object[]>();
        LinkedList<Object[]> argsLang = new LinkedList<Object[]>();
        ArrayList<ValueMapItem> needAddItem = new ArrayList<ValueMapItem>();
        for (ValueMapItem comboItem : comboItems) {
            boolean allMatch = items.stream().allMatch(item -> !comboItem.getValue().equals(item.getNumber()));
            if (!allMatch) continue;
            needAddItem.add(comboItem);
        }
        if (needAddItem.isEmpty()) {
            return;
        }
        long[] longIds = DB.genLongIds((String)"t_er_invoicetype", (int)needAddItem.size());
        String[] longIds_l = DB.genStringIds((String)"t_er_invoicetype_l", (int)needAddItem.size());
        for (int i = 0; i < needAddItem.size(); ++i) {
            ValueMapItem comboItem = (ValueMapItem)needAddItem.get(i);
            long pkId = longIds[i];
            String pkId_l = longIds_l[i];
            String number = comboItem.getValue();
            String name = comboItem.getName().getLocaleValue_zh_CN();
            Timestamp currentTime = Timestamp.from(Instant.now());
            String status = "C";
            String enable = "1";
            String isDefault = "0";
            Object[] argMain = new Object[]{pkId, pkId, number, currentTime, currentTime, status, enable, isDefault};
            Object[] argLang = new Object[]{pkId, pkId_l, "zh_CN", name};
            argsMain.add(argMain);
            argsLang.add(argLang);
        }
        if (!argsMain.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"insert into t_er_invoicetype(FID,FMASTERID,FNUMBER,FCREATETIME,FMODIFYTIME,FSTATUS,FENABLE,FISDEFAULT) values (?,?,?,?,?,?,?,?);", argsMain);
        }
        if (!argsLang.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"insert into t_er_invoicetype_l(FID,FPKID,FLOCALEID,FNAME) values(?,?,?,?);", argsLang);
        }
    }

    private static class Item {
        private String number;
        private String name;

        private Item() {
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

