/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.dataentity.Tuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang.StringUtils;

public class UpgradeIsInvoiceModifyHistoryData
implements IUpgradeService {
    private final String[] tableName = new String[]{"T_ER_ReimburseBill_a", "t_er_dailyreimbursebill", "t_er_pubreimbill"};
    private final String[] entryName = new String[]{"t_er_invoiceinfo", "t_er_invoiceinfo", "t_er_pubreiminvoiceinfo"};
    private static Log logger = LogFactory.getLog(UpgradeIsInvoiceModifyHistoryData.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        String extendTableInitSql = "insert into T_ER_ReimburseBill_a(fid) select  fid  from T_ER_ReimburseBill  where fid not in (select fid  from T_ER_ReimburseBill_a); ";
        String updateTemplate = "update  %s  set fisinvoicemodified =  case  when   fid in (select distinct  fid from %s where  fid != 0 and finvoiceischange = '2') then '1' else '0' end;";
        ThreadPool threadPool = null;
        threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeIsInvoiceModifyHistoryData_" + System.currentTimeMillis()), (int)3);
        CountDownLatch countDownLatch = new CountDownLatch(this.tableName.length);
        Future[] updateFutures = new Future[this.tableName.length];
        String successMsgTemplate = "update  %s success cost %s millis";
        String errMsgTemplate = "update  %s error info %s";
        logger.info("\u5f00\u59cb\u5347\u7ea7\u5386\u53f2\u6570\u636e\u3002");
        for (int i = 0; i < this.tableName.length; ++i) {
            Future[] updateFuture;
            int index = i;
            updateFutures[i] = updateFuture = threadPool.submit(() -> {
                try {
                    Instant start = Instant.now();
                    if (StringUtils.equals((String)this.tableName[index], (String)"T_ER_ReimburseBill_a")) {
                        DB.execute((DBRoute)DBRoute.of((String)"er"), (String)extendTableInitSql);
                    }
                    DB.execute((DBRoute)DBRoute.of((String)"er"), (String)String.format(updateTemplate, this.tableName[index], this.entryName[index]));
                    Instant end = Instant.now();
                    Tuple tuple = new Tuple((Object)Boolean.TRUE, (Object)String.format(successMsgTemplate, this.tableName[index], Duration.between(start, end).toMillis()));
                    return tuple;
                }
                catch (Exception e) {
                    Tuple tuple = new Tuple((Object)Boolean.FALSE, (Object)String.format(errMsgTemplate, this.tableName[index], this.getStackTrace(e)));
                    return tuple;
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        StringBuilder successBuilder = new StringBuilder();
        StringBuilder errBuilder = new StringBuilder();
        try {
            countDownLatch.await();
            for (Future updateFuture : updateFutures) {
                Tuple result = (Tuple)updateFuture.get();
                if (((Boolean)result.item1).booleanValue()) {
                    successBuilder.append((String)result.item2).append("\n");
                    continue;
                }
                errBuilder.append((String)result.item2).append("\n");
            }
            if (successBuilder.length() != 0) {
                upgradeResult.setLog(successBuilder.toString());
                logger.info(upgradeResult.getLog());
            }
            if (errBuilder.length() != 0) {
                upgradeResult.setSuccess(false);
                upgradeResult.setErrorInfo(errBuilder.toString());
                logger.error(upgradeResult.getErrorInfo());
            }
        }
        catch (ExecutionException e) {
            logger.error(this.getStackTrace(e));
        }
        catch (InterruptedException e) {
            logger.error(this.getStackTrace(e));
            Thread.currentThread().interrupt();
        }
        logger.info("\u7a0b\u5e8f\u6267\u884c\u5b8c\u6210");
        return upgradeResult;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
            String string = stringWriter.toString();
            return string;
        }
    }
}

