/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.er.business.utils.AmountUtils;

public class UpgradePubOriContNotPayAmountServiceImpl
implements IUpgradeService {
    private static final int MAX_SIZE = 5000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("UpgradePubOriContNotPayAmountServiceImpl begin");
        Long start = System.currentTimeMillis();
        final ArrayList updateList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"er"), (String)"select t.fentryid,t.fcontractexpquotetype,t.fcontractentrychangerate,t.fcontractnotpayamount,t.foricontractnotpayamount from t_er_pubreimcontract t where (t.foricontractnotpayamount = 0 or t.foricontractnotpayamount is null) and t.fcontractnotpayamount != 0 and t.fcontractnotpayamount is not null", (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Long fentryid = resultSet.getLong("fentryid");
                    BigDecimal fcontractnotpayamount = resultSet.getBigDecimal("fcontractnotpayamount");
                    String fcontractexpquotetype = resultSet.getString("fcontractexpquotetype");
                    BigDecimal fcontractentrychangerate = resultSet.getBigDecimal("fcontractentrychangerate");
                    BigDecimal foricontractnotpayamount = AmountUtils.getOriAmount((BigDecimal)fcontractnotpayamount, (BigDecimal)fcontractentrychangerate, (int)4, (String)fcontractexpquotetype);
                    updateList.add(new Object[]{foricontractnotpayamount, fentryid});
                }
                return null;
            }
        });
        if (updateList.isEmpty()) {
            result.setLog("don't have updata bills");
            return result;
        }
        ArrayList<Object[]> updateObjs = new ArrayList<Object[]>(1);
        for (Object[] objects : updateList) {
            updateObjs.add(objects);
            if (updateObjs.size() < 5000) continue;
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set foricontractnotpayamount = ?  where fentryid = ?", updateObjs);
            updateObjs.clear();
        }
        if (!updateObjs.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"update t_er_pubreimcontract set foricontractnotpayamount = ?  where fentryid = ?", updateObjs);
        }
        result.setLog("update t_er_pubreimcontract foricontractnotpayamount" + updateList.size() + " record...");
        Long publicReimEnd = System.currentTimeMillis();
        result.setLog("UpgradePubOriContNotPayAmountServiceImpl end,cost time:" + (publicReimEnd - start));
        return result;
    }
}

