/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.upgrade;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class UpgradeReimburseImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpgradeReimburseImpl.class);
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final List<String> BILL_STATUS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"B", "C", "E", "F", "G", "I"}));
    private static final int BATCH_UPDATE_COUNT = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        QFilter qFilter = new QFilter("billstatus", "in", BILL_STATUS);
        try {
            qFilter.and("bizdate", ">=", (Object)this.simpleDateFormat.parse("2022-01-01"));
        }
        catch (ParseException e) {
            logger.info("UpgradeReimburseImpl \u65f6\u95f4\u683c\u5f0f\u7c7b\u578b\u88c5\u6362\u9519\u8bef\u3002");
        }
        qFilter.and("tripentry.entryentity.ordernum", "is not null", null);
        qFilter.and("tripentry.entryentity.ordernum", "!=", (Object)"");
        DynamicObjectCollection reimburses = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billno,tripentry.entryentity.ordernum,tripentry.entryentity.orderformid", (QFilter[])new QFilter[]{qFilter});
        AtomicLong count = new AtomicLong(0L);
        CountDownLatch countDownLatch = null;
        ThreadPool threadPool = null;
        if (null != reimburses && reimburses.size() > 0) {
            try {
                threadPool = ThreadPools.newFixedThreadPool((String)("UpgradeReimburseImpl" + System.currentTimeMillis()), (int)10);
                logger.info("UpgradeReimburseImpl reimburses.size():{}", (Object)reimburses.size());
                int times = reimburses.size() / 1000 + (reimburses.size() % 1000 == 0 ? 0 : 1);
                CountDownLatch finalCountDownLatch = countDownLatch = new CountDownLatch(times);
                int i = 0;
                int j = 0;
                while (j < times) {
                    int m = i;
                    ++j;
                    threadPool.execute(() -> {
                        try {
                            List voucherList = reimburses.stream().skip(m).limit(1000L).collect(Collectors.toList());
                            for (DynamicObject dynamicObject : voucherList) {
                                DynamicObject saveallorder;
                                String billno = dynamicObject.getString("billno");
                                String ordernum = dynamicObject.getString("tripentry.entryentity.ordernum");
                                String formid = dynamicObject.getString("tripentry.entryentity.orderformid");
                                if (ordernum == null || ordernum.length() == 0 || formid.indexOf(",") != -1) continue;
                                MainEntityType ordermt = EntityMetadataCache.getDataEntityType((String)formid);
                                ArrayList<Object[]> orderparams = new ArrayList<Object[]>(1);
                                Object[] orderparam = new Object[]{billno, ordernum};
                                orderparams.add(orderparam);
                                DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)("update " + ordermt.getAlias() + " set freimbursenum = ?  where fordernum = ? "), orderparams);
                                DynamicObject allorder = BusinessDataServiceHelper.loadSingle((String)"er_allorderbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("ordernum", "=", (Object)ordernum)});
                                if (null == allorder || null == (saveallorder = BusinessDataServiceHelper.loadSingle((Object)allorder.getPkValue(), (String)"er_allorderbill"))) continue;
                                saveallorder.set("reimbursenum", (Object)billno);
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveallorder});
                                count.addAndGet(1L);
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        finalCountDownLatch.countDown();
                    });
                    i += 1000;
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
                result.setLog("error " + exception.getMessage());
            }
        }
        boolean res = false;
        try {
            if (countDownLatch != null) {
                res = countDownLatch.await(3600L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            result.setLog(result.getLog() + e.getMessage());
        }
        if (threadPool != null) {
            threadPool.close();
        }
        result.setLog(result.getLog() + "UpgradeReimburseImpl success : " + count.get());
        result.setSuccess(true);
        return result;
    }
}

