/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.voucher;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.invoice.param.InvoiceResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.ErAIUtils;

public class ShowInvoiceOrAttachmentUtil {
    private static Log log = LogFactory.getLog(ShowInvoiceOrAttachmentUtil.class);

    public static InvoiceResult getShowInvoiceParameter(boolean aws, DynamicObject dynamicObject) {
        String entityId = dynamicObject.getDynamicObjectType().getName();
        Long costCompany = KingdeeInvoiceCloudConfig.getCostCompanyId((DynamicObject)dynamicObject);
        if (costCompany == null || costCompany == 0L) {
            log.warn("\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return ShowInvoiceOrAttachmentUtil.buildFailResult(entityId, dynamicObject.getLong("id"), ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\u3002", (String)"ErViewInvoicePlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompany);
        if (config == null) {
            log.warn("\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u3002");
            return ShowInvoiceOrAttachmentUtil.buildFailResult(entityId, dynamicObject.getLong("id"), ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ErViewInvoicePlugin_3", (String)"fi-er-business", (Object[])new Object[0]));
        }
        Set<Object> serialnos = new HashSet(2);
        boolean containInvoice = dynamicObject.getDynamicObjectType().getProperties().contains((Object)"invoiceentry");
        if (containInvoice && ((serialnos = dynamicObject.getDynamicObjectCollection("invoiceentry").stream().map(m -> m.getString("serialno")).collect(Collectors.toSet())) == null || serialnos.size() == 0)) {
            log.warn("\u5355\u636e\u65e0\u53d1\u7968\u4fe1\u606f");
            return ShowInvoiceOrAttachmentUtil.buildFailResult(entityId, dynamicObject.getLong("id"), ResManager.loadKDString((String)"\u5355\u636e\u65e0\u53d1\u7968\u4fe1\u606f\u3002", (String)"ErViewInvoicePlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        FormShowParameter parameter = new FormShowParameter();
        if (aws) {
            parameter = InvoiceServiceHelper.buildOutShowInvoiceParameter((DynamicObject)dynamicObject, serialnos, (InvoiceCloudCfgBO)config, null);
        } else {
            IFormView view = ErAIUtils.getView((String)entityId);
            IDataModel model = ErAIUtils.getModel((IFormView)view, (Long)dynamicObject.getLong("id"));
            Map customParams = InvoiceServiceHelper.buildXhShowInvoiceParameter((IDataModel)model, (DynamicObject)dynamicObject, serialnos, (InvoiceCloudCfgBO)config, null);
            parameter.setCustomParams(customParams);
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setFormId("rim_view_invoice");
            view.close();
        }
        InvoiceResult result = new InvoiceResult();
        result.setSuccess(true);
        result.setFormShowParameter(parameter);
        result.setEntityId(entityId);
        result.setBillId(Long.valueOf(dynamicObject.getLong("id")));
        return result;
    }

    public static InvoiceResult buildFailResult(String entityId, Long id, String msg) {
        InvoiceResult result = new InvoiceResult();
        result.setSuccess(false);
        result.setEntityId(entityId);
        result.setBillId(id);
        result.setErrorMsg(msg);
        return result;
    }
}

