/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.report.ReportShowParameter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.ObjectUtils;

@KSObject
public class ShowPageUtils {
    public static final String FORMSTATUS = "billstatus";
    public static final String FORM_ID = "formId";
    public static final String TEMPLATE_ID = "templateId";
    public static final String FORM_NAME = "formName";
    public static final String APPID = "appId";
    public static final String NEED_CALLBACK = "needCallBack";
    public static final String SHOW_TYPE = "showType";
    public static final String FORM_TYPE = "formType";
    public static final String CALLBACK_ACTION_KEY = "callback";
    public static final String CUSTOM_PARAM = "customParam";
    public static final String LOOKUP = "lookup";
    public static final String LIST_FILTER_PARAMETER = "listFilterParameter";
    public static final String MOBILE_ER_LIST_BILL_TEMPLATE = "er_billtemplate";
    public static final String MOBILE_ER_DAPPLYBILL_MOBTEMPLATE = "er_dapplybill_mobtemplate";
    public static final String MOBILE_ER_DAILY_LOAN_LIST_BILL_TEMPLATE = "er_dlbill_mobtemplate";
    public static final String MOBILE_ER_REPAY_MENT_LIST_BILL_TEMPLATE = "er_repaybill__mobtemplate";
    public static final String MOBILE_ER_REIMBURSE_LIST_BILL_TEMPLATE = "er_reimbursebill_moblist";
    public static final String MOBILE_ER_LIST_BASE_TEMPLATE = "er_basetemplate";
    public static final String MOBILE_TEMPLATE = "bos_moblist";
    public static final String WEB_LIST_TEMPLATE = "bos_list";
    public static final String WEB_TREE_LIST_TEMPLATE = "bos_treelist";
    public static final String TARGET_KEY = "_submaintab_";
    public static final String ISNEED_BAESlIST = "isneedbaselist";
    public static final String USEORG = "useorg";
    public static final String NEED_REFRESH = "need_refresh";

    private ShowPageUtils() {
    }

    @KSMethod
    public static String showPage(FormModel formModel, AbstractFormPlugin formPlugin) {
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        if (formModel.getCallBack().booleanValue()) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, formModel.getFormId()));
        }
        formPlugin.getView().showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    @KSMethod
    public static String showPage(FormModel formModel, AbstractFormPlugin formPlugin, CloseCallBack callBack) {
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        if (formModel.getCallBack().booleanValue()) {
            formShowParameter.setCloseCallBack(callBack);
        }
        formPlugin.getView().showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    @KSMethod
    public static String showPage(FormModel formModel, IFormView view, CloseCallBack callBack) {
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        if (formModel.getCallBack().booleanValue()) {
            formShowParameter.setCloseCallBack(callBack);
        }
        view.showForm(formShowParameter);
        return formShowParameter.getPageId();
    }

    public static void showPage(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_ID) == null) {
            return;
        }
        String formType = "1";
        if (paramMap.get(FORM_TYPE) != null) {
            formType = (String)paramMap.get(FORM_TYPE);
        }
        switch (formType) {
            case "0": {
                ShowPageUtils.showWebList(paramMap, formPlugin);
                break;
            }
            case "9": {
                ShowPageUtils.showWebTreeList(paramMap, formPlugin);
                break;
            }
            case "1": {
                ShowPageUtils.showWebForm(paramMap, formPlugin);
                break;
            }
            case "2": {
                ShowPageUtils.showWebBill(paramMap, formPlugin);
                break;
            }
            case "3": {
                ShowPageUtils.showWebReport(paramMap, formPlugin);
                break;
            }
            case "7": {
                ShowPageUtils.showWebBase(paramMap, formPlugin);
                break;
            }
            case "4": {
                ShowPageUtils.showMobileBillList(paramMap, formPlugin);
                break;
            }
            case "5": {
                ShowPageUtils.showMobileForm(paramMap, formPlugin);
                break;
            }
            case "6": {
                ShowPageUtils.showMobileBill(paramMap, formPlugin);
                break;
            }
            case "8": {
                ShowPageUtils.showMobileBase(paramMap, formPlugin);
                break;
            }
            case "10": {
                ShowPageUtils.showMobileBaseList(paramMap, formPlugin);
                break;
            }
            case "13": {
                ShowPageUtils.showMobileForm(paramMap, formPlugin);
                break;
            }
            case "15": {
                ShowPageUtils.showShareDialog(paramMap, formPlugin);
                break;
            }
            case "14": {
                ShowPageUtils.showWebModel(paramMap, formPlugin);
                break;
            }
        }
    }

    private static void showMobileBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileBaseShowParameter showParameter = new MobileBaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBillList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(formId);
        String templateId = MOBILE_ER_LIST_BILL_TEMPLATE;
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        Boolean lookup = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        if (lookup.booleanValue()) {
            showParameter.setLookUp(true);
        }
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBaseList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(formId);
        String templateId = MOBILE_ER_LIST_BASE_TEMPLATE;
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        Boolean ifLookUp = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        showParameter.setLookUp(ifLookUp.booleanValue());
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showMobileBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileBillShowParameter showParameter = new MobileBillShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Floating);
        showParameter.getOpenStyle().setShowType(showType);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebForm(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ShowPageUtils.openPage(showParameter, paramMap, formPlugin);
    }

    public static void showWebBill(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebTreeList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        paramMap.put(TEMPLATE_ID, WEB_TREE_LIST_TEMPLATE);
        ShowPageUtils.showWebList(paramMap, formPlugin);
    }

    public static void showWebList(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(formId);
        Long useOrg = (Long)paramMap.get(USEORG);
        if (useOrg != null && useOrg != 0L) {
            showParameter.setUseOrgId(useOrg.longValue());
        }
        String templateId = WEB_LIST_TEMPLATE;
        if (paramMap.get(TEMPLATE_ID) != null) {
            templateId = (String)paramMap.get(TEMPLATE_ID);
        }
        showParameter.setFormId(templateId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        Boolean ifLookUp = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(LOOKUP), (Object)Boolean.FALSE);
        showParameter.setLookUp(ifLookUp.booleanValue());
        if (paramMap.get(LIST_FILTER_PARAMETER) != null) {
            showParameter.setListFilterParameter((ListFilterParameter)paramMap.get(LIST_FILTER_PARAMETER));
        }
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebReport(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebBase(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.NewTabPage);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(TARGET_KEY);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    @KSMethod
    public static void showShareDialog(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        String formId = (String)paramMap.get(FORM_ID);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)paramMap.get(SHOW_TYPE), (Object)ShowType.Modal);
        showParameter.getOpenStyle().setShowType(showType);
        ShowPageUtils.openPage((FormShowParameter)showParameter, paramMap, formPlugin);
    }

    public static void showWebModel(Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap == null || paramMap.size() < 1) {
            return;
        }
        if (paramMap.get(FORM_ID) == null || paramMap.get(NEED_CALLBACK) == null) {
            return;
        }
        String formId = (String)paramMap.get(FORM_ID);
        Boolean needCallBack = (Boolean)paramMap.get(NEED_CALLBACK);
        String formName = "";
        if (paramMap.get(FORM_NAME) != null) {
            formName = (String)paramMap.get(FORM_NAME);
        }
        HashMap<String, Object> customParam = new HashMap();
        if (paramMap.get(CUSTOM_PARAM) != null) {
            customParam = (Map)paramMap.get(CUSTOM_PARAM);
        }
        FormModel formModel = new FormModel(formId, formName, "14", needCallBack, customParam);
        ShowPageUtils.showPage(formModel, formPlugin);
    }

    private static void openPage(FormShowParameter showParameter, Map<String, Object> paramMap, AbstractFormPlugin formPlugin) {
        if (paramMap.get(FORM_NAME) != null) {
            showParameter.setCaption((String)paramMap.get(FORM_NAME));
        }
        if (paramMap.get(APPID) != null) {
            showParameter.setAppId((String)paramMap.get(APPID));
        }
        Boolean needCallBack = (Boolean)ObjectUtils.defaultIfNull((Object)paramMap.get(NEED_CALLBACK), (Object)Boolean.FALSE);
        String formId = (String)paramMap.get(FORM_ID);
        if (needCallBack.booleanValue()) {
            String callback = (String)paramMap.getOrDefault(CALLBACK_ACTION_KEY, formId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, callback));
        }
        if (paramMap.get(CUSTOM_PARAM) != null) {
            Map customParam = (Map)paramMap.get(CUSTOM_PARAM);
            showParameter.getCustomParams().putAll(customParam);
        }
        showParameter.setHasRight(true);
        formPlugin.getView().showForm(showParameter);
    }

    public static void setMobilePageFormStatus(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object formStatus = formShowParameter.getCustomParam(FORMSTATUS);
        if (view instanceof MobileBillView) {
            if (BillOperationStatus.VIEW.toString().equals(formStatus)) {
                ((MobileBillView)view).setBillStatus(BillOperationStatus.VIEW);
            }
            if (BillOperationStatus.SUBMIT.toString().equals(formStatus)) {
                ((MobileBillView)view).setBillStatus(BillOperationStatus.SUBMIT);
            }
            if (BillOperationStatus.AUDIT.toString().equals(formStatus)) {
                ((MobileBillView)view).setBillStatus(BillOperationStatus.AUDIT);
            }
            if (BillOperationStatus.ADDNEW.toString().equals(formStatus)) {
                ((MobileBillView)view).setBillStatus(BillOperationStatus.ADDNEW);
            }
            if (BillOperationStatus.EDIT.toString().equals(formStatus)) {
                ((MobileBillView)view).setBillStatus(BillOperationStatus.EDIT);
            }
        } else if (view instanceof MobileFormView && !BillOperationStatus.ADDNEW.toString().equals(formStatus) && !BillOperationStatus.EDIT.toString().equals(formStatus)) {
            ((MobileFormView)view).setStatus(OperationStatus.VIEW);
        }
    }

    public static void setFormStatusToCustomParam(Map<String, Object> param, IFormView view) {
        param.put(FORMSTATUS, ((BillShowParameter)view.getFormShowParameter()).getBillStatus());
    }

    public static ListShowParameter createListFormShowParameter(String formId, String target, String billFormId, ShowType showType, Map<String, Object> params) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(target);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            showParameter.getOpenStyle().setTargetKey(target);
        }
        if (params != null && params.size() > 0) {
            params.forEach((arg_0, arg_1) -> ((ListShowParameter)showParameter).setCustomParam(arg_0, arg_1));
        }
        return showParameter;
    }

    public static void openLinkedForm(Object pkValue, String formId, IFormView view, ShowType showType, boolean hiddenTbmain) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setFormId(formId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setAppId(view.getFormShowParameter().getAppId());
        parameter.setHasRight(true);
        HashMap<String, String> customMap = new HashMap<String, String>(4);
        customMap.put("hiddenTbmain", String.valueOf(hiddenTbmain));
        parameter.setCustomParams(customMap);
        view.showForm((FormShowParameter)parameter);
    }

    public static void openLinkedForm(Object pkValue, String formId, IFormView view) {
        ShowPageUtils.openLinkedForm(pkValue, formId, view, ShowType.MainNewTabPage, false);
    }

    public static void openDynamicPage(IFormView currView, String title, String pageKey, ShowType showType, Map<String, Object> paramMap, CloseCallBack closeCallBack) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(pageKey);
        if (!StringUtils.isBlank((CharSequence)title)) {
            fsp.setCaption(title);
        }
        if (paramMap != null) {
            fsp.setCustomParams(paramMap);
        }
        if (closeCallBack != null) {
            fsp.setCloseCallBack(closeCallBack);
        }
        fsp.getOpenStyle().setShowType(showType);
        currView.showForm(fsp);
    }
}

