/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.invoice.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.model.RelationMainView;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceUtils2 {
    public static final InvoiceRelation getInvoiceRelation(IFormView view, RelationMainView mainView, Long mainViewId) {
        Map<Long, InvoiceRelation> allInvoiceRelationGroup = InvoiceUtils2.getAllInvoiceRelationGroup(view, mainView);
        InvoiceRelation relation = allInvoiceRelationGroup.get(mainViewId);
        return relation;
    }

    public static final InvoiceRelation getInvoiceRelation(DynamicObject dataEntity, RelationMainView mainView, Long mainViewId) {
        Map<Long, InvoiceRelation> allInvoiceRelationGroup = InvoiceUtils2.getAllInvoiceRelationGroup(dataEntity, mainView);
        InvoiceRelation relation = allInvoiceRelationGroup.get(mainViewId);
        return relation;
    }

    public static final Map<Long, InvoiceRelation> getAllInvoiceRelationGroup(IFormView view, RelationMainView mainView) {
        List<InvoiceRelation> relations = InvoiceUtils2.getAllInvoiceRelation(view, mainView);
        Map<Long, InvoiceRelation> invoiceRelationGroup = relations.stream().collect(Collectors.toMap(relation -> relation.getMainViewId(), relation -> relation));
        return invoiceRelationGroup;
    }

    public static final Map<Long, InvoiceRelation> getAllInvoiceRelationGroup(DynamicObject dataEntity, RelationMainView mainView) {
        List<InvoiceRelation> relations = InvoiceUtils2.getAllInvoiceRelation(dataEntity, mainView);
        Map<Long, InvoiceRelation> invoiceRelationGroup = relations.stream().collect(Collectors.toMap(relation -> relation.getMainViewId(), relation -> relation));
        return invoiceRelationGroup;
    }

    public static final List<InvoiceRelation> getAllInvoiceRelation(IFormView view, RelationMainView mainView) {
        Map<Long, Set<Long>> relationMap = InvoiceUtils2.getRelationMap(view, mainView);
        if (MapUtils.isEmpty(relationMap)) {
            return new ArrayList<InvoiceRelation>();
        }
        ArrayList<InvoiceRelation> relations = new ArrayList<InvoiceRelation>(relationMap.size());
        Map<Long, ItemInvoiceRelationEnum> relationEnumMap = InvoiceUtils2.getRelationEnum(view, mainView);
        for (Map.Entry<Long, Set<Long>> next : relationMap.entrySet()) {
            Long mainViewId = next.getKey();
            Set<Long> relationIdSet = next.getValue();
            InvoiceRelation invoiceRelation = new InvoiceRelation(mainView, relationEnumMap.get(mainViewId), mainViewId, relationIdSet);
            relations.add(invoiceRelation);
        }
        return relations;
    }

    public static final List<InvoiceRelation> getAllInvoiceRelation(DynamicObject dataEntity, RelationMainView mainView) {
        Map<Long, Set<Long>> relationMap = InvoiceUtils2.getRelationMap(dataEntity, mainView);
        if (MapUtils.isEmpty(relationMap)) {
            return new ArrayList<InvoiceRelation>();
        }
        ArrayList<InvoiceRelation> relations = new ArrayList<InvoiceRelation>(relationMap.size());
        Map<Long, ItemInvoiceRelationEnum> relationEnumMap = InvoiceUtils2.getRelationEnum(dataEntity, mainView);
        for (Map.Entry<Long, Set<Long>> next : relationMap.entrySet()) {
            Long mainViewId = next.getKey();
            Set<Long> relationIdSet = next.getValue();
            InvoiceRelation invoiceRelation = new InvoiceRelation(mainView, relationEnumMap.get(mainViewId), mainViewId, relationIdSet);
            relations.add(invoiceRelation);
        }
        return relations;
    }

    public static final boolean autoInvoice(Object dataObj) {
        DynamicObject dataEntity;
        boolean autoInvoice = false;
        if (dataObj instanceof IDataModel) {
            IDataModel dataModel = (IDataModel)dataObj;
            if (dataModel.getProperty("automapinvoice") != null) {
                autoInvoice = (Boolean)dataModel.getValue("automapinvoice");
            }
        } else if (dataObj instanceof DynamicObject && (dataEntity = (DynamicObject)dataObj).containsProperty("automapinvoice")) {
            autoInvoice = dataEntity.getBoolean("automapinvoice");
        }
        return autoInvoice;
    }

    public static final Map<Long, Set<Long>> getRelationMap(Object dataObj, RelationMainView mainView) {
        Map<Long, Set<Long>> relationMap = new HashMap<Long, Set<Long>>();
        if (dataObj instanceof DynamicObject) {
            DynamicObject dataEntity = (DynamicObject)dataObj;
            boolean autoInvoice = InvoiceUtils2.autoInvoice(dataEntity);
            if (mainView == RelationMainView.VIEW_INVOICE) {
                relationMap = autoInvoice ? InvoiceUtils2.autoMapItemMappingInfoCache(dataEntity, "autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache(dataEntity, "nonAutoMapItemMappingInfo");
            } else if (mainView == RelationMainView.VIEW_EXPENSE) {
                relationMap = autoInvoice ? InvoiceUtils2.autoMapInvoiceMappingInfoCache(dataEntity, "autoMapInvoiceMappingInfo") : InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache(dataEntity, "nonAutoMapInvoiceMappingInfo");
            }
        } else if (dataObj instanceof IFormView) {
            IFormView view = (IFormView)dataObj;
            IDataModel dataModel = view.getModel();
            boolean autoInvoice = InvoiceUtils2.autoInvoice(dataModel);
            if (mainView == RelationMainView.VIEW_INVOICE) {
                relationMap = autoInvoice ? InvoiceUtils2.autoMapItemMappingInfoCache(view, dataModel, "autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache(view, dataModel, "nonAutoMapItemMappingInfo");
            } else if (mainView == RelationMainView.VIEW_EXPENSE) {
                relationMap = autoInvoice ? InvoiceUtils2.autoMapInvoiceMappingInfoCache(dataModel, "autoMapInvoiceMappingInfo") : InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache(dataModel, "nonAutoMapInvoiceMappingInfo");
            }
        }
        return relationMap;
    }

    public static final Map<Long, ItemInvoiceRelationEnum> getRelationEnum(DynamicObject dataEntity, RelationMainView mainView) {
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataEntity, RelationMainView.VIEW_EXPENSE);
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataEntity, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(expenseMapInvoice) || MapUtils.isEmpty(invoiceMapExpense)) {
            return new HashMap<Long, ItemInvoiceRelationEnum>();
        }
        Map<Long, ItemInvoiceRelationEnum> relationEnumMap = new HashMap<Long, ItemInvoiceRelationEnum>();
        if (mainView == RelationMainView.VIEW_INVOICE) {
            Set<Long> invoiceHeadIdSet = invoiceMapExpense.keySet();
            relationEnumMap = InvoiceUtils2.getInvoiceRelationEnum(dataEntity, invoiceHeadIdSet);
        } else if (mainView == RelationMainView.VIEW_EXPENSE) {
            Set<Long> expenseIdSet = expenseMapInvoice.keySet();
            relationEnumMap = InvoiceUtils2.getExpenseRelationEnum(dataEntity, expenseIdSet);
        }
        return relationEnumMap;
    }

    public static final Map<Long, ItemInvoiceRelationEnum> getRelationEnum(IFormView view, RelationMainView mainView) {
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(view, RelationMainView.VIEW_EXPENSE);
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(view, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(expenseMapInvoice) || MapUtils.isEmpty(invoiceMapExpense)) {
            return new HashMap<Long, ItemInvoiceRelationEnum>();
        }
        Map<Long, ItemInvoiceRelationEnum> relationEnumMap = new HashMap<Long, ItemInvoiceRelationEnum>();
        if (mainView == RelationMainView.VIEW_INVOICE) {
            Set<Long> invoiceHeadIdSet = invoiceMapExpense.keySet();
            relationEnumMap = InvoiceUtils2.getInvoiceRelationEnum(view, invoiceHeadIdSet);
        } else if (mainView == RelationMainView.VIEW_EXPENSE) {
            Set<Long> expenseIdSet = expenseMapInvoice.keySet();
            relationEnumMap = InvoiceUtils2.getExpenseRelationEnum(view, expenseIdSet);
        }
        return relationEnumMap;
    }

    private static final boolean expenseIsOneToOne(Object dataObj, Long expenseId) {
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Set<Long> invoiceHeadIdSet = expenseMapInvoice.get(expenseId);
        if (invoiceHeadIdSet == null || invoiceHeadIdSet.size() != 1) {
            return false;
        }
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Long invoiceId = (Long)invoiceHeadIdSet.stream().iterator().next();
        Set<Long> expenseIdSet = invoiceMapExpense.get(invoiceId);
        return expenseIdSet != null && expenseIdSet.size() == 1;
    }

    private static final boolean expenseIsOneToN(Object dataObj, Long expenseId) {
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Set<Long> invoiceHeadIdSet = expenseMapInvoice.get(expenseId);
        if (invoiceHeadIdSet == null || invoiceHeadIdSet.size() <= 1) {
            return false;
        }
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Map<Long, Set<Long>> finalInvoiceMapExpense = invoiceMapExpense;
        boolean allMatch = invoiceHeadIdSet.stream().allMatch(invoiceHeadId -> {
            Set expenseIdSet = (Set)finalInvoiceMapExpense.get(invoiceHeadId);
            return expenseIdSet != null && expenseIdSet.size() == 1 && expenseIdSet.contains(expenseId);
        });
        return allMatch;
    }

    private static final boolean expenseIsNToOne(Object dataObj, Long expenseId) {
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Set<Long> invoiceHeadIdSet = expenseMapInvoice.get(expenseId);
        if (invoiceHeadIdSet == null || invoiceHeadIdSet.size() != 1) {
            return false;
        }
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Long invoiceHeadId = invoiceHeadIdSet.iterator().next();
        Set<Long> expenseIdSet = invoiceMapExpense.get(invoiceHeadId);
        Map<Long, Set<Long>> finalExpenseMapInvoice = expenseMapInvoice;
        boolean allMatch = expenseIdSet.stream().allMatch(innerExpenseId -> {
            Set innerInvoiceHeadIdSet = (Set)finalExpenseMapInvoice.get(innerExpenseId);
            return innerInvoiceHeadIdSet != null && innerInvoiceHeadIdSet.size() == 1 && innerInvoiceHeadIdSet.contains(invoiceHeadId);
        });
        return allMatch;
    }

    private static final boolean invoiceIsOneToOne(Object dataObj, Long invoiceHeadId) {
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Set<Long> expenseIdSet = invoiceMapExpense.get(invoiceHeadId);
        if (expenseIdSet == null || expenseIdSet.size() != 1) {
            return false;
        }
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Long expenseId = expenseIdSet.iterator().next();
        Set<Long> invoiceHeadIdSet = expenseMapInvoice.get(expenseId);
        return invoiceHeadIdSet != null && invoiceHeadIdSet.size() == 1;
    }

    private static final boolean invoiceIsOneToN(Object dataObj, Long invoiceHeadId) {
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Set<Long> expenseIdSet = invoiceMapExpense.get(invoiceHeadId);
        if (expenseIdSet == null || expenseIdSet.size() != 1) {
            return false;
        }
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Long expenseId = expenseIdSet.iterator().next();
        Set<Long> invoiceHeadIdSet = expenseMapInvoice.get(expenseId);
        if (invoiceHeadIdSet == null || invoiceHeadIdSet.size() <= 1) {
            return false;
        }
        Map<Long, Set<Long>> finalInvoiceMapExpense = invoiceMapExpense;
        boolean allMatch = invoiceHeadIdSet.stream().allMatch(innerInvoiceHeadId -> {
            Set innerExpenseIdSet = (Set)finalInvoiceMapExpense.get(innerInvoiceHeadId);
            return innerExpenseIdSet != null && innerExpenseIdSet.size() == 1 && innerExpenseIdSet.contains(expenseId);
        });
        return allMatch;
    }

    private static final boolean invoiceIsNToOne(Object dataObj, Long invoiceHeadId) {
        Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
        if (MapUtils.isEmpty(invoiceMapExpense)) {
            return false;
        }
        Set<Long> expenseIdSet = invoiceMapExpense.get(invoiceHeadId);
        if (expenseIdSet == null || expenseIdSet.size() <= 1) {
            return false;
        }
        Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
        if (MapUtils.isEmpty(expenseMapInvoice)) {
            return false;
        }
        Map<Long, Set<Long>> finalExpenseMapInvoice = expenseMapInvoice;
        boolean allMatch = expenseIdSet.stream().allMatch(expenseId -> {
            Set invoiceHeadIdSet = (Set)finalExpenseMapInvoice.get(expenseId);
            return invoiceHeadIdSet != null && invoiceHeadIdSet.size() == 1 && invoiceHeadIdSet.contains(invoiceHeadId);
        });
        return allMatch;
    }

    public static final Map<Long, ItemInvoiceRelationEnum> getExpenseRelationEnum(Object dataObj, Set<Long> expenseIdSet) {
        HashMap<Long, ItemInvoiceRelationEnum> expenseRelationEnumMap = (HashMap<Long, ItemInvoiceRelationEnum>)ThreadCache.get((Object)"expenserelationenum");
        if (MapUtils.isNotEmpty((Map)expenseRelationEnumMap)) {
            return expenseRelationEnumMap;
        }
        expenseRelationEnumMap = new HashMap<Long, ItemInvoiceRelationEnum>();
        if (CollectionUtils.isEmpty(expenseIdSet)) {
            return expenseRelationEnumMap;
        }
        for (Long expenseId : expenseIdSet) {
            Set<Long> invoiceHeadIds;
            Map<Long, Set<Long>> expenseMapInvoice = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_EXPENSE);
            if (!MapUtils.isNotEmpty(expenseMapInvoice) || CollectionUtils.isEmpty(invoiceHeadIds = expenseMapInvoice.get(expenseId))) continue;
            if (InvoiceUtils2.expenseIsOneToOne(dataObj, expenseId)) {
                expenseRelationEnumMap.put(expenseId, ItemInvoiceRelationEnum.IsOneForOne);
                continue;
            }
            if (InvoiceUtils2.expenseIsOneToN(dataObj, expenseId)) {
                expenseRelationEnumMap.put(expenseId, ItemInvoiceRelationEnum.IsOneForN);
                continue;
            }
            if (InvoiceUtils2.expenseIsNToOne(dataObj, expenseId)) {
                expenseRelationEnumMap.put(expenseId, ItemInvoiceRelationEnum.IsNForOne);
                continue;
            }
            expenseRelationEnumMap.put(expenseId, ItemInvoiceRelationEnum.IsNForN);
        }
        ThreadCache.put((Object)"expenserelationenum", expenseRelationEnumMap);
        return expenseRelationEnumMap;
    }

    public static final Map<Long, ItemInvoiceRelationEnum> getInvoiceRelationEnum(Object dataObj, Set<Long> invoiceIdSet) {
        HashMap<Long, ItemInvoiceRelationEnum> invoiceRelationEnumMap = (HashMap<Long, ItemInvoiceRelationEnum>)ThreadCache.get((Object)"invoicerelationenum");
        if (MapUtils.isNotEmpty((Map)invoiceRelationEnumMap)) {
            return invoiceRelationEnumMap;
        }
        invoiceRelationEnumMap = new HashMap<Long, ItemInvoiceRelationEnum>();
        if (CollectionUtils.isEmpty(invoiceIdSet)) {
            return invoiceRelationEnumMap;
        }
        for (Long invoiceId : invoiceIdSet) {
            Set<Long> expenseIdSet;
            Map<Long, Set<Long>> invoiceMapExpense = InvoiceUtils2.getRelationMap(dataObj, RelationMainView.VIEW_INVOICE);
            if (!MapUtils.isNotEmpty(invoiceMapExpense) || CollectionUtils.isEmpty(expenseIdSet = invoiceMapExpense.get(invoiceId))) continue;
            if (InvoiceUtils2.invoiceIsOneToOne(dataObj, invoiceId)) {
                invoiceRelationEnumMap.put(invoiceId, ItemInvoiceRelationEnum.IsOneForOne);
                continue;
            }
            if (InvoiceUtils2.invoiceIsOneToN(dataObj, invoiceId)) {
                invoiceRelationEnumMap.put(invoiceId, ItemInvoiceRelationEnum.IsOneForN);
                continue;
            }
            if (InvoiceUtils2.invoiceIsNToOne(dataObj, invoiceId)) {
                invoiceRelationEnumMap.put(invoiceId, ItemInvoiceRelationEnum.IsNForOne);
                continue;
            }
            invoiceRelationEnumMap.put(invoiceId, ItemInvoiceRelationEnum.IsNForN);
        }
        ThreadCache.put((Object)"invoicerelationenum", invoiceRelationEnumMap);
        return invoiceRelationEnumMap;
    }

    private static Map<Long, Set<Long>> autoMapInvoiceMappingInfoCache(DynamicObject dataEntity, String cacheKey) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils2.getInvoiceItemCollCache(dataEntity, "invoiceitementry", "itementryid", "invoiceheadentryid", cacheKey);
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        HashMap splitLine = new HashMap();
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(dataEntity.get("billkind"))) {
                entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            Map parentId_curIdSet = entryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && StringUtils.isNotEmpty((CharSequence)obj.getString("splitline"))).collect(Collectors.groupingBy(expense -> Long.parseLong(expense.getString("splitline")), Collectors.mapping(expense -> (Long)expense.getPkValue(), Collectors.toSet())));
            invoiceItemMap.forEach((key, value) -> {
                Set sonId_split = (Set)parentId_curIdSet.get(key);
                if (sonId_split != null && sonId_split.size() > 0) {
                    for (Long pkValue : sonId_split) {
                        splitLine.put(pkValue, value);
                    }
                }
            });
            if (!splitLine.isEmpty()) {
                invoiceItemMap.putAll(splitLine);
            }
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> autoMapInvoiceMappingInfoCache(IDataModel model, String cacheKey) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils2.getInvoiceItemCollCache(model, "invoiceitementry", "itementryid", "invoiceheadentryid", cacheKey);
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        HashMap splitLine = new HashMap();
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(model.getValue("billkind"))) {
                entryEntity = model.getEntryEntity("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = model.getEntryEntity("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            Map parentId_curIdSet = entryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && StringUtils.isNotEmpty((CharSequence)obj.getString("splitline"))).collect(Collectors.groupingBy(expense -> Long.parseLong(expense.getString("splitline")), Collectors.mapping(expense -> (Long)expense.getPkValue(), Collectors.toSet())));
            invoiceItemMap.forEach((key, value) -> {
                Set sonId_split = (Set)parentId_curIdSet.get(key);
                if (sonId_split != null && sonId_split.size() > 0) {
                    for (Long pkValue : sonId_split) {
                        splitLine.put(pkValue, value);
                    }
                }
            });
            if (!splitLine.isEmpty()) {
                invoiceItemMap.putAll(splitLine);
            }
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> getInvoiceItemCollCache(Object dataObj, String entryKey, String key, String value, String cacheKey) {
        HashMap<Long, Set<Long>> invoiceItemMap = (HashMap<Long, Set<Long>>)ThreadCache.get((Object)cacheKey);
        if (invoiceItemMap != null) {
            return invoiceItemMap;
        }
        invoiceItemMap = new HashMap<Long, Set<Long>>();
        DynamicObjectCollection invoiceItemColl = null;
        if (dataObj instanceof IDataModel) {
            invoiceItemColl = ((IDataModel)dataObj).getEntryEntity(entryKey);
        } else if (dataObj instanceof DynamicObject) {
            invoiceItemColl = ((DynamicObject)dataObj).getDynamicObjectCollection(entryKey);
        }
        if (invoiceItemColl == null || invoiceItemColl.isEmpty()) {
            return invoiceItemMap;
        }
        for (DynamicObject entry : invoiceItemColl) {
            Long keyId = entry.getLong(key);
            if (keyId == 0L) continue;
            Long valueId = entry.getLong(value);
            HashSet<Long> valueIds = (HashSet<Long>)invoiceItemMap.get(keyId);
            if (valueIds == null) {
                valueIds = new HashSet<Long>();
                invoiceItemMap.put(keyId, valueIds);
            }
            valueIds.add(valueId);
        }
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        ThreadCache.put((Object)cacheKey, invoiceItemMap);
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> autoMapItemMappingInfoCache(IFormView view, IDataModel model, String cacheKey) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils2.getInvoiceItemCollCache(model, "invoiceitementry", "invoiceheadentryid", "itementryid", cacheKey);
        if (!invoiceItemMap.isEmpty()) {
            invoiceItemMap = InvoiceUtils2.getSplitInvoiceMapping(model, invoiceItemMap, "autoMapItemSplitMappingInfo");
        }
        invoiceItemMap = InvoiceUtils2.getParentInvoiceMapping(view, invoiceItemMap);
        return invoiceItemMap;
    }

    private static Map<Long, Set<Long>> autoMapItemMappingInfoCache(DynamicObject dataEntity, String cacheKey) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils2.getInvoiceItemCollCache(dataEntity, "invoiceitementry", "invoiceheadentryid", "itementryid", cacheKey);
        if (!invoiceItemMap.isEmpty()) {
            invoiceItemMap = InvoiceUtils2.getSplitInvoiceMapping(dataEntity, invoiceItemMap, "autoMapItemSplitMappingInfo");
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> getSplitInvoiceMapping(IDataModel model, Map<Long, Set<Long>> invoiceItemMap, String cacheKey) {
        Map splitInvoiceMapping = (Map)ThreadCache.get((Object)cacheKey);
        if (splitInvoiceMapping != null) {
            return splitInvoiceMapping;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(model.getValue("billkind"))) {
                entryEntity = model.getEntryEntity("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = model.getEntryEntity("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            Map parentId_curIdSet = entryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && StringUtils.isNotEmpty((CharSequence)obj.getString("splitline"))).collect(Collectors.groupingBy(expense -> Long.parseLong(expense.getString("splitline")), Collectors.mapping(expense -> (Long)expense.getPkValue(), Collectors.toSet())));
            invoiceItemMap.forEach((key, value) -> parentId_curIdSet.forEach((parentId, sonIdSet) -> {
                if (value.contains(parentId)) {
                    value.addAll(sonIdSet);
                }
            }));
        }
        ThreadCache.put((Object)cacheKey, invoiceItemMap);
        return invoiceItemMap;
    }

    private static Map<Long, Set<Long>> getSplitInvoiceMapping(DynamicObject dataEntity, Map<Long, Set<Long>> invoiceItemMap, String cacheKey) {
        Map splitInvoiceMapping = (Map)ThreadCache.get((Object)cacheKey);
        if (splitInvoiceMapping != null) {
            return splitInvoiceMapping;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(dataEntity.get("billkind"))) {
                entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            Map parentId_curIdSet = entryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && StringUtils.isNotEmpty((CharSequence)obj.getString("splitline"))).collect(Collectors.groupingBy(expense -> Long.parseLong(expense.getString("splitline")), Collectors.mapping(expense -> (Long)expense.getPkValue(), Collectors.toSet())));
            invoiceItemMap.forEach((key, value) -> parentId_curIdSet.forEach((parentId, sonIdSet) -> {
                if (value.contains(parentId)) {
                    value.addAll(sonIdSet);
                }
            }));
        }
        ThreadCache.put((Object)cacheKey, invoiceItemMap);
        return invoiceItemMap;
    }

    private static Map<Long, Set<Long>> getParentInvoiceMapping(IFormView view, Map<Long, Set<Long>> invoiceItemMap) {
        IDataEntityProperty invoiceEntryProp;
        IDataModel pModel;
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null && (pModel = parentView.getModel()) != null && (invoiceEntryProp = pModel.getProperty("invoiceitementry")) != null) {
            Map<Long, Set<Long>> pInvoiceItemMap = InvoiceUtils2.getInvoiceItemCollCache(pModel, "invoiceitementry", "invoiceheadentryid", "itementryid", "autoMapInvoiceMappingInfoParent");
            if (!pInvoiceItemMap.isEmpty()) {
                pInvoiceItemMap = InvoiceUtils2.getSplitInvoiceMapping(pModel, pInvoiceItemMap, "autoMapItemSplitParentMappingInfo");
            }
            pInvoiceItemMap.forEach((invoiceHeadId, set) -> {
                if (invoiceItemMap.get(invoiceHeadId) != null) {
                    ((Set)invoiceItemMap.get(invoiceHeadId)).addAll(set);
                } else {
                    invoiceItemMap.put((Long)invoiceHeadId, (Set<Long>)set);
                }
            });
            return invoiceItemMap;
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> nonAutoMapItemMappingInfoCache(IFormView view, IDataModel model, String cacheKey) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils2.getInvoiceItemCollCache(model, "invoiceandexpense", "invoiceentryid", "expenseentryid", cacheKey);
        return invoiceAndItemMap;
    }

    private static Map<Long, Set<Long>> nonAutoMapItemMappingInfoCache(DynamicObject dataEntity, String cacheKey) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils2.getInvoiceItemCollCache(dataEntity, "invoiceandexpense", "invoiceentryid", "expenseentryid", cacheKey);
        return invoiceAndItemMap;
    }

    public static Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfoCache(IDataModel dataModel, String cacheKey) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils2.getInvoiceItemCollCache(dataModel, "invoiceandexpense", "expenseentryid", "invoiceentryid", cacheKey);
        return invoiceAndItemMap;
    }

    private static Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfoCache(DynamicObject dataEntity, String cacheKey) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils2.getInvoiceItemCollCache(dataEntity, "invoiceandexpense", "expenseentryid", "invoiceentryid", cacheKey);
        return invoiceAndItemMap;
    }

    public static List<Long> getPkValueSet(IDataModel dataModel, String entryKey, int[] rowIndexs) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(entryKey);
        List<Long> idSet = Arrays.stream(rowIndexs).mapToObj(index -> {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
            if (dynamicObject != null) {
                return (Long)dynamicObject.getPkValue();
            }
            return 0L;
        }).filter(id -> id != null && !id.equals(0L)).collect(Collectors.toList());
        return idSet;
    }

    public static int[] getIndexes(IDataModel dataModel, String entryKey, Set<Long> pkValues) {
        return InvoiceUtils2.getIndexes(dataModel, entryKey, pkValues, true);
    }

    public static int[] getIndexes(IDataModel dataModel, String entryKey) {
        return InvoiceUtils2.getIndexes(dataModel, entryKey, true);
    }

    public static int[] getIndexes(IDataModel dataModel, String entryKey, boolean readCache) {
        Map<Long, Integer> indexMap = InvoiceUtils2.getIndexesMap(dataModel, entryKey, readCache);
        int[] indexes = indexMap.values().stream().mapToInt(Integer::intValue).toArray();
        return indexes;
    }

    public static int[] getIndexes(IDataModel dataModel, String entryKey, Set<Long> pkValues, boolean readCache) {
        Map<Long, Integer> indexMap = InvoiceUtils2.getIndexesMap(dataModel, entryKey, readCache);
        int[] indexes = pkValues.stream().filter(pk -> indexMap.get(pk) != null).mapToInt(pk -> (Integer)indexMap.get(pk)).toArray();
        return indexes;
    }

    public static Map<Long, Integer> getIndexesMap(IDataModel dataModel, String entryKey, boolean readCache) {
        DynamicObjectCollection entryEntity = dataModel.getEntryEntity(entryKey);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return new HashMap<Long, Integer>();
        }
        String cacheKey = "pkseqmap_" + entryKey;
        Map<Long, Integer> pkSeqMap = new HashMap();
        if (readCache) {
            pkSeqMap = (Map)ThreadCache.get((Object)cacheKey);
        }
        if (MapUtils.isNotEmpty(pkSeqMap) && pkSeqMap.size() == entryEntity.size()) {
            return pkSeqMap;
        }
        pkSeqMap = new HashMap();
        boolean hasNullId = entryEntity.stream().anyMatch(entity -> entity.getPkValue() == null || (Long)entity.getPkValue() == 0L);
        if (hasNullId) {
            ThreadCache.remove((Object)cacheKey);
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                Long pkValue = (Long)dynamicObject.getPkValue();
                if (pkValue == null || pkValue == 0L) continue;
                pkSeqMap.put(pkValue, index);
            }
        } else {
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(index);
                Long pkValue = (Long)dynamicObject.getPkValue();
                if (pkValue == null || pkValue == 0L) continue;
                pkSeqMap.put(pkValue, index);
            }
            ThreadCache.put((Object)cacheKey, pkSeqMap);
        }
        return pkSeqMap;
    }

    public static void clearIndexesCache(String entryKey) {
        ThreadCache.remove((Object)("pkseqmap_" + entryKey));
    }

    public static void clearCacheRelation() {
        ThreadCache.remove((Object)"isAutomapinvoice");
        ThreadCache.remove((Object)"autoMapInvoiceMappingInfo");
        ThreadCache.remove((Object)"autoMapItemMappingInfo");
        ThreadCache.remove((Object)"nonAutoMapInvoiceMappingInfo");
        ThreadCache.remove((Object)"nonAutoMapItemMappingInfo");
        ThreadCache.remove((Object)"autoMapInvoiceMappingInfoParent");
        ThreadCache.remove((Object)"autoMapItemSplitParentMappingInfo");
        ThreadCache.remove((Object)"autoMapItemSplitMappingInfo");
        ThreadCache.remove((Object)"expenserelationenum");
        ThreadCache.remove((Object)"invoicerelationenum");
    }
}

