/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.model.invoice.bill;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.common.model.invoice.bill.Item;

public enum BillOfInvoice {
    TripReimburseBill("entryentity", "expenseitem", "isvactax", Item.TripItem){

        @Override
        public Map<Integer, DynamicObjectCollection> getExpenseEntryEntities(DynamicObject dataEntity) {
            DynamicObjectCollection tripEntries = dataEntity.getDynamicObjectCollection("tripentry");
            if (tripEntries == null || tripEntries.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            HashMap<Integer, DynamicObjectCollection> map = new HashMap<Integer, DynamicObjectCollection>(tripEntries.size());
            for (int tripIndex = 0; tripIndex < tripEntries.size(); ++tripIndex) {
                map.put(tripIndex, ((DynamicObject)tripEntries.get(tripIndex)).getDynamicObjectCollection("entryentity"));
            }
            return map;
        }
    }
    ,
    DailyReimburseBill("expenseentryentity", "expenseitem", "is_special_invoice", Item.ExpenseItem){

        public DynamicObjectCollection getExpenseEntryEntities(DynamicObject dataEntity) {
            return dataEntity.getDynamicObjectCollection("expenseentryentity");
        }
    }
    ,
    CheckingPayBill("entryentity", "", "", null){

        public DynamicObjectCollection getExpenseEntryEntities(DynamicObject dataEntity) {
            return dataEntity.getDynamicObjectCollection("expenseentryentity");
        }
    };

    private final String expenseEntryEntityName;
    private final String expenseItemKey;
    private final String isVacTaxName;
    private final Item item;

    private BillOfInvoice(String expenseEntryEntityName, String expenseItemKey, String isVacTaxName, Item item) {
        this.expenseEntryEntityName = expenseEntryEntityName;
        this.expenseItemKey = expenseItemKey;
        this.isVacTaxName = isVacTaxName;
        this.item = item;
    }

    public abstract Object getExpenseEntryEntities(DynamicObject var1);

    public String getExpenseEntryEntityName() {
        return this.expenseEntryEntityName;
    }

    public String getExpenseItemKey() {
        return this.expenseItemKey;
    }

    public String getIsVacTaxName() {
        return this.isVacTaxName;
    }

    public Item getItem() {
        return this.item;
    }
}

