/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Er {
    public static String objToJson(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T jsonToObj(String json, Class<T> clazz) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String join(Collection col, String sep) {
        return col.stream().map(v -> v != null ? v.toString() : "null").collect(Collectors.joining(sep));
    }

    public static <T, K extends Collection<T>> String join(K col, Function<T, String> mapper, String sep) {
        return col.stream().map(mapper).collect(Collectors.joining(sep));
    }

    public static boolean matchLuhn(String cardNo) {
        int i;
        String regEx = "[^0-9]";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(cardNo);
        if (matcher.find()) {
            return false;
        }
        int[] cardNoArr = new int[cardNo.length()];
        for (i = 0; i < cardNo.length(); ++i) {
            cardNoArr[i] = Integer.parseInt(String.valueOf(cardNo.charAt(i)));
        }
        for (i = cardNoArr.length - 2; i >= 0; i -= 2) {
            int n = i;
            cardNoArr[n] = cardNoArr[n] << 1;
            cardNoArr[i] = cardNoArr[i] / 10 + cardNoArr[i] % 10;
        }
        int sum = 0;
        for (int i2 = 0; i2 < cardNoArr.length; ++i2) {
            sum += cardNoArr[i2];
        }
        return sum % 10 == 0;
    }
}

