/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.common.utils.Er;

public class YearForwardOpPlugin
extends AbstractOperationServicePlugIn {
    private List<DynamicObject> destBills = new ArrayList<DynamicObject>();
    private String selectProperties = null;
    private boolean isDeptQuota = false;
    private static final String[] QUARTER_PROP_NAME_ARR = new String[]{"quarter1", "quarter2", "quarter3", "quarter4"};
    private static final String[] MONTH_PROP_NAME_ARR = new String[]{"month1", "month2", "month3", "month4", "month5", "month6", "month7", "month8", "month9", "month10", "month11", "month12"};
    private static final Log logger = LogFactory.getLog(YearForwardOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("company");
        fieldKeys.add("employee");
        fieldKeys.add("dept");
        fieldKeys.add("expenseitem");
        fieldKeys.add("currency");
        fieldKeys.add("controlmethod");
        fieldKeys.add("totalamount");
        fieldKeys.add("isyearforward");
        fieldKeys.add("month1");
        fieldKeys.add("month2");
        fieldKeys.add("month3");
        fieldKeys.add("month4");
        fieldKeys.add("month5");
        fieldKeys.add("month6");
        fieldKeys.add("month7");
        fieldKeys.add("month8");
        fieldKeys.add("month9");
        fieldKeys.add("month10");
        fieldKeys.add("month11");
        fieldKeys.add("month12");
        fieldKeys.add("quarter1");
        fieldKeys.add("quarter2");
        fieldKeys.add("quarter3");
        fieldKeys.add("quarter4");
        this.selectProperties = Er.join((Collection)fieldKeys, (String)",");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                OperateOption option = this.getOption();
                int choosedateyear = Integer.parseInt(option.getVariableValue("choosedateyear"));
                boolean isAssignPeriod = Boolean.parseBoolean(option.getVariableValue("isAssignPeriod"));
                int assignedPeriod = 0;
                if (isAssignPeriod) {
                    assignedPeriod = Integer.parseInt(option.getVariableValue("assignedPeriod"));
                }
                String entityName = "";
                ExtendedDataEntity[] dataEntitiesArr = this.getDataEntities();
                if (dataEntitiesArr.length > 0) {
                    entityName = dataEntitiesArr[0].getDataEntity().getDynamicObjectType().getName();
                }
                YearForwardOpPlugin.this.isDeptQuota = "er_dept_reimctl".equalsIgnoreCase(entityName);
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    BigDecimal yearUsedQuota;
                    DynamicObject bill = entity.getDataEntity();
                    if (bill.getBoolean("isyearforward")) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5df2\u6267\u884c\u8fc7\u8de8\u5e74\u7ed3\u8f6c\u3002", (String)"YearForwardOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getDesc(bill)));
                        continue;
                    }
                    String thisYear = Year.now().getValue() + "";
                    QFilter[] qFilters = new QFilter[]{new QFilter("company", "=", bill.get("company_id")), new QFilter("expenseitem", "=", bill.get("expenseitem_id")), YearForwardOpPlugin.this.isDeptQuota ? new QFilter("dept", "=", bill.get("dept_id")) : new QFilter("employee", "=", bill.get("employee_id")), new QFilter("currency", "=", bill.get("currency_id")), new QFilter("dateyear", "=", (Object)thisYear)};
                    DynamicObject dest = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)YearForwardOpPlugin.this.selectProperties, (QFilter[])qFilters);
                    if (dest == null) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0d\u5b58\u5728\u76ee\u6807\u989d\u5ea6\u3002", (String)"YearForwardOpPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getDesc(bill)));
                        continue;
                    }
                    BigDecimal yearTotalQuota = bill.getBigDecimal("totalamount");
                    if (yearTotalQuota.compareTo(yearUsedQuota = this.getYearUsedQuota(choosedateyear, bill)) <= 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ed3\u8f6c\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u53ef\u7ed3\u8f6c\u989d\u5ea6\u3002", (String)"YearForwardOpPlugin_2", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getDesc(bill)));
                        continue;
                    }
                    this.carryOver(entity, choosedateyear, isAssignPeriod, assignedPeriod, bill, dest, yearUsedQuota);
                }
            }

            private String getDesc(DynamicObject bill) {
                if (YearForwardOpPlugin.this.isDeptQuota) {
                    return String.format("%1$s%2$s-%3$s", bill.getString("dept.number"), bill.getString("dept.name"), bill.getString("expenseitem.name"));
                }
                return String.format("%1$s%2$s-%3$s", bill.getString("employee.number"), bill.getString("employee.name"), bill.getString("expenseitem.name"));
            }

            private BigDecimal getYearUsedQuota(int year, DynamicObject bill) {
                String ctlMethod = bill.getString("expenseitem.reimburseamountctlmethod");
                ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)ctlMethod));
                BigDecimal orgToUsedAmount = null;
                orgToUsedAmount = YearForwardOpPlugin.this.isDeptQuota ? service.getDeptReimbursedAmountBetween(Long.valueOf(bill.getLong("company_id")), Long.valueOf(bill.getLong("dept.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), LocalDate.of(year, 1, 1), LocalDate.of(year, 12, 31), (List)Lists.newArrayList()) : service.getUserReimbursedAmountBetween(Long.valueOf(bill.getLong("company_id")), Long.valueOf(bill.getLong("employee.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), LocalDate.of(year, 1, 1), LocalDate.of(year, 12, 31), (List)Lists.newArrayList());
                return orgToUsedAmount;
            }

            /*
             * Enabled aggressive block sorting
             */
            private void carryOver(ExtendedDataEntity entity, int choosedateyear, boolean isAssignPeriod, int assignedPeriod, DynamicObject bill, DynamicObject dest, BigDecimal yearUsedQuota) {
                BigDecimal totalCarryQuota = BigDecimal.ZERO;
                String ctlMethod = bill.getString("expenseitem.reimburseamountctlmethod");
                BigDecimal used = BigDecimal.ZERO;
                if (!("A".equals(ctlMethod) || "B".equals(ctlMethod) || "E".equals(ctlMethod))) {
                    if ("C".equals(ctlMethod)) {
                        totalCarryQuota = bill.getBigDecimal("totalamount").subtract(yearUsedQuota);
                    }
                } else {
                    String[] propNameArr = QUARTER_PROP_NAME_ARR;
                    if ("A".equals(ctlMethod) || "B".equals(ctlMethod)) {
                        propNameArr = MONTH_PROP_NAME_ARR;
                    }
                    int periodCount = propNameArr.length;
                    BigDecimal[] usedQuotas = this.getPeriodUsedQuotas(choosedateyear, bill);
                    if (usedQuotas == null) {
                        this.addErrorMessage(entity, "usedQuotas is null");
                        return;
                    }
                    for (int i = 1; i <= periodCount; ++i) {
                        BigDecimal diffQuota;
                        String propName = propNameArr[i - 1];
                        BigDecimal quarterQuota = bill.getBigDecimal(propName);
                        BigDecimal usedQuota = usedQuotas[i - 1];
                        used = used.add(usedQuota);
                        if (quarterQuota.compareTo(usedQuota) <= 0) {
                            bill.set(propName, (Object)usedQuota);
                            if (!ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(ctlMethod)) continue;
                            diffQuota = quarterQuota.subtract(usedQuota);
                            totalCarryQuota = totalCarryQuota.add(diffQuota);
                            continue;
                        }
                        if (quarterQuota.compareTo(usedQuota) <= 0) continue;
                        bill.set(propName, (Object)usedQuota);
                        diffQuota = quarterQuota.subtract(usedQuota);
                        if (!isAssignPeriod) {
                            dest.set(propName, (Object)dest.getBigDecimal(propName).add(diffQuota));
                        }
                        totalCarryQuota = totalCarryQuota.add(diffQuota);
                    }
                    if (isAssignPeriod) {
                        String propName = propNameArr[assignedPeriod - 1];
                        dest.set(propName, (Object)dest.getBigDecimal(propName).add(totalCarryQuota));
                    }
                    if (bill.getBigDecimal("totalamount").subtract(yearUsedQuota).compareTo(totalCarryQuota) == 0) {
                        // empty if block
                    }
                }
                bill.set("totalamount", (Object)yearUsedQuota);
                logger.info("\u989d\u5ea6id: {},\u603b\u989d\u5ea6\uff1a {}\uff0c \u5df2\u7528\u989d\u5ea6\uff1a {}", new Object[]{bill.getPkValue(), bill.getBigDecimal("totalamount"), used});
                dest.set("totalamount", (Object)dest.getBigDecimal("totalamount").add(totalCarryQuota));
                YearForwardOpPlugin.this.destBills.add(dest);
            }

            private BigDecimal[] getPeriodUsedQuotas(int year, DynamicObject bill) {
                BigDecimal[] result;
                block3: {
                    ReimburseAmountControlService service;
                    String ctlMethod;
                    block2: {
                        ctlMethod = bill.getString("expenseitem.reimburseamountctlmethod");
                        service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)ctlMethod));
                        result = null;
                        if (!"A".equals(ctlMethod) && !"B".equals(ctlMethod)) break block2;
                        result = new BigDecimal[12];
                        for (int i = 1; i <= 12; ++i) {
                            YearMonth yearMonth = YearMonth.of(year, i);
                            BigDecimal reimbursedAmount = null;
                            reimbursedAmount = YearForwardOpPlugin.this.isDeptQuota ? service.getDeptReimbursedAmountBetween(Long.valueOf(bill.getLong("company.id")), Long.valueOf(bill.getLong("dept.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), yearMonth.atDay(1), yearMonth.atEndOfMonth(), (List)Lists.newArrayList()) : service.getUserReimbursedAmountBetween(Long.valueOf(bill.getLong("company.id")), Long.valueOf(bill.getLong("employee.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), yearMonth.atDay(1), yearMonth.atEndOfMonth(), (List)Lists.newArrayList());
                            result[i - 1] = reimbursedAmount;
                        }
                        break block3;
                    }
                    if (!"E".equals(ctlMethod)) break block3;
                    result = new BigDecimal[4];
                    for (int i = 1; i <= 4; ++i) {
                        BigDecimal reimbursedAmount = null;
                        reimbursedAmount = YearForwardOpPlugin.this.isDeptQuota ? service.getDeptReimbursedAmountByMonth(Long.valueOf(bill.getLong("company.id")), Long.valueOf(bill.getLong("dept.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), YearMonth.of(year, i * 3), (List)Lists.newArrayList()) : service.getReimbursedAmountByMonth(Long.valueOf(bill.getLong("company.id")), Long.valueOf(bill.getLong("employee.id")), Long.valueOf(bill.getLong("expenseitem.id")), Long.valueOf(bill.getLong("currency.id")), YearMonth.of(year, i * 3), (List)Lists.newArrayList());
                        result[i - 1] = reimbursedAmount;
                    }
                }
                return result;
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            bill.set("isyearforward", (Object)true);
            this.destBills.add(bill);
        }
        SaveServiceHelper.save((DynamicObject[])this.destBills.toArray(new DynamicObject[0]));
    }
}

