/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.amount.control;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.AttachmentSubmitValidator;
import kd.fi.er.validator.ReimburseTypeSettingValidator;
import kd.fi.er.validator.SensetiveFieldSubmitValidator;
import org.apache.commons.lang3.StringUtils;

public class FeeStandControlOp
extends AbstractOperationServicePlugIn {
    private static final QFilter statusFilter = new QFilter("billstatus", "not in", (Object)new String[]{"A", "D", "H"});
    private boolean summaryOver = Boolean.FALSE;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
        e.getFieldKeys().add("expenseentryentity.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FeeStandControlValidate());
        e.addValidator((AbstractValidator)new ReimburseTypeSettingValidator());
        e.addValidator((AbstractValidator)new SensetiveFieldSubmitValidator());
        e.addValidator((AbstractValidator)new AttachmentSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            Optional<DynamicObject> findAny = bill.getDynamicObjectCollection("expenseentryentity").stream().filter(v -> v.getBoolean("isover")).findAny();
            if (!findAny.isPresent() && !this.summaryOver) {
                bill.set("stdover", (Object)Boolean.FALSE);
                continue;
            }
            bill.set("stdover", (Object)Boolean.TRUE);
        }
    }

    private Object getValueSafe(DynamicObject entry, String field) {
        Object value = null;
        value = entry.getDynamicObjectType().getProperty(field) != null ? entry.get(field) : ((DynamicObject)entry.getParent()).get(field);
        return value;
    }

    private String getDisplayName(DynamicObject entry, String field) {
        return BillSettingRuleUtil.getDisplayName((DynamicObject)entry, (String)field);
    }

    class DimensionMonster {
        private String dimensionKey;
        private String indexDimensionKey;
        private String totolDimensionKey;
        private Map<String, Object> dimensionMap;
        private DynamicObject expenseitem;
        private DynamicObject currency;
        private DynamicObject company;
        private DynamicObject applier;
        private DynamicObject bizitem;
        private Date bizdate;
        private DynamicObject feeStand;

        public DimensionMonster(DynamicObject entry, List<String> dimensions, DynamicObject company, DynamicObject bizitem, DynamicObject feeStand, DynamicObject applier, Date bizdate) {
            this.initIndexDimension(entry, company, bizitem);
            this.buildDimensionMap(entry, dimensions);
            this.totolDimensionKey = this.indexDimensionKey.concat(this.dimensionKey);
            this.feeStand = feeStand;
            this.applier = applier;
            this.bizitem = bizitem;
            this.bizdate = bizdate;
        }

        private void initIndexDimension(DynamicObject entry, DynamicObject company, DynamicObject bizitem) {
            this.company = company;
            this.expenseitem = entry.getDynamicObject("expenseitem");
            this.currency = FeeStandardHelper.headCurrencyControl() ? entry.getDynamicObject("feestandcurrency") : entry.getDynamicObject("entrycurrency");
            this.indexDimensionKey = String.format("c:%1s|e:%2s|cu:%3s|st:%4s", this.format(this.company), this.format(this.expenseitem), this.format(this.currency), this.format(bizitem));
        }

        private void buildDimensionMap(DynamicObject entry, List<String> dimensions) {
            this.dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            StringBuilder sb = new StringBuilder();
            for (String field : dimensions) {
                Object value = FeeStandControlOp.this.getValueSafe(entry, field);
                this.dimensionMap.put(field, value);
                sb.append(field).append(":").append(this.format(value)).append("|");
            }
            this.dimensionKey = sb.toString();
        }

        private String format(Object value) {
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue().toString();
            }
            return value == null ? "null" : value.toString();
        }

        public String getTotolDimensionKey() {
            return this.totolDimensionKey;
        }

        public Map<String, Object> getDimensionMap() {
            return this.dimensionMap;
        }

        public DynamicObject getFeeStand() {
            return this.feeStand;
        }

        public QFilter[] getBillFilter() {
            QFilter q1 = new QFilter("expenseentryentity.expenseitem", "=", this.expenseitem.getPkValue());
            QFilter q2 = FeeStandardHelper.headCurrencyControl() ? new QFilter("expenseentryentity.feestandcurrency", "=", this.currency.getPkValue()) : new QFilter("expenseentryentity.entrycurrency", "=", this.currency.getPkValue());
            QFilter q4 = new QFilter("bizitem", "=", this.bizitem.getPkValue());
            QFilter q5 = new QFilter("company", "=", this.company.getPkValue());
            QFilter q6 = this.getTimeFilter();
            QFilter q7 = new QFilter("applier", "=", this.applier.getPkValue());
            return new QFilter[]{q1, q2, q4, q5, q6, q7, statusFilter};
        }

        private QFilter getTimeFilter() {
            String ctlPeriod = this.feeStand.getString("ctlperiod");
            Date[] periodDate = FeeStandardHelper.getPeriodDate((String)ctlPeriod, (Date)this.bizdate);
            return QFilter.of((String)"bizdate >= ? and bizdate <= ?", (Object[])new Object[]{periodDate[0], periodDate[1]});
        }
    }

    class FeeStandControlValidate
    extends AbstractValidator {
        FeeStandControlValidate() {
        }

        public void validate() {
            Set pks = Stream.of(this.getDataEntities()).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toSet());
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DimensionMonster dimensionMonster;
                int seq;
                DynamicObject entry;
                int rowIndex;
                List<DynamicObject> expenseentryentity;
                DynamicObject bill = extendedDataEntity.getDataEntity();
                if (bill.getDynamicObject("company") == null) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                boolean openFeeStand = FeeStandardHelper.isOpenFeeStand((DynamicObject)bill.getDynamicObject("bizitem"), (Long)((Long)bill.getDynamicObject("company").getPkValue()));
                if (!openFeeStand) continue;
                DynamicObject company = bill.getDynamicObject("company");
                Date bizdate = bill.getDate("bizdate");
                DynamicObject bizItem = bill.getDynamicObject("bizitem");
                List dimensions = FeeStandardHelper.collectDimension((DynamicObject)bizItem);
                if (this.checkMustInput(extendedDataEntity, dimensions, expenseentryentity = bill.getDynamicObjectCollection("expenseentryentity").stream().filter(v -> "3".equals(v.getDynamicObject("expenseitem") == null ? "null" : v.getDynamicObject("expenseitem").getString("isreimburseamountctl"))).collect(Collectors.toList()))) continue;
                ArrayListMultimap dimensionKeyMap = ArrayListMultimap.create();
                HashMap dimensionMonsterMap = Maps.newHashMapWithExpectedSize((int)expenseentryentity.size());
                for (rowIndex = 0; rowIndex < expenseentryentity.size(); ++rowIndex) {
                    entry = expenseentryentity.get(rowIndex);
                    seq = entry.getInt("seq");
                    dimensionMonster = new DimensionMonster(entry, dimensions, company, bizItem, entry.getDynamicObject("feestandid"), bill.getDynamicObject("applier"), bizdate);
                    dimensionMonsterMap.put(seq, dimensionMonster);
                    dimensionKeyMap.put((Object)dimensionMonster.getTotolDimensionKey(), (Object)seq);
                }
                for (rowIndex = 0; rowIndex < expenseentryentity.size(); ++rowIndex) {
                    int ctlNum;
                    DynamicObject feeStand;
                    String tips;
                    entry = expenseentryentity.get(rowIndex);
                    seq = entry.getInt("seq");
                    if (FeeStandardHelper.overFeeAmount((BigDecimal)entry.getBigDecimal(FeeStandardHelper.getReimburseAmtKey()), (BigDecimal)entry.getBigDecimal(FeeStandardHelper.getControlAmtKey())) && (entry.getDynamicObject("feestandid") == null || !entry.getDynamicObject("feestandid").getBoolean("summarycontrol") && !entry.getDynamicObject("feestandid").getBoolean("actualreimexpense"))) {
                        entry.set("isover", (Object)true);
                        tips = String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u201c%2s\u201d\u8d85\u51fa\u201c%3s\u201d\u3002", (String)"FeeStandardControlOp_overstdtip", (String)"fi-er-opplugin", (Object[])new Object[0]), seq, FeeStandControlOp.this.getDisplayName(entry, this.getTipAmtKey()), FeeStandControlOp.this.getDisplayName(entry, "controlamt"));
                        this.addOverStdTips(extendedDataEntity, tips);
                        continue;
                    }
                    if (entry.getDynamicObject("feestandid") != null && entry.getDynamicObject("feestandid").getBoolean("otherstand") && !entry.getDynamicObject("feestandid").getBoolean("actualreimexpense")) {
                        BigDecimal totalAmt;
                        if (entry.getBigDecimal(FeeStandardHelper.getOtherFeeAmtKey()).compareTo(entry.getBigDecimal(FeeStandardHelper.getOtherControlAmtKey())) > 0) {
                            entry.set("isover", (Object)true);
                            tips = String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u201c%2s\u201d\u8d85\u51fa\u201c%3s\u201d\u3002", (String)"FeeStandardControlOp_overstdtip", (String)"fi-er-opplugin", (Object[])new Object[0]), seq, FeeStandControlOp.this.getDisplayName(entry, "otherfeeamount"), FeeStandControlOp.this.getDisplayName(entry, "othercontrolamt"));
                            this.addOverStdTips(extendedDataEntity, tips);
                        }
                        if ("1".equals(entry.get("wineway")) && !entry.getDynamicObject("feestandid").getBoolean("summarycontrol") && (totalAmt = entry.getBigDecimal(FeeStandardHelper.getOtherFeeAmtKey()).add(entry.getBigDecimal(FeeStandardHelper.getReimburseAmtKey()))).compareTo(entry.getBigDecimal(FeeStandardHelper.getControlAmtKey())) > 0) {
                            entry.set("isover", (Object)true);
                            String tips2 = String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u201c%2s\u201d\u8d85\u51fa\u201c%3s\u201d\u3002", (String)"FeeStandardControlOp_overstdtip", (String)"fi-er-opplugin", (Object[])new Object[0]), seq, FeeStandControlOp.this.getDisplayName(entry, "otherfeeamount").concat("+").concat(FeeStandControlOp.this.getDisplayName(entry, this.getTipAmtKey())), FeeStandControlOp.this.getDisplayName(entry, "controlamt"));
                            this.addOverStdTips(extendedDataEntity, tips2);
                        }
                    }
                    if ((feeStand = (dimensionMonster = (DimensionMonster)dimensionMonsterMap.get(seq)).getFeeStand()) == null || feeStand.getBoolean("actualreimexpense") || (ctlNum = feeStand.getInt("ctlnumber")) <= 0) continue;
                    DynamicObjectCollection query = QueryServiceHelper.query((String)this.getEntityKey(), (String)"id", (QFilter[])dimensionMonster.getBillFilter());
                    Object[] pkArr = query.stream().filter(v -> !pks.contains(v.get("id"))).map(v -> v.get("id")).collect(Collectors.toList()).toArray();
                    List<DynamicObject> sameDeminsionBillsFromDB = this.matchSameDeminsionBill(entry, bill, dimensions, BusinessDataServiceHelper.load((Object[])pkArr, (DynamicObjectType)bill.getDynamicObjectType()));
                    List<DynamicObject> sameDeminsionBillsFromCurSubmit = this.matchSameDeminsionBill(entry, bill, dimensions, this.getDataEntities());
                    if (sameDeminsionBillsFromDB.size() + sameDeminsionBillsFromCurSubmit.size() < ctlNum) continue;
                    String tips3 = String.format(ResManager.loadKDString((String)"\u7b2c[%1s]\u884c\u5df2\u8d85\u8d39\u7528\u63a7\u5236\u6b21\u6570\uff0c\u5df2\u4f7f\u7528\u5355\u636e\uff1a[%2s]", (String)"FeeStandardControlOp_overstdtip_1", (String)"fi-er-opplugin", (Object[])new Object[0]), seq, this.getBillNos(sameDeminsionBillsFromDB, sameDeminsionBillsFromCurSubmit));
                    this.addOverStdTips(extendedDataEntity, tips3);
                }
                this.checkSummaryControl(extendedDataEntity, expenseentryentity);
                if (!this.checkDup()) continue;
                this.checkDupEntryByNotSumControl(extendedDataEntity, (ArrayListMultimap<String, Integer>)dimensionKeyMap);
            }
        }

        private boolean checkMustInput(ExtendedDataEntity extendedDataEntity, List<String> dimensions, List<DynamicObject> expenseentryentity) {
            boolean mustInput = false;
            for (int rowIndex = 0; rowIndex < expenseentryentity.size(); ++rowIndex) {
                DynamicObject entry = expenseentryentity.get(rowIndex);
                for (String field : dimensions) {
                    Object value = FeeStandControlOp.this.getValueSafe(entry, field);
                    if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) continue;
                    mustInput = true;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u8bf7\u586b\u5199\u201c%2s\u201d\u3002", (String)"FeeStandardControlOp_mustinputtips", (String)"fi-er-opplugin", (Object[])new Object[0]), entry.get("seq"), FeeStandControlOp.this.getDisplayName(entry, field)));
                }
            }
            return mustInput;
        }

        private String getBillNos(List<DynamicObject> sameDeminsionBillsFromDB, List<DynamicObject> sameDeminsionBillsFromCurSubmit) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)(sameDeminsionBillsFromDB.size() + sameDeminsionBillsFromCurSubmit.size()));
            sameDeminsionBillsFromDB.stream().forEach(v -> list.add(v.getString("billno")));
            sameDeminsionBillsFromCurSubmit.stream().forEach(v -> list.add(v.getString("billno")));
            return StringUtils.join((Iterable)list, (String)",");
        }

        private List<DynamicObject> matchSameDeminsionBill(DynamicObject entry, DynamicObject curBill, List<String> dimensions, Object[] bills) {
            ArrayList sameDeminsionBills = Lists.newArrayListWithExpectedSize((int)4);
            for (Object obj : bills) {
                DynamicObject bill = null;
                bill = obj instanceof ExtendedDataEntity ? ((ExtendedDataEntity)obj).getDataEntity() : (DynamicObject)obj;
                if (bill.getPkValue().equals(curBill.getPkValue()) || !this.matchDeminsion(entry, curBill, bill, dimensions)) continue;
                sameDeminsionBills.add(bill);
            }
            return sameDeminsionBills;
        }

        private boolean matchDeminsion(DynamicObject entry, DynamicObject curBill, DynamicObject bill, List<String> dimensions) {
            return FeeStandardHelper.equals((Object)curBill.get("company"), (Object)bill.get("company")) && FeeStandardHelper.equals((Object)curBill.get("bizitem"), (Object)bill.get("bizitem")) && this.existSameEntry(entry, bill.getDynamicObjectCollection("expenseentryentity"), dimensions);
        }

        private boolean existSameEntry(DynamicObject curEntry, DynamicObjectCollection entrys, List<String> dimensions) {
            for (int i = 0; i < entrys.size(); ++i) {
                boolean dimensionEq;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                boolean bl = FeeStandardHelper.equals((Object)entry.get("expenseitem"), (Object)curEntry.get("expenseitem")) && FeeStandardHelper.equals((Object)entry.get(FeeStandardHelper.headCurrencyControl() ? "feestandcurrency" : "entrycurrency"), (Object)curEntry.get(FeeStandardHelper.headCurrencyControl() ? "feestandcurrency" : "entrycurrency")) && this.dimensionEq(curEntry, entry, dimensions) ? true : (dimensionEq = false);
                if (!dimensionEq) continue;
                return true;
            }
            return false;
        }

        private boolean dimensionEq(DynamicObject curEntry, DynamicObject entry, List<String> dimensions) {
            boolean dimensionEq = true;
            for (String field : dimensions) {
                if (FeeStandardHelper.equals((Object)FeeStandControlOp.this.getValueSafe(entry, field), (Object)FeeStandControlOp.this.getValueSafe(curEntry, field))) continue;
                dimensionEq = false;
                break;
            }
            return dimensionEq;
        }

        private void addOverStdTips(ExtendedDataEntity extendedDataEntity, String tips) {
            if (this.justWarning((Long)extendedDataEntity.getDataEntity().getDynamicObject("company").getPkValue())) {
                this.addWarningMessage(extendedDataEntity, tips.replace("\u3002", ""));
            } else {
                this.addErrorMessage(extendedDataEntity, tips);
            }
        }

        private boolean justWarning(Long companyId) {
            return "3".equals(ErCommonUtils.getEMParameter((long)companyId, (String)"feestandardcontroltype"));
        }

        private void checkSummaryControl(ExtendedDataEntity extendedDataEntity, List<DynamicObject> expenseentryList) {
            List expenseentrys;
            if (expenseentryList != null && !expenseentryList.isEmpty() && (expenseentrys = expenseentryList.stream().filter(v -> v.getDynamicObject("feestandid") != null && v.getDynamicObject("feestandid").getBoolean("summarycontrol") && !v.getDynamicObject("feestandid").getBoolean("actualreimexpense")).collect(Collectors.toList())) != null && !expenseentrys.isEmpty()) {
                HashMap<String, List> summaryControlMap = new HashMap<String, List>();
                for (DynamicObject expense : expenseentrys) {
                    DynamicObjectCollection relatedstandards = expense.getDynamicObject("feestandid").getDynamicObjectCollection("relatedstandard");
                    if (relatedstandards != null && !relatedstandards.isEmpty()) {
                        ArrayList ids = Lists.newArrayListWithExpectedSize((int)relatedstandards.size());
                        for (DynamicObject relatedstandard : relatedstandards) {
                            ids.add(relatedstandard.getLong("FBASEDATAID_id"));
                        }
                        Collections.sort(ids);
                        String key = StringUtils.join((Iterable)ids, (String)",");
                        List value = (List)summaryControlMap.get(key);
                        if (value == null) {
                            value = Lists.newArrayListWithExpectedSize((int)2);
                        }
                        value.add(expense);
                        summaryControlMap.put(key, value);
                        continue;
                    }
                    List value = (List)summaryControlMap.get(expense.getPkValue().toString());
                    if (value == null) {
                        value = Lists.newArrayListWithExpectedSize((int)2);
                    }
                    value.add(expense);
                    summaryControlMap.put(expense.getPkValue().toString(), value);
                }
                for (Map.Entry entry : summaryControlMap.entrySet()) {
                    List summaryExpenseEntryList = (List)entry.getValue();
                    BigDecimal expeapproveamount = summaryExpenseEntryList.stream().map(e -> (BigDecimal)e.get(FeeStandardHelper.getReimburseAmtKey())).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                    BigDecimal otheramount = summaryExpenseEntryList.stream().filter(l -> "1".equals(l.get("wineway"))).map(e -> (BigDecimal)e.get(FeeStandardHelper.getOtherFeeAmtKey())).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                    BigDecimal controlamt = this.sumControlamt(summaryExpenseEntryList);
                    if (!FeeStandardHelper.overFeeAmount((BigDecimal)expeapproveamount.add(otheramount), (BigDecimal)controlamt)) continue;
                    FeeStandControlOp.this.summaryOver = Boolean.TRUE;
                    List seqList = summaryExpenseEntryList.stream().map(v -> v.getInt("seq")).collect(Collectors.toList());
                    if (seqList.size() == 1) {
                        this.addOverStdTips(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u201c%2s\u201d\u8d85\u51fa\u201c%3s\u201d\u3002", (String)"FeeStandardControlOp_overstdtip", (String)"fi-er-opplugin", (Object[])new Object[0]), ((DynamicObject)summaryExpenseEntryList.get(0)).getInt("seq"), BigDecimal.ZERO.compareTo(otheramount) < 0 ? FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), FeeStandardHelper.getOtherFeeAmtKey()).concat("+").concat(FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), this.getTipAmtKey())) : FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), this.getTipAmtKey()), FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), "controlamt")));
                        continue;
                    }
                    this.addOverStdTips(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c[%1s]\u884c,\u201c%2s\u201d\u5408\u8ba1[%3s]\u8d85\u51fa\u201c%4s\u201d\u5408\u8ba1[%s]", (String)"FeeStandardControlOp_overstdtip1", (String)"fi-er-opplugin", (Object[])new Object[0]), StringUtils.join(seqList, (String)","), BigDecimal.ZERO.compareTo(otheramount) < 0 ? FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), FeeStandardHelper.getOtherFeeAmtKey()).concat("+").concat(FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), this.getTipAmtKey())) : FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), this.getTipAmtKey()), expeapproveamount.add(otheramount).stripTrailingZeros().toPlainString(), FeeStandControlOp.this.getDisplayName((DynamicObject)summaryExpenseEntryList.get(0), "controlamt"), controlamt.stripTrailingZeros().toPlainString()));
                }
            }
        }

        private BigDecimal sumControlamt(List<DynamicObject> summaryExpenseEntryList) {
            if (this.checkDup()) {
                HashSet dupSet = Sets.newHashSetWithExpectedSize((int)summaryExpenseEntryList.size());
                BigDecimal controlamt = BigDecimal.ZERO;
                for (int i = 0; i < summaryExpenseEntryList.size(); ++i) {
                    DynamicObject feeStand = summaryExpenseEntryList.get(i).getDynamicObject("feestandid");
                    if (feeStand == null || !dupSet.add(feeStand.getPkValue())) continue;
                    controlamt = controlamt.add(summaryExpenseEntryList.get(i).getBigDecimal(FeeStandardHelper.getControlAmtKey()));
                }
                return controlamt;
            }
            return summaryExpenseEntryList.stream().map(e -> (BigDecimal)e.get(FeeStandardHelper.getControlAmtKey())).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        }

        private void checkDupEntryByNotSumControl(ExtendedDataEntity extendedDataEntity, ArrayListMultimap<String, Integer> dimensionKeyMap) {
            Set keySet = dimensionKeyMap.keySet();
            for (String totolDimensionKey : keySet) {
                DynamicObjectCollection entrys;
                DynamicObject feestand;
                List seqList = dimensionKeyMap.get((Object)totolDimensionKey);
                if (seqList.size() <= 1 || (feestand = ((DynamicObject)(entrys = extendedDataEntity.getDataEntity().getDynamicObjectCollection("expenseentryentity")).get((Integer)seqList.get(0) - 1)).getDynamicObject("feestandid")) == null || feestand.getBoolean("summarycontrol") || feestand.getBoolean("actualreimexpense")) continue;
                BigDecimal expeapproveamount = BigDecimal.ZERO;
                BigDecimal otheramount = BigDecimal.ZERO;
                for (Integer seq : seqList) {
                    expeapproveamount = expeapproveamount.add(((DynamicObject)entrys.get(seq - 1)).getBigDecimal(FeeStandardHelper.getReimburseAmtKey()));
                    if (!"1".equals(((DynamicObject)entrys.get(seq - 1)).get("wineway"))) continue;
                    otheramount = otheramount.add(((DynamicObject)entrys.get(seq - 1)).getBigDecimal(FeeStandardHelper.getOtherFeeAmtKey()));
                }
                BigDecimal controlamt = ((DynamicObject)entrys.get((Integer)seqList.get(0) - 1)).getBigDecimal(FeeStandardHelper.getControlAmtKey());
                if (!FeeStandardHelper.overFeeAmount((BigDecimal)expeapproveamount.add(otheramount), (BigDecimal)controlamt)) continue;
                FeeStandControlOp.this.summaryOver = Boolean.TRUE;
                this.addOverStdTips(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7ef4\u5ea6\u91cd\u590d\uff0c%2s\u7684\u6c47\u603b\u91d1\u989d\uff08%3s\uff09\u8d85\u8fc7%4s\u7684\u91d1\u989d\uff08%s\uff09\u3002", (String)"FeeStandardControlOp_dupentrytips", (String)"fi-er-opplugin", (Object[])new Object[0]), seqList, FeeStandControlOp.this.getDisplayName((DynamicObject)entrys.get(0), this.getTipAmtKey()), expeapproveamount.add(otheramount).stripTrailingZeros().toPlainString(), FeeStandControlOp.this.getDisplayName((DynamicObject)entrys.get(0), "controlamt"), controlamt.stripTrailingZeros().toPlainString()));
            }
        }

        private String getTipAmtKey() {
            if (FeeStandardHelper.headCurrencyControl()) {
                return "currexpenseamount";
            }
            return "expenseamount";
        }

        private boolean checkDup() {
            return ErStdConfig.getBoolean((String)"feestand.checkDup");
        }
    }
}

