/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.amount.control;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ComboPropShowStyle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class StandardSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("stardardtype");
        e.getFieldKeys().add("stardardtype.dimension");
        e.getFieldKeys().add("stardardtype.dimension.fbasedataid");
        e.getFieldKeys().add("stardardtype.dimension.fbasedataid.number");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new StandardSaveValidate());
    }

    static class StandardSaveValidate
    extends AbstractValidator {
        StandardSaveValidate() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject feeStandSetting = dataEntity.getDataEntity();
                DynamicObject stardardtype = feeStandSetting.getDynamicObject("stardardtype");
                if (stardardtype == null) continue;
                DynamicObjectCollection objectCollection = stardardtype.getDynamicObjectCollection("dimension");
                StringBuilder selfDimension = new StringBuilder();
                if (!objectCollection.isEmpty()) {
                    List dimensionNumber = objectCollection.stream().map(it -> it.getDynamicObject("fbasedataid")).map(it -> it.getString("number")).collect(Collectors.toList());
                    DataEntityPropertyCollection properties = feeStandSetting.getDynamicObjectType().getProperties();
                    for (String it2 : dimensionNumber) {
                        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)it2);
                        if (iDataEntityProperty == null) {
                            String errorMessage = ResManager.loadKDString((String)"\u6807\u51c6\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6ca1\u6709\u5728\u5143\u6570\u636e\u4e2d\u8bbe\u7f6e\u3002", (String)"StandardSaveOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(dataEntity, errorMessage);
                            continue;
                        }
                        Object o = feeStandSetting.get(it2);
                        String zh_cn = (String)iDataEntityProperty.getDisplayName().get((Object)"zh_CN");
                        if (o == null) {
                            String errorMessage = String.format(ResManager.loadKDString((String)"%1$s\u6ca1\u6709\u586b\u5199\u3002", (String)"StandardSaveOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), zh_cn);
                            this.addErrorMessage(dataEntity, errorMessage);
                            continue;
                        }
                        if (iDataEntityProperty instanceof ComboProp) {
                            Object showStyle = ((ComboProp)iDataEntityProperty).getItemByNameAndShowStyle(String.valueOf(o), ComboPropShowStyle.Title.getValue());
                            selfDimension.append(String.valueOf(showStyle));
                            selfDimension.append(";");
                        }
                        if (!(iDataEntityProperty instanceof BasedataProp)) continue;
                        DynamicObject obj = (DynamicObject)o;
                        OrmLocaleValue name = (OrmLocaleValue)obj.get("name");
                        selfDimension.append(name.get((Object)"zh_CN"));
                        selfDimension.append(";");
                    }
                }
                if (selfDimension.length() > 1) {
                    feeStandSetting.set("dimension", (Object)selfDimension.substring(0, selfDimension.length() - 1));
                }
                if (!this.getValidateResult().isSuccess()) continue;
                List<String> matchDimensions = objectCollection.stream().map(it -> it.getDynamicObject("fbasedataid")).map(it -> it.getString("number")).collect(Collectors.toList());
                matchDimensions.add("createorg");
                QFilter[] qfilters = new QFilter[]{new QFilter("currency", "=", feeStandSetting.getDynamicObject("currency").getPkValue()), new QFilter("expenseitem", "=", feeStandSetting.getDynamicObject("expenseitem").getPkValue()), new QFilter("stardardtype", "=", stardardtype.getPkValue())};
                DynamicObjectCollection existFeeStandSettings = QueryServiceHelper.query((String)"er_standard", (String)("id," + StringUtils.join(matchDimensions, (String)",")), (QFilter[])qfilters);
                if (existFeeStandSettings.isEmpty()) continue;
                this.matchDimension(dataEntity, matchDimensions, existFeeStandSettings);
            }
        }

        private void matchDimension(ExtendedDataEntity dataEntity, List<String> matchDimensions, DynamicObjectCollection existFeeStandSettings) {
            for (DynamicObject existFeeStand : existFeeStandSettings) {
                if (!this.allSame(matchDimensions, existFeeStand, dataEntity.getDataEntity())) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u8bb0\u5f55\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"StandardSaveOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
        }

        private boolean allSame(List<String> matchDimensions, DynamicObject existFeeStand, DynamicObject feeStandSetting) {
            if (existFeeStand.get("id").equals(feeStandSetting.getPkValue())) {
                return false;
            }
            for (String dimension : matchDimensions) {
                Object o2;
                Object o1 = feeStandSetting.get(dimension);
                if (this.equals(o1, o2 = existFeeStand.get(dimension))) continue;
                return false;
            }
            return true;
        }

        private boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (o1 instanceof DynamicObject) {
                o1 = ((DynamicObject)o1).getPkValue();
            }
            if (o2 instanceof DynamicObject) {
                o2 = ((DynamicObject)o2).getPkValue();
            }
            return o1.equals(o2);
        }
    }
}

