/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.billingpool;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.opplugin.billingpool.validator.BillingPoolDeleteStatusValidator;

public class BillingPoolDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BillingPoolDeleteStatusValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            try {
                this.updateInvoiceStatus(dataEntity);
            }
            catch (Exception exception) {
                throw new KDBizException("update status fail:" + ThrowableHelper.toString((Exception)exception));
            }
        }
    }

    public void updateInvoiceStatus(DynamicObject dataEntity) throws Exception {
        DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
        DeleteInvoiceRespParam response = InvoiceService.getInstanceService().deleteRelationBetweenInvoiceAndBill(dataEntity, ErCommonUtils.getPk((Object)costCompany), null);
        if (!response.isSuccess()) {
            throw new KDBizException("update status fail:" + response.getDescription());
        }
    }
}

