/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.billingpool;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.model.InvoiceData;
import kd.fi.er.business.invoicecloud.model.UpdateInvoiceStatusParam;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.common.model.invoice.bo.ReasonForTransferOut;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.opplugin.billingpool.BillingPoolOp;
import kd.fi.er.validator.invoicecloud.billingpool.BillingPoolBaseValidator;

public class BillingPoolSaveOp
extends AbstractOperationServicePlugIn
implements BillingPoolOp {
    private static final Log logger = LogFactory.getLog(BillingPoolSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("invoicetype.uniquecondition");
        fieldKeys.add("invoicetype.js");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillingPoolBaseValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            this.genName(bill);
            this.genSerialNo(bill);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            try {
                this.updateInvoiceStatus(dataEntity);
            }
            catch (Exception exception) {
                throw new KDBizException("update status fail:" + ThrowableHelper.toString((Exception)exception));
            }
        }
        this.editInvoices(dataEntities);
    }

    private void updateInvoiceStatus(DynamicObject dataEntity) throws Exception {
        UpdateInvoiceStatusRespParam response;
        DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
        UpdateInvoiceStatusParam updateInvoiceStatusParam = this.buildUpdateInvoiceStatusParam(dataEntity, ErCommonUtils.getPk((Object)costCompany), InvoiceStatusEnum.submitted);
        if (updateInvoiceStatusParam != null && !(response = InvoiceService.getInstanceService().updateInvoiceStatus(dataEntity, updateInvoiceStatusParam)).isSuccess()) {
            throw new KDBizException("update status fail:" + response.getDescription());
        }
    }

    private void editInvoices(DynamicObject[] dataEntities) {
        List<EditInvoiceReqParam> editInvoiceReqParams = this.buildEditInvoiceParams(dataEntities);
        InvoiceService.getInstanceService().editInvoice(editInvoiceReqParams);
    }

    private UpdateInvoiceStatusParam buildUpdateInvoiceStatusParam(DynamicObject dataEntity, Long invoiceOrgId, InvoiceStatusEnum status) {
        UpdateInvoiceStatusParam param = new UpdateInvoiceStatusParam();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)invoiceOrgId);
        if (config == null) {
            return null;
        }
        String taxRegnum = config.getTaxRegnum();
        String companyName = config.getFirmname();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = taxNoList.size() < companyNameList.size() ? taxNoList.size() : companyNameList.size();
        ArrayList companyInfos = Lists.newArrayListWithExpectedSize((int)companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            companyInfos.add(new UpdateInvoiceStatusParam.CompanyInfo((String)taxNoList.get(i), (String)companyNameList.get(i)));
        }
        param.setCompanyInfo((List)companyInfos);
        String entityId = dataEntity.getDataEntityType().getName();
        param.setBillType(entityId);
        param.setBillNo(dataEntity.getString("billno"));
        param.setBillId(dataEntity.getPkValue().toString());
        param.setEntityId(entityId);
        param.setViewPage(entityId);
        param.setOrgId(invoiceOrgId.toString());
        param.setStatus(String.valueOf(status.getValue()));
        Long applierId = null;
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"applier")) {
            applierId = ErCommonUtils.getPk((Object)dataEntity.get("applier"));
        }
        logger.info("applierId: {}", applierId);
        if (applierId != null && applierId.compareTo(0L) > 0) {
            param.setBillUser(String.valueOf(applierId));
        } else {
            param.setBillUser(String.valueOf(RequestContext.get().getCurrUserId()));
        }
        param.setVerifyFlag("1");
        ArrayList<InvoiceData> invoiceDataList = new ArrayList<InvoiceData>(1);
        InvoiceData invoiceData = new InvoiceData();
        String serialNo = dataEntity.getString("serialno");
        invoiceData.setSerialNo(serialNo);
        invoiceData.setIsOffset(Boolean.valueOf(dataEntity.getBoolean("offsetexpense")));
        if (ErStdConfig.getPostBackTeype() == 2) {
            invoiceData.setOffsetAmount(dataEntity.getBigDecimal("offsetamount").add(dataEntity.getBigDecimal("inoutamount")));
        } else if (ErStdConfig.getPostBackTeype() == 3) {
            invoiceData.setOffsetAmount(dataEntity.getBigDecimal("taxamount_invoice"));
        } else {
            invoiceData.setOffsetAmount(dataEntity.getBigDecimal("offsetamount"));
        }
        invoiceData.setInOutReson(ReasonForTransferOut.getReason((String)dataEntity.getString("reasonfortransferout")));
        invoiceData.setNoDeductionReason(dataEntity.getString("nodeductionreason"));
        invoiceData.setOutAount(dataEntity.getBigDecimal("inoutamount"));
        invoiceData.setInvoiceFrom(dataEntity.getString("invoicefrom"));
        invoiceData.setInvoiceType(dataEntity.getString("invoicetype"));
        invoiceData.setInvoiceOrgId(ErCommonUtils.getPk((Object)dataEntity.get("costcompany")));
        invoiceDataList.add(invoiceData);
        param.setInvoiceData(invoiceDataList);
        return param;
    }

    private List<EditInvoiceReqParam> buildEditInvoiceParams(DynamicObject[] dataEntities) {
        ArrayList<EditInvoiceReqParam> reqParams = new ArrayList<EditInvoiceReqParam>();
        for (DynamicObject dataEntity : dataEntities) {
            String invoicetypeNum;
            DynamicObject invoiceTypeBd;
            DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
            if (KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)costCompany)) == null || (invoiceTypeBd = dataEntity.getDynamicObject("invoicetype")) == null || InvoiceTypeEnum.key_30 != InvoiceTypeEnum.getByValue((String)(invoicetypeNum = invoiceTypeBd.getString("number")))) continue;
            EditInvoiceReqParam param = new EditInvoiceReqParam();
            String serialNo = dataEntity.getString("serialno");
            DynamicObject currency = dataEntity.getDynamicObject("invoicecurrency");
            Long currencyId = (Long)currency.getPkValue();
            String currencyNumber = currency.getString("number");
            BigDecimal totalAmount = dataEntity.getBigDecimal("totalamount");
            BigDecimal invoiceAmount = dataEntity.getBigDecimal("invoicenotaxamount");
            BigDecimal taxAmount = dataEntity.getBigDecimal("taxamount_invoice");
            String buyerName = dataEntity.getString("buyerorgname");
            String makeoutCompName = dataEntity.getString("makeoutcompname");
            String countryStr = dataEntity.getString("countrystr");
            Date dueDate = dataEntity.getDate("expirypaydate");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dueDateStr = dueDate == null ? "" : sdf.format(dueDate);
            param.setSerialNo(serialNo);
            param.setInvoiceType(invoicetypeNum);
            param.setCurrencyId(currencyId);
            param.setCurrencyName(currencyNumber);
            param.setTotalAmount(totalAmount);
            param.setInvoiceAmount(invoiceAmount);
            param.setTotalTaxAmount(taxAmount);
            param.setBuyerName(buyerName);
            param.setSalerName(makeoutCompName);
            param.setCountry(countryStr);
            param.setDueDate(dueDateStr);
            reqParams.add(param);
        }
        return reqParams;
    }
}

