/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.billingpool.importhandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.opplugin.billingpool.importhandle.BillingPoolDataHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolDataHandleImpl
implements BillingPoolDataHandle {
    private static Log logger = LogFactory.getLog(BillingPoolDataHandleImpl.class);
    private static final String DEFAULT_BILLPOOL_TYPE = "01";
    private static final String NUMBER = "number";
    private static final String selectFields = "id,number,name";
    private static final String noInvoiceNo = ",24,11,";
    private static final String noInvoiceDate = ",24,11,14,";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String BD_UNIT = "bd_measureunits";
    private static final String ER_INVOICE_TYPE = "er_invoicetype";
    private static final String[] DEFAULT_CON = new String[]{"billpooltype", "costcompany", "sellerorg", "invoiceno"};
    private Collection<DynamicObject> billingPoolTypes = new ArrayList<DynamicObject>();
    private Collection<DynamicObject> invoiceTypes = new ArrayList<DynamicObject>();
    private Collection<DynamicObject> countries = new ArrayList<DynamicObject>();
    private Collection<DynamicObject> currencyList = new ArrayList<DynamicObject>();
    private Set<String> buyerList = new HashSet<String>();
    private Set<String> sellerList = new HashSet<String>();
    private Map<String, DynamicObject> ownerMap = new HashMap<String, DynamicObject>();
    private Collection<DynamicObject> taxRateList = new HashSet<DynamicObject>();
    private Set<String> unitList = new HashSet<String>();
    private DynamicObject formObj = null;
    private JSONObject currentUser = new JSONObject();
    Map<String, Integer> uniqueKeys = new HashMap<String, Integer>();

    public BillingPoolDataHandleImpl(List<ImportBillData> rowDataList) {
        QFilter filter;
        QFilter qFilter = new QFilter("enable", "=", (Object)true);
        Map billPoolTypes = BusinessDataServiceHelper.loadFromCache((String)"er_bd_billingpool_type", (String)"id,number,name,isinvoice", (QFilter[])new QFilter[]{qFilter});
        if (null != billPoolTypes && !billPoolTypes.isEmpty()) {
            this.billingPoolTypes = billPoolTypes.values();
        }
        Map types = BusinessDataServiceHelper.loadFromCache((String)ER_INVOICE_TYPE, (String)"id,number,name,isoffset,uniquecondition", (QFilter[])qFilter.toArray());
        this.invoiceTypes = types.values();
        QFilter tFilter = QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"});
        Map taxRates = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number,name,taxrate", (QFilter[])tFilter.toArray());
        if (null != taxRates && !taxRates.isEmpty()) {
            this.taxRateList = taxRates.values();
        }
        HashSet currencyNumList = new HashSet();
        HashSet unitNumList = new HashSet();
        HashSet countryNumList = new HashSet();
        HashSet userNumList = new HashSet();
        HashSet orgNumParams = new HashSet();
        HashSet supplierNumParams = new HashSet();
        rowDataList.forEach(item -> {
            JSONObject dataMap = item.getData();
            JSONObject currency = (JSONObject)dataMap.get((Object)"invoicecurrency");
            this.addNum(currency, currencyNumList);
            JSONArray entries = (JSONArray)dataMap.get((Object)"entryentity");
            Boolean showDetail = dataMap.getBoolean("showdetail");
            if (null != showDetail && showDetail.booleanValue()) {
                entries.stream().forEach(entry -> {
                    JSONObject unitObj = ((JSONObject)entry).getJSONObject("unit");
                    this.addNum(unitObj, unitNumList);
                });
            }
            JSONObject buyerOrg = (JSONObject)dataMap.get((Object)"buyerorg");
            this.addNum(buyerOrg, orgNumParams);
            JSONObject validateorg = (JSONObject)dataMap.get((Object)"validateorg");
            this.addNum(validateorg, orgNumParams);
            JSONObject sellerOrg = (JSONObject)dataMap.get((Object)"sellerorg");
            this.addNum(sellerOrg, supplierNumParams);
            JSONObject country = (JSONObject)dataMap.get((Object)"country");
            this.addNum(country, countryNumList);
            JSONObject projectower = (JSONObject)dataMap.get((Object)"projectower");
            this.addNum(projectower, userNumList);
        });
        if (CollectionUtils.isNotEmpty(userNumList)) {
            Set userNumSet = userNumList.stream().map(item -> item.split(",")).flatMap(Arrays::stream).collect(Collectors.toSet());
            QFilter filter2 = new QFilter(NUMBER, "in", userNumSet);
            filter2.and(qFilter);
            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filter2.toArray());
            if (null != users && !users.isEmpty()) {
                this.ownerMap = users.values().stream().collect(Collectors.toMap(item -> item.getString(NUMBER), item -> item, (k1, k2) -> k1));
            }
        }
        if (CollectionUtils.isNotEmpty(countryNumList)) {
            filter = new QFilter(NUMBER, "in", countryNumList);
            filter.and(qFilter);
            Map countries = BusinessDataServiceHelper.loadFromCache((String)"bd_country", (String)selectFields, (QFilter[])filter.toArray());
            if (null != countries && !countries.isEmpty()) {
                this.countries = countries.values();
            }
        }
        if (CollectionUtils.isNotEmpty(currencyNumList)) {
            filter = new QFilter(NUMBER, "in", currencyNumList);
            filter.and(qFilter);
            Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)selectFields, (QFilter[])filter.toArray());
            if (null != currencyMap && !currencyMap.isEmpty()) {
                this.currencyList = currencyMap.values();
            }
        }
        if (CollectionUtils.isNotEmpty(unitNumList)) {
            filter = new QFilter(NUMBER, "in", unitNumList);
            filter.and(qFilter);
            Map units = BusinessDataServiceHelper.loadFromCache((String)BD_UNIT, (String)selectFields, (QFilter[])filter.toArray());
            if (null != units && !units.isEmpty()) {
                this.unitList = units.values().stream().map(item -> item.getString(NUMBER)).collect(Collectors.toSet());
            }
        }
        if (CollectionUtils.isNotEmpty(orgNumParams)) {
            filter = new QFilter(NUMBER, "in", orgNumParams);
            filter.and(QFilter.of((String)"enable=? and status=?", (Object[])new Object[]{"1", "C"}));
            filter.and(new QFilter("structure.view.number", "=", (Object)"15"));
            Map orgList = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)selectFields, (QFilter[])filter.toArray());
            if (null != orgList && !orgList.isEmpty()) {
                this.buyerList = orgList.values().stream().map(item -> item.getString(NUMBER)).collect(Collectors.toSet());
            }
        }
        if (CollectionUtils.isNotEmpty(supplierNumParams)) {
            filter = new QFilter(NUMBER, "in", supplierNumParams);
            filter.and(qFilter);
            Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)selectFields, (QFilter[])filter.toArray());
            if (null != suppliers && !suppliers.isEmpty()) {
                this.sellerList = suppliers.values().stream().map(item -> item.getString(NUMBER)).collect(Collectors.toSet());
            }
        }
        this.formObj = BusinessDataServiceHelper.loadSingleFromCache((String)"er_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"er_billingpool")});
        this.currentUser = ImportUtils.packageJsonObject((DynamicObject)UserServiceHelper.getCurrentUser((String)NUMBER));
    }

    @Override
    public boolean handleHeadData(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        Boolean ismutilreimburse;
        BigDecimal totalAmount;
        JSONObject expenseitem;
        Object expiryPayDate;
        Object invoiceDate;
        JSONObject country;
        String invoiceTypeNo;
        JSONObject companyJson;
        Map company;
        JSONObject dataMap = data.getData();
        JSONObject applierJson = (JSONObject)dataMap.get((Object)"applier");
        if (applierJson == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u672a\u627e\u5230\u7533\u8bf7\u4eba\u3002", (String)"ErBillBaseImportHandle_26", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        String applierNumber = applierJson.getString(NUMBER);
        DynamicObject user = ImportUtils.getUserByNumber((String)applierNumber);
        if (user == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u672a\u627e\u5230", (String)"ErBillBaseImportHandle_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!user.getBoolean("enable")) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u88ab\u7981\u7528", (String)"ErBillBaseImportHandle_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map userMap = ImportUtils.getUserMap((DynamicObject)user);
        applierJson.put("id", (Object)ErCommonUtils.getPk((Object)user));
        dataMap.put("tel", (Object)(userMap.get("tel") == null || "".equals(userMap.get("tel")) ? "-" : userMap.get("tel")));
        dataMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        JSONObject jsonOrg = (JSONObject)dataMap.get((Object)"org");
        if (jsonOrg != null && jsonOrg.getString(NUMBER) != null) {
            String orgNumber;
            Set orgNumbers = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getDynamicObject("dpt").getString(NUMBER)).collect(Collectors.toSet());
            if (!orgNumbers.contains(orgNumber = jsonOrg.getString(NUMBER))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErBillBaseImportHandle_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)org))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErBillBaseImportHandle_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            company = OrgUnitServiceHelper.getCompanyfromOrg((Object)orgNumber);
            companyJson = ImportUtils.packageJsonObject(company.get(NUMBER), company.get("name"));
            companyJson.put("id", company.get("id"));
            dataMap.put("company", (Object)companyJson);
            dataMap.put("companyid", company.get("id"));
        } else {
            DynamicObject dyOrg = (DynamicObject)userMap.get("org");
            JSONObject orgJson = ImportUtils.packageJsonObject((DynamicObject)dyOrg);
            dataMap.put("org", (Object)orgJson);
            Long companyID = (Long)userMap.get("company");
            if (companyID == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7533\u8bf7\u4eba\u516c\u53f8\u3002", (String)"ErBillBaseImportHandle_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
            companyJson = ImportUtils.packageJsonObject((DynamicObject)company);
            companyJson.put("id", company.getPkValue());
            dataMap.put("company", (Object)companyJson);
            dataMap.put("companyid", (Object)companyID);
        }
        Long companyId = (Long)dataMap.get((Object)"companyid");
        JSONObject costDeptJson = (JSONObject)dataMap.get((Object)"costdept");
        DynamicObject costOrg = null;
        if (null == costDeptJson || StringUtils.isBlank((CharSequence)costDeptJson.getString(NUMBER))) {
            costOrg = (DynamicObject)userMap.get("costdept");
            costDeptJson = ImportUtils.packageJsonObject((DynamicObject)costOrg);
        } else {
            String orgNumber = costDeptJson.getString(NUMBER);
            costOrg = ImportUtils.getOrgByNumber((String)orgNumber);
            if (costOrg == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErBillBaseImportHandle_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costOrg))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErBillBaseImportHandle_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        dataMap.put("costdept", (Object)costDeptJson);
        Long costDeptId = ErCommonUtils.getPk((Object)costOrg);
        ThreadCache.put((Object)"entrycostcompany.number", (Object)companyId);
        String msg = ImportUtils.checkCostDeptSelectInRange((long)ErCommonUtils.getPk((Object)user), (long)companyId, (long)costDeptId);
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.fail(data.getStartIndex(), iterator, logger, msg);
        }
        JSONObject costCompany = (JSONObject)dataMap.get((Object)"costcompany");
        List costcompanyNumbers = new ArrayList();
        Long costCompanyId = 0L;
        if (costCompany == null || StringUtils.isBlank((CharSequence)costCompany.getString(NUMBER))) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u672a\u627e\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"ErBillBaseImportHandle_261", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        String costCompanyNumber = costCompany.getString(NUMBER);
        costcompanyNumbers = ErOrgUtils.getCostCompanySelectable((Long)costDeptId, (Long)companyId);
        Object costCompanyScope = ErCommonUtils.getEMParameter((long)companyId, (String)"enablecostcompanyedit");
        if (!costcompanyNumbers.contains(costCompanyNumber) && null != costCompanyScope && !costCompanyScope.toString().equals("2")) {
            String enablecostcompanyedit = costCompanyScope.toString();
            if ("0".equals(costCompanyScope)) {
                enablecostcompanyedit = ResManager.loadKDString((String)"\u4e0d\u53ef\u4fee\u6539", (String)"ContractBillImportDataOp_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
            } else if ("1".equals(costCompanyScope)) {
                enablecostcompanyedit = ResManager.loadKDString((String)"\u59d4\u6258\u8303\u56f4\u5185\u4fee\u6539", (String)"ContractBillImportDataOp_13", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201c%s\u201d\u4e0d\u5728\u9009\u62e9\u8303\u56f4\u5185\u3002", (String)"ContractBillImportDataOp_11", (String)"fi-er-formplugin", (Object[])new Object[0]), enablecostcompanyedit);
            this.fail(data.getStartIndex(), iterator, logger, msg);
            return false;
        }
        DynamicObject costCompanyObject = ImportUtils.getCompany((String)costCompanyNumber);
        if (costCompanyObject == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u5c01\u5b58\uff0c\u6216\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ErBillBaseImportHandle_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        costCompanyId = ErCommonUtils.getPk((Object)costCompanyObject);
        costCompany.put("id", (Object)costCompanyId);
        JSONObject validateOrg = (JSONObject)dataMap.get((Object)"validateorg");
        if (null != validateOrg && StringUtils.isNotBlank((CharSequence)validateOrg.getString(NUMBER))) {
            String validateOrgNumber = validateOrg.getString(NUMBER);
            if (!costcompanyNumbers.isEmpty() && !costcompanyNumbers.contains(validateOrgNumber)) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u6821\u9a8c\u7ec4\u7ec7\u4e0d\u5728\u9009\u62e9\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillingPoolDataHandleImpl_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            if (costcompanyNumbers.isEmpty() && !this.buyerList.contains(validateOrgNumber)) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u6821\u9a8c\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u4e1a\u52a1\u5355\u5143\u3002", (String)"BillingPoolDataHandleImpl_22", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            costCompanyObject = ImportUtils.getOrgByNumber((String)validateOrgNumber);
            validateOrg.put("id", costCompanyObject.getPkValue());
        } else {
            dataMap.put("validateorg", (Object)costCompany);
        }
        if (CollectionUtils.isEmpty(this.billingPoolTypes)) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u8d26\u5355\u7c7b\u578b\u3002", (String)"BillingPoolDataHandleImpl_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        boolean mustInputInvoiceType = true;
        JSONObject billPoolType = (JSONObject)dataMap.get((Object)"billpooltype");
        if (null == billPoolType) {
            DynamicObject type = this.billingPoolTypes.stream().filter(item -> DEFAULT_BILLPOOL_TYPE.equals(item.getString(NUMBER))).findFirst().orElse(null);
            JSONObject json = ImportUtils.packageJsonObject((DynamicObject)type);
            json.put("id", (Object)ErCommonUtils.getPk((Object)type));
            dataMap.put("billpooltype", (Object)json);
        } else {
            String number2 = billPoolType.getString(NUMBER);
            Optional<DynamicObject> isExists = this.billingPoolTypes.stream().filter(item -> item.getString(NUMBER).equals(number2)).findFirst();
            if (!isExists.isPresent()) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u8d26\u5355\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            billPoolType.put("id", (Object)ErCommonUtils.getPk(isExists.orElse(null)));
            mustInputInvoiceType = isExists.get().getBoolean("isinvoice");
        }
        if (CollectionUtils.isEmpty(this.invoiceTypes)) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u53d1\u7968\u7c7b\u578b\u3002", (String)"BillingPoolDataHandleImpl_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject invoiceTypeObj = null;
        JSONObject invoiceType = (JSONObject)dataMap.get((Object)"invoicetype");
        if (null == invoiceType) {
            invoiceTypeNo = "";
            if (mustInputInvoiceType) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u8d26\u5355\uff0c\u53d1\u7968\u7c7b\u578b\u5fc5\u5f55\u3002", (String)"BillingPoolDataHandleImpl_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            invoiceTypeNo = invoiceType.getString(NUMBER);
            invoiceTypeObj = this.invoiceTypes.stream().filter(item -> item.getString(NUMBER).equals(invoiceTypeNo)).findFirst().orElse(null);
            if (null == invoiceTypeObj) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u53d1\u7968\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            if (!mustInputInvoiceType) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d26\u5355\u7c7b\u578b\u4e3a\u975e\u53d1\u7968\uff0c\u4f46\u662f\u586b\u4e86\u53d1\u7968\u7c7b\u578b\u3002", (String)"BillingPoolDataHandleImpl_23", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (null != (country = (JSONObject)dataMap.get((Object)"country"))) {
            String number3 = country.getString(NUMBER);
            DynamicObject isExists = this.countries.stream().filter(item -> item.getString(NUMBER).equals(number3)).findFirst().orElse(null);
            if (null == isExists) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u56fd\u5bb6\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_61", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            dataMap.put("countrystr", isExists.get("name"));
        }
        if (null == (invoiceDate = dataMap.get((Object)"invoicedate")) || StringUtils.isBlank((CharSequence)invoiceDate.toString())) {
            if (!noInvoiceDate.contains("," + invoiceTypeNo + ",")) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u53d1\u7968/\u8d26\u5355\u65e5\u671f\u5fc5\u987b\u5f55\u5165\u3002", (String)"BillingPoolDataHandleImpl_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (this.isValidDate(invoiceDate.toString())) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u53d1\u7968/\u8d26\u5355\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f\u2018yyyy-MM-dd\u2019\u683c\u5f0f\u3002", (String)"BillingPoolDataHandleImpl_71", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (null != (expiryPayDate = dataMap.get((Object)"expirypaydate")) && StringUtils.isNotBlank((CharSequence)expiryPayDate.toString()) && this.isValidDate(expiryPayDate.toString())) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5230\u671f\u65e5\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5e94\u8be5\u662f\u2018yyyy-MM-dd\u2019\u683c\u5f0f\u3002", (String)"BillingPoolDataHandleImpl_72", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        Object invoiceNo = dataMap.get((Object)"invoiceno");
        if (null == invoiceNo || StringUtils.isBlank((CharSequence)invoiceNo.toString())) {
            if (!noInvoiceNo.contains("," + invoiceTypeNo + ",") && mustInputInvoiceType) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u5fc5\u987b\u5f55\u5165\u3002", (String)"BillingPoolDataHandleImpl_73", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            dataMap.put("invoiceno", (Object)"-");
        }
        PublicBillUtil.checkProjecttype((Map)dataMap);
        JSONObject projectType = (JSONObject)dataMap.get((Object)"projecttype");
        DynamicObject projectTypeDy = null;
        if (projectType != null) {
            String projectTypeNumber = projectType.getString(NUMBER);
            QFilter rangFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_projecttype", (Long)costCompany.getLong("id"));
            rangFilter.and(new QFilter(NUMBER, "=", (Object)projectTypeNumber));
            rangFilter.and(new QFilter("relbill.fbasedataid_id", "=", (Object)ErCommonUtils.getPk((Object)this.formObj)));
            projectTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_projecttype", (String)"id,entryentity.expenseitem,enable", (QFilter[])new QFilter[]{rangFilter});
            if (projectTypeDy == null) {
                String tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u5728\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_8", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, projectTypeNumber);
                this.fail(data.getStartIndex(), iterator, logger, tip);
                return false;
            }
            if ("0".equals(projectTypeDy.get("enable"))) {
                String tip = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u4e0d\u53ef\u7528\u3002", (String)"ErPubBillInitImportBaseHandle_23", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, projectTypeNumber);
                this.fail(data.getStartIndex(), iterator, logger, tip);
                return false;
            }
        }
        if (null != (expenseitem = (JSONObject)dataMap.get((Object)"headexpenseitem"))) {
            DynamicObject basedataDOFromCache;
            List numbers;
            String number4 = expenseitem.getString(NUMBER);
            QFilter qf = QFilter.of((String)"number=?", (Object[])new Object[]{number4}).and(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE})).and("enable", "=", (Object)Boolean.TRUE);
            QFilter relBillFilter = ExpenseItemServiceHelper.getRelBillFilter((String)"er_billingpool");
            qf = qf.and(relBillFilter);
            Long deptID = ErCommonUtils.getPk((Object)costOrg);
            if (null != deptID) {
                QFilter relDeptFilter = ExpenseItemServiceHelper.getRelDeptFilter((Long)deptID);
                qf = qf.and(relDeptFilter);
            }
            if (null != costCompany) {
                qf = qf.and(BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costCompany.getLong("id")));
            }
            if (null != projectTypeDy && !(numbers = projectTypeDy.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", numbers);
                qf = qf.and(qFilter);
            }
            if (null == (basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"id,offset", (QFilter[])new QFilter[]{qf}))) {
                String tip = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u3002", (String)"BillingPoolDataHandleImpl_19", (String)"fi-er-opplugin", (Object[])new Object[0]);
                this.fail(data.getStartIndex(), iterator, logger, tip);
                return false;
            }
        }
        JSONObject invoicecurrency = (JSONObject)dataMap.get((Object)"invoicecurrency");
        DynamicObject objCurrency = null;
        if (null != invoicecurrency) {
            objCurrency = this.currencyList.stream().filter(item -> item.getString(NUMBER).equals(invoicecurrency.getString(NUMBER))).findFirst().orElse(null);
            if (null == objCurrency) {
                String tip = ResManager.loadKDString((String)"\u5e01\u79cd%s\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_11", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoicecurrency.getString(NUMBER));
                this.fail(data.getStartIndex(), iterator, logger, tip);
                return false;
            }
        } else {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5e01\u79cd\u5fc5\u5f55\u3002", (String)"BillingPoolDataHandleImpl_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        JSONObject buyerOrg = (JSONObject)dataMap.get((Object)"buyerorg");
        if (null != buyerOrg && !this.buyerList.contains(buyerOrg.getString(NUMBER))) {
            String tip = ResManager.loadKDString((String)"\u8d2d\u65b9%s\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_17", (String)"fi-er-opplugin", (Object[])new Object[0]);
            tip = String.format(tip, buyerOrg.getString(NUMBER));
            this.fail(data.getStartIndex(), iterator, logger, tip);
            return false;
        }
        JSONObject sellerOrg = (JSONObject)dataMap.get((Object)"sellerorg");
        if (null != sellerOrg && !this.sellerList.contains(sellerOrg.getString(NUMBER))) {
            String tip = ResManager.loadKDString((String)"\u9500\u65b9%s\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_18", (String)"fi-er-opplugin", (Object[])new Object[0]);
            tip = String.format(tip, sellerOrg.getString(NUMBER));
            this.fail(data.getStartIndex(), iterator, logger, tip);
            return false;
        }
        JSONObject projectOwner = (JSONObject)dataMap.get((Object)"projectower");
        if (projectOwner != null && StringUtils.isNotBlank((CharSequence)projectOwner.getString(NUMBER))) {
            String numbers = projectOwner.getString(NUMBER);
            String[] numberArray = numbers.split(",");
            String notExists = Arrays.stream(numberArray).filter(number -> !this.ownerMap.containsKey(number.trim())).collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)notExists)) {
                String tip = ResManager.loadKDString((String)"\u5e72\u7cfb\u4eba%s\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_20", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, notExists);
                this.fail(data.getStartIndex(), iterator, logger, tip);
                return false;
            }
        } else {
            dataMap.put("projectower", (Object)ImportUtils.getProjectower((Long)companyId, (JSONObject)applierJson, (JSONObject)this.currentUser));
        }
        dataMap.put("billstatus", (Object)"J");
        String billstatus = "J";
        if (billstatus.equals("E") || billstatus.equals("J")) {
            BillingPoolConfigModel config = null;
            List configs = BillingPoolConfigUtils.queryPoolConfigs((Long)costCompanyId);
            if (!configs.isEmpty()) {
                config = (BillingPoolConfigModel)configs.get(0);
                String tip = this.checkDup(dataMap, invoiceTypeObj, config, data.getStartIndex());
                if (StringUtils.isNotBlank((CharSequence)tip)) {
                    this.fail(data.getStartIndex(), iterator, logger, tip);
                    return false;
                }
                if (StringUtils.isBlank((CharSequence)tip) && invoiceDate != null) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
                    LocalDate date = LocalDate.parse(invoiceDate.toString(), formatter);
                    tip = this.checkOver(date.atStartOfDay(), config, invoiceNo == null ? "" : invoiceNo.toString());
                    if (StringUtils.isNotBlank((CharSequence)tip)) {
                        this.fail(data.getStartIndex(), iterator, logger, tip);
                        return false;
                    }
                }
            }
        }
        HashMap<String, Object> totalHolder = new HashMap<String, Object>(2);
        Boolean showdetail = dataMap.getBoolean("showdetail");
        if (null != showdetail && showdetail.booleanValue()) {
            if (!this.handleEntry(data, iterator, dataMap, logger, objCurrency, totalHolder)) {
                return false;
            }
            totalAmount = (BigDecimal)totalHolder.get("total");
            BigDecimal noTax = (BigDecimal)totalHolder.get("noTax");
            BigDecimal tax = (BigDecimal)totalHolder.get("tax");
            DynamicObject rate = (DynamicObject)totalHolder.get("rate");
            dataMap.put("totalamount", (Object)totalAmount);
            dataMap.put("invoicenotaxamount", (Object)noTax);
            dataMap.put("taxamount_invoice", (Object)tax);
            dataMap.put("basealltaxrate", (Object)ImportUtils.packageJsonObject((DynamicObject)rate));
        } else {
            dataMap.remove((Object)"entryentity");
            totalAmount = dataMap.getBigDecimal("totalamount");
            if (null == totalAmount || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u5f55\u3002", (String)"BillingPoolDataHandleImpl_29", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal taxAmount = dataMap.getBigDecimal("taxamount_invoice");
            JSONObject taxRate = dataMap.getJSONObject("basealltaxrate");
            DynamicObject baseTaxRate = null;
            if (null != taxRate && null == (baseTaxRate = (DynamicObject)this.taxRateList.stream().filter(item -> item.getString(NUMBER).equals(taxRate.getString(NUMBER))).findFirst().orElse(null))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7a0e\u7387\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_28", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            if (null == taxAmount && null != baseTaxRate) {
                int precision = objCurrency.getInt("amtprecision");
                BigDecimal rateVal = baseTaxRate.getBigDecimal("taxrate").divide(new BigDecimal("100"));
                taxAmount = totalAmount.multiply(rateVal).divide(BigDecimal.ONE.add(rateVal), precision, RoundingMode.HALF_EVEN);
                dataMap.put("taxamount_invoice", (Object)taxAmount);
            }
            if (null == taxAmount) {
                taxAmount = BigDecimal.ZERO;
            }
            if (taxAmount.abs().compareTo(totalAmount) > 0) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7a0e\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u8d85\u51fa\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"BillingPoolDataHandleImpl_30", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal offsetamount = dataMap.getBigDecimal("offsetamount");
            if (null != offsetamount && offsetamount.abs().compareTo(totalAmount) > 0) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u8d85\u51fa\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"BillingPoolDataHandleImpl_31", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal inoutamount = dataMap.getBigDecimal("inoutamount");
            if (null != inoutamount && inoutamount.abs().compareTo(totalAmount) > 0) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8f6c\u51fa\u91d1\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u8d85\u51fa\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"BillingPoolDataHandleImpl_32", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal expTaxAmount = totalAmount.subtract(taxAmount);
            dataMap.put("invoicenotaxamount", (Object)expTaxAmount);
        }
        BigDecimal oriusedamount = dataMap.getBigDecimal("oriusedamount");
        if (null == oriusedamount) {
            oriusedamount = BigDecimal.ZERO;
            dataMap.put("oribalanceamount", (Object)oriusedamount);
        } else if (oriusedamount.compareTo(totalAmount) > 0) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5df2\u7528\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"BillingPoolDataHandleImpl_25", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyId, (Object)costCompanyId);
        if (currency == null) {
            String tip = ResManager.loadKDString((String)"\u7ec4\u7ec7\u672c\u4f4d\u5e01\u672a\u914d\u7f6e\u3002", (String)"BillingPoolDataHandleImpl_12", (String)"fi-er-opplugin", (Object[])new Object[0]);
            this.fail(data.getStartIndex(), iterator, logger, tip);
            return false;
        }
        JSONObject jsonCurr = ImportUtils.packageJsonObject((DynamicObject)currency);
        jsonCurr.put("id", currency.get("id"));
        jsonCurr.put("amtprecision", (Object)currency.getInt("amtprecision"));
        dataMap.put("currency", (Object)jsonCurr);
        dataMap.put("oribalanceamount", (Object)totalAmount.subtract(oriusedamount));
        dataMap.put("invoicestatus", (Object)"normal");
        UUID uuid = UUID.randomUUID();
        String uuidWithoutDashes = uuid.toString().replace("-", "");
        dataMap.put("serialno", (Object)uuidWithoutDashes);
        dataMap.put("invoicestatus", (Object)"normal");
        dataMap.put("isred", (Object)"0");
        dataMap.put("ie_validatest", (Object)"1");
        dataMap.put("sequencenum", (Object)false);
        dataMap.put("invoiceischange", (Object)false);
        dataMap.put("invoicefrom", (Object)"6");
        dataMap.put("billcreatetime", (Object)LocalDate.now());
        String passMsg = ResManager.loadKDString((String)"\u5408\u89c4\u6027\u6821\u9a8c\u901a\u8fc7", (String)"BillingPoolDataHandleImpl_13", (String)"fi-er-opplugin", (Object[])new Object[0]);
        dataMap.put("validatemessage", (Object)passMsg);
        if (invoiceTypeObj != null) {
            dataMap.put("offset_invoice", invoiceTypeObj.get("isoffset"));
            dataMap.put("offsetexpense", invoiceTypeObj.get("isoffset"));
        }
        if (null == (ismutilreimburse = dataMap.getBoolean("ismutilreimburse"))) {
            dataMap.put("ismutilreimburse", (Object)false);
        }
        return true;
    }

    public boolean handleEntry(ImportBillData data, Iterator<ImportBillData> iterator, JSONObject dataMap, ImportLogger logger, DynamicObject objCurrency, Map<String, Object> headAmountHolder) {
        JSONArray entities = dataMap.getJSONArray("entryentity");
        BigDecimal headTotal = BigDecimal.ZERO;
        BigDecimal headNoTaxAmount = BigDecimal.ZERO;
        BigDecimal headTaxAmount = BigDecimal.ZERO;
        HashSet<DynamicObject> rate = new HashSet<DynamicObject>();
        if (null != entities && !entities.isEmpty()) {
            for (int i = 0; i < entities.size(); ++i) {
                JSONObject entry = (JSONObject)entities.get(i);
                JSONObject unit = (JSONObject)entry.get((Object)"unit");
                if (null != unit && !this.unitList.contains(unit.getString(NUMBER))) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u660e\u7ec6%s\u5355\u4f4d\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_14", (String)"fi-er-opplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                BigDecimal total = entry.getBigDecimal("entryamount");
                if (null == total || total.compareTo(BigDecimal.ZERO) == 0) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u660e\u7ec6%s\u660e\u7ec6\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u5f55\u3002", (String)"BillingPoolDataHandleImpl_15", (String)"fi-er-opplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                JSONObject taxRate = entry.getJSONObject("invoiceitembasetaxrate");
                DynamicObject baseTaxRate = null;
                if (null != taxRate && null == (baseTaxRate = (DynamicObject)this.taxRateList.stream().filter(item -> item.getString(NUMBER).equals(taxRate.getString(NUMBER))).findFirst().orElse(null))) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u660e\u7ec6%s\u6c47\u7387\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u3002", (String)"BillingPoolDataHandleImpl_16", (String)"fi-er-opplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                rate.add(baseTaxRate);
                BigDecimal taxAmount = entry.getBigDecimal("invoiceitemtaxamount");
                if (null == taxAmount && null != baseTaxRate) {
                    int precision = objCurrency.getInt("amtprecision");
                    BigDecimal rateVal = baseTaxRate.getBigDecimal("taxrate").divide(new BigDecimal("100"));
                    taxAmount = total.multiply(rateVal).divide(BigDecimal.ONE.add(rateVal), precision, RoundingMode.HALF_EVEN);
                    entry.put("invoiceitemtaxamount", (Object)taxAmount);
                }
                if (null == taxAmount) {
                    taxAmount = BigDecimal.ZERO;
                }
                if (taxAmount.abs().compareTo(total) > 0) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u660e\u7ec6%s\u7a0e\u989d\u7edd\u5bf9\u503c\u4e0d\u80fd\u8d85\u51fa\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"BillingPoolDataHandleImpl_26", (String)"fi-er-opplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                BigDecimal expTaxAmount = total.subtract(taxAmount);
                entry.put("excludeamount", (Object)expTaxAmount);
                headTotal = headTotal.add(total);
                headNoTaxAmount = headNoTaxAmount.add(expTaxAmount);
                headTaxAmount = headTaxAmount.add(taxAmount);
                headAmountHolder.put("total", headTotal);
                headAmountHolder.put("noTax", headNoTaxAmount);
                headAmountHolder.put("tax", headTaxAmount);
                if (CollectionUtils.isEmpty(rate) || rate.stream().allMatch(Objects::isNull) || rate.size() > 1) {
                    headAmountHolder.put("rate", null);
                    continue;
                }
                headAmountHolder.put("rate", rate.stream().findFirst().orElse(null));
            }
        } else {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u81f3\u5c11\u586b\u5199\u4e00\u884c\u660e\u7ec6\u3002", (String)"BillingPoolDataHandleImpl_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String checkOver(LocalDateTime invoiceDate, BillingPoolConfigModel config, String invoiceNo) {
        String ctltype = config.getCtlType();
        int periodDay = config.getPeriod();
        LocalDate now = LocalDate.now();
        LocalDate start = now.minusDays(periodDay);
        if ("STRICT_CONTROL".equals(ctltype)) {
            if (invoiceDate.isBefore(start.atStartOfDay())) {
                return this.addTip(invoiceNo, "overDue");
            }
            int currentYear = now.getYear();
            int invoiceYear = invoiceDate.getYear();
            if (invoiceYear < currentYear) {
                if (config.isCrossYear()) {
                    LocalDate end;
                    int month = config.getUpToMonth();
                    if (month == 12) {
                        month = 0;
                        ++currentYear;
                    }
                    if (now.isAfter(end = LocalDate.of(currentYear, month + 1, 1))) {
                        return this.addTip(invoiceNo, "overMonth");
                    }
                } else {
                    return this.addTip(invoiceNo, "overYear");
                }
            }
        }
        return "";
    }

    private String checkDup(JSONObject dataMap, DynamicObject invoiceTypeObj, BillingPoolConfigModel config, int index) {
        if (null != config && config.isUniqueCon()) {
            StringBuilder keyBuilder = new StringBuilder();
            String[] fields = DEFAULT_CON;
            if (null != invoiceTypeObj) {
                String uniquecondition = invoiceTypeObj.getString("uniquecondition");
                if ("null".equals(uniquecondition) || StringUtils.isBlank((CharSequence)uniquecondition)) {
                    return "";
                }
                if (StringUtils.isNotBlank((CharSequence)uniquecondition)) {
                    fields = uniquecondition.split(",");
                }
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)"er_billingpool");
            DataEntityPropertyCollection properties = entity.getProperties();
            for (String field : fields) {
                if (properties.containsKey((Object)field)) {
                    Object fieldObj;
                    Object val = fieldObj = dataMap.get((Object)field);
                    if (fieldObj instanceof JSONObject) {
                        val = ((JSONObject)fieldObj).get((Object)"id");
                    }
                    if (null == val) continue;
                    qFilters.add(new QFilter(field, "=", val));
                    keyBuilder.append(val).append("|");
                    continue;
                }
                logger.error("\u8d26\u5355\u6c60\u552f\u4e00\u6821\u9a8c\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff1a", (Object)field);
            }
            String key = keyBuilder.toString();
            if (this.uniqueKeys.containsKey(key)) {
                String tip = ResManager.loadKDString((String)"\u4e0e\u7b2c%s\u884c\u8d26\u5355\u91cd\u590d\u3002", (String)"BillingPoolDataHandleImpl_33", (String)"fi-er-opplugin", (Object[])new Object[0]);
                return String.format(tip, this.uniqueKeys.get(key));
            }
            this.uniqueKeys.put(key, index);
            qFilters.add(new QFilter("billcreatetime", "<=", (Object)LocalDateTime.now()));
            qFilters.add(new QFilter("billcreatetime", ">=", (Object)LocalDate.now().minusYears(1L)));
            DynamicObject[] dups = BusinessDataServiceHelper.load((String)"er_billingpool", (String)"id,billno,createtime,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (null != dups && dups.length > 0) {
                String bills = Arrays.stream(dups).map(item -> item.getString("billno")).collect(Collectors.joining(","));
                String tip = ResManager.loadKDString((String)"\u53d1\u7968\u6216\u6d88\u8d39\u8d26\u5355\u5df2\u751f\u6210\u8d26\u5355%s\u3002", (String)"BillingPoolSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
                return String.format(tip, String.join((CharSequence)",", bills));
            }
        }
        return "";
    }

    private boolean isValidDate(String strDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT).withResolverStyle(ResolverStyle.STRICT);
        ParsePosition position = new ParsePosition(0);
        formatter.parseUnresolved(strDate, position);
        return position.getIndex() != 10;
    }

    private void addNum(JSONObject obj, Collection<String> numList) {
        if (null != obj && null != obj.get((Object)NUMBER)) {
            numList.add(obj.getString(NUMBER));
        }
    }

    private String addTip(String invoiceNo, String type) {
        String tip = "";
        switch (type) {
            case "overYear": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8de8\u5e74\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
                break;
            }
            case "overMonth": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8d85\u622a\u6b62\u6708\u4efd\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
                break;
            }
            case "overDue": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8d85\u671f\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
            }
        }
        return tip;
    }
}

