/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ErLoanBillManualRepay
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ErLoanBillManualRepay.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("balanceamount");
        fieldKeys.add("returnedamount");
        fieldKeys.add("appliedreimburseamount");
        fieldKeys.add("approveamount");
        fieldKeys.add("ismanualrepay");
        fieldKeys.add("expeapproveamount");
        fieldKeys.add("expeapprovecurramount");
        fieldKeys.add("orgiexpebalanceamount");
        fieldKeys.add("expebalanceamount");
        fieldKeys.add("expehasreimamount");
        fieldKeys.add("expeorihasreimamount");
        fieldKeys.add("expusedamount");
        fieldKeys.add("exporiusedamount");
        fieldKeys.add("experepayamount");
        fieldKeys.add("expeorirepayamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntities;
                for (ExtendedDataEntity billEntity : billEntities = this.getDataEntities()) {
                    Long billPkId = (Long)billEntity.getBillPkId();
                    DynamicObject bill = billEntity.getDataEntity();
                    if (!StringUtils.equals((CharSequence)"G", (CharSequence)bill.getString("billstatus"))) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u5df2\u4ed8\u6b3e\u201d\u72b6\u6001\u7684\u5355\u636e\u9700\u8981\u624b\u52a8\u8fd8\u6b3e\u3002", (String)"ErLoanBillManualRepay_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    String entityName = bill.getDataEntityType().getName();
                    Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])new Long[]{billPkId});
                    ArrayList<String> containTargetList = new ArrayList<String>();
                    if (!CollectionUtils.isEmpty((Map)targetBills) && (targetBills.containsKey("cas_paybill") || targetBills.containsKey("cas_agentpaybill"))) {
                        this.preDealTargetBills("cas_paybill", targetBills, containTargetList);
                        this.preDealTargetBills("cas_agentpaybill", targetBills, containTargetList);
                    }
                    Set targetBillKeys = targetBills.keySet();
                    ArrayList<String> otherTargetList = new ArrayList<String>();
                    for (String key : targetBillKeys) {
                        if (containTargetList.contains(key)) continue;
                        otherTargetList.add(key);
                    }
                    if (otherTargetList.size() <= 0) continue;
                    for (String key_number : otherTargetList) {
                        Set billIds;
                        QFilter idFilter;
                        QFilter statusFilter;
                        DynamicObject targetBillDym = QueryServiceHelper.queryOne((String)key_number, (String)"id", (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D"}), idFilter = new QFilter("id", "in", (Object)(billIds = (Set)targetBills.get(key_number)))});
                        if (targetBillDym == null) continue;
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5728\u9014\u5355\u636e\uff0c\u65e0\u6cd5\u624b\u52a8\u8fd8\u6b3e\u3002", (String)"ErLoanBillManualRepay_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void preDealTargetBills(String entityName, Map<String, HashSet<Long>> targetBills, List<String> coll) {
                Set<String> entityNameSet = targetBills.keySet();
                HashSet<Long> payBillIds = targetBills.get(entityName);
                if (CollectionUtils.isEmpty(payBillIds)) {
                    return;
                }
                Map downCasPayBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])payBillIds.toArray(new Long[0]));
                for (String next : entityNameSet) {
                    if (!downCasPayBills.containsKey(next)) continue;
                    coll.add(next);
                }
                coll.add(entityName);
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject loanBill : e.getDataEntities()) {
            BigDecimal headRepayed = loanBill.getBigDecimal("returnedamount");
            BigDecimal headReimbursed = loanBill.getBigDecimal("appliedreimburseamount");
            BigDecimal headApproveAmount = loanBill.getBigDecimal("approveamount");
            String repayCase = "both";
            loanBill.set("billstatus", (Object)"I");
            loanBill.set("ismanualrepay", (Object)Boolean.TRUE);
            if (headReimbursed.compareTo(BigDecimal.ZERO) != 0) {
                repayCase = "reimburse";
                loanBill.set("balanceamount", (Object)BigDecimal.ZERO);
                loanBill.set("returnedamount", (Object)headApproveAmount.subtract(headReimbursed));
                if (headRepayed.compareTo(BigDecimal.ZERO) != 0) {
                    repayCase = "both";
                }
            } else {
                repayCase = "repay";
                loanBill.set("balanceamount", (Object)BigDecimal.ZERO);
                loanBill.set("returnedamount", (Object)headApproveAmount);
                if (headRepayed.compareTo(BigDecimal.ZERO) == 0) {
                    repayCase = "neither";
                }
            }
            DynamicObjectCollection loanDetailEntry = loanBill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject loanDetail : loanDetailEntry) {
                BigDecimal detailAppOriAmount = loanDetail.getBigDecimal("expeapproveamount");
                BigDecimal detailAppAmount = loanDetail.getBigDecimal("expeapprovecurramount");
                BigDecimal detailReimburseAmount = loanDetail.getBigDecimal("expehasreimamount");
                BigDecimal detailReimburseOriAmount = loanDetail.getBigDecimal("expeorihasreimamount");
                switch (repayCase) {
                    case "both": 
                    case "reimburse": {
                        loanDetail.set("expeorirepayamount", (Object)detailAppOriAmount.subtract(detailReimburseOriAmount));
                        loanDetail.set("experepayamount", (Object)detailAppAmount.subtract(detailReimburseAmount));
                        loanDetail.set("expehasreimamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("expeorihasreimamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("expebalanceamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("orgiexpebalanceamount", (Object)BigDecimal.ZERO);
                        break;
                    }
                    case "repay": 
                    case "neither": {
                        loanDetail.set("expeorirepayamount", (Object)detailAppOriAmount);
                        loanDetail.set("experepayamount", (Object)detailAppAmount);
                        loanDetail.set("expebalanceamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("orgiexpebalanceamount", (Object)BigDecimal.ZERO);
                        break;
                    }
                }
            }
        }
    }
}

