/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.er.business.image.ImageServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.util.HeadInvoiceStatusUtil;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class CreateImageOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CreateImageOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("imageno");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("company");
        fieldKeys.add("billno");
        fieldKeys.add("is_all_einvoice");
        fieldKeys.add("noinvoice");
        fieldKeys.add("needimagescan");
        fieldKeys.add("expenseentryentity");
        fieldKeys.add("tripentry");
        fieldKeys.add("entryentity");
        fieldKeys.add("invoiceentry");
        fieldKeys.add("invoicetype");
        fieldKeys.add("expenseitem");
        fieldKeys.add("expenseitem.noinvoice");
        fieldKeys.add("needimagescan");
        fieldKeys.add("itemfrom");
        fieldKeys.add("invoicefrom");
        fieldKeys.add("expenseitem.noinvoice");
        fieldKeys.add("settlementtype");
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if ("submit".equals(e.getOperationKey()) || "confirmchangeinvoice".equals(e.getOperationKey()) || "submitredoffset".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities = e.getDataEntities();
            this.getImageNo(dataEntities);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("save".equals(e.getOperationKey())) {
            boolean saveInvokeImage = ErStdConfig.isSaveInvokeImage();
            if (!saveInvokeImage) {
                return;
            }
            DynamicObject[] dataEntities = e.getDataEntities();
            ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                ids.add(dataEntity.getLong("id"));
            }
            dataEntities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)this.billEntityType);
            if (this.getImageNo(dataEntities)) {
                SaveServiceHelper.save((DynamicObject[])dataEntities);
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        logger.info("Bill Operation exception, ImageNo rollback.");
        String type = (String)this.operateMeta.get("type");
        HashSet operationTypes = Sets.newHashSet((Object[])new String[]{"submit", "save"});
        if (operationTypes.contains(type)) {
            for (DynamicObject dataEntity : e.getDataEntitys()) {
                QFilter filter;
                DynamicObject billImageMap;
                boolean firstSubmit;
                boolean isAddNew = !dataEntity.getDataEntityState().getFromDatabase();
                Long fid = dataEntity.getLong("id");
                String billNo = dataEntity.getString("billno");
                logger.info(String.format("Bill Operation exception, ImageNo rollback billNo: %s, isAddNew: %s", billNo, isAddNew));
                boolean bl = firstSubmit = !ErStdConfig.isSaveInvokeImage() && type.equals("submit");
                if (!isAddNew && !firstSubmit || (billImageMap = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"imagenumber", (QFilter[])(filter = new QFilter("billid", "=", (Object)String.valueOf(fid))).toArray())) == null) continue;
                String imageNo = billImageMap.getString("imagenumber");
                kd.bos.servicehelper.image.ImageServiceHelper.deleteImage((String)imageNo, (String)RequestContext.get().getUserName(), null);
            }
        }
    }

    private boolean getImageNo(DynamicObject[] dataEntities) {
        boolean flag = false;
        ArrayList<ImageInfo> imageInfoList = new ArrayList<ImageInfo>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject applyCompany = dataEntity.getDynamicObject("company");
            if (applyCompany == null) continue;
            DynamicObject creator = dataEntity.getDynamicObject("creator");
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(dataEntity.getPkValue().toString());
            imageInfo.setBillNo(dataEntity.getString("billno"));
            imageInfo.setCreator(creator.getPkValue().toString());
            imageInfo.setBilltype(APIHelper.getEntityNameSSc((String)dataEntity.getDynamicObjectType().getName()));
            this.setExtField(dataEntity, imageInfo);
            String companyField = ErStdConfig.get((String)"imageInfo.company");
            boolean fieldExist = dataEntity.getDynamicObjectType().getProperty(companyField) != null;
            DynamicObject com = fieldExist ? dataEntity.getDynamicObject(companyField) : applyCompany;
            Long applyCompanyId = (Long)applyCompany.getPkValue();
            Long companyId = com != null ? (Long)com.getPkValue() : applyCompanyId;
            imageInfo.setOrgId(companyId.toString());
            String entityName = dataEntity.getDataEntityType().getName();
            if (ErEntityTypeUtils.isTripReimburseBill((String)entityName) || ErEntityTypeUtils.isDailyReimburseBill((String)entityName) || ErEntityTypeUtils.isPublicReimburseBill((String)entityName)) {
                HeadInvoiceStatusUtil.needScanSetting((DynamicObject)dataEntity);
                imageInfo.setImageScan(dataEntity.getString("needimagescan"));
            } else if (this.isBillShouldCheckTemplate(entityName)) {
                String mainEntityId;
                String configedPrintTplFormNumber;
                boolean mapInvoiceCloudImage = SystemParamterUtil.isMapInvoiceCloudImage((Long)applyCompanyId);
                DataEntityPropertyCollection porps = dataEntity.getDataEntityType().getProperties();
                Boolean needUploadInvoice = Boolean.FALSE;
                if (porps.containsKey((Object)"needuploadinvoice") && null == (needUploadInvoice = Boolean.valueOf(dataEntity.getBoolean("needuploadinvoice")))) {
                    needUploadInvoice = false;
                }
                if (mapInvoiceCloudImage && SystemParamterUtil.isPaperlessReport((Long)applyCompanyId)) {
                    dataEntity.set("needimagescan", (Object)Character.valueOf(needUploadInvoice != false ? (char)'1' : '2'));
                } else {
                    dataEntity.set("needimagescan", (Object)Character.valueOf('1'));
                }
                imageInfo.setImageScan(dataEntity.getString("needimagescan"));
                String type = (String)this.operateMeta.get("type");
                boolean isSubmit = "submit".equalsIgnoreCase(type);
                boolean isNeedImage = SystemParamterUtil.isApplyBillNeedImage((Long)applyCompanyId);
                if (mapInvoiceCloudImage && isNeedImage && isSubmit && StringUtils.isEmpty((String)(configedPrintTplFormNumber = ImageServiceHelper.getConfigedPrintTplFormNumber((DynamicObject)dataEntity, (String)(mainEntityId = dataEntity.getDataEntityType().getName()), (Long)applyCompanyId)))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u5355\u636e\u5f71\u50cf\u6a21\u677f\u3002", (String)"CreateImageOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
            imageInfoList.add(imageInfo);
        }
        try {
            Map imageNums = kd.bos.servicehelper.image.ImageServiceHelper.createImageInfoBatch(imageInfoList);
            logger.info("\u63a8\u9001\u53d1\u7968\u5f71\u50cf\u6570\u636e\u524d\u521b\u5efa\u5f71\u50cf\u7f16\u53f7\u6210\u529f\uff1a" + imageNums.values().stream().map(i -> i.getImageNo()).collect(Collectors.toSet()));
            Map<String, String> billNo2ImageNums = imageNums.entrySet().stream().collect(Collectors.toMap(entry -> ((ImageInfo)entry.getValue()).getBillNo(), entry -> ((ImageInfo)entry.getValue()).getImageNo()));
            for (DynamicObject dataEntity : dataEntities) {
                String imageNum = billNo2ImageNums.get(dataEntity.getString("billno"));
                if (imageNum == null) continue;
                dataEntity.set("imageno", (Object)imageNum);
            }
            String desc = ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u8d39\u7528\u901a\u77e5\u5171\u4eab\u5f71\u50cf\u72b6\u6001", (String)"CreateImageOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
            Map<String, String> logInfos = imageNums.entrySet().stream().collect(Collectors.toMap(entry -> ((ImageInfo)entry.getValue()).getBillNo(), entry -> SerializationUtils.toJsonString(entry.getValue())));
            InvoiceLogUtils.insertLogBatch((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.NOTIFY_SHARE, (String)desc, logInfos);
            flag = true;
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u53d1\u7968\u5f71\u50cf\u6570\u636e\u524d\u521b\u5efa\u5f71\u50cf\u7f16\u53f7\u5931\u8d25,\u5f02\u5e38\u7c7b\u578b:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u5f71\u50cf\u7f16\u53f7\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u3002", (String)"CreateImageOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        return flag;
    }

    private void setExtField(DynamicObject dataEntity, ImageInfo imageInfo) {
        boolean fieldExist = false;
        String applierField = ErStdConfig.get((String)"imageInfo.applier");
        if (StringUtils.isNotEmpty((String)applierField)) {
            DynamicObject applier;
            fieldExist = dataEntity.getDynamicObjectType().getProperty(applierField) != null;
            DynamicObject dynamicObject = applier = fieldExist ? dataEntity.getDynamicObject(applierField) : null;
            if (null != applier) {
                imageInfo.setCreator(applier.getPkValue().toString());
            }
        }
    }

    private boolean isBillShouldCheckTemplate(String entityName) {
        return ErEntityTypeUtils.isDailyLoanBill((String)entityName) || ErEntityTypeUtils.isDailyApplyBill((String)entityName) || ErEntityTypeUtils.isPrePayBill((String)entityName) || ErEntityTypeUtils.isApplyProjectBill((String)entityName) || ErEntityTypeUtils.isCostEstimateBill((String)entityName) || ErEntityTypeUtils.isWithholdingBill((String)entityName) || ErEntityTypeUtils.isContractBill((String)entityName) || ErEntityTypeUtils.isTripReqBill((String)entityName) || ErEntityTypeUtils.isDailyVehicleBill((String)entityName) || ErEntityTypeUtils.isApplyPayBill((String)entityName) || ErEntityTypeUtils.isShareBill((String)entityName) || ErEntityTypeUtils.isRepaymentBill((String)entityName);
    }
}

