/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;

public class ReimSubmitCheckAmountValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        block8: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill.getDynamicObject("company") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String type = (String)ErCommonUtils.getLoanCheckType((long)((Long)bill.getDynamicObject("company").getPkValue()));
            BigDecimal approveAmount = BigDecimal.ZERO;
            BigDecimal writeOffAmount = BigDecimal.ZERO;
            DynamicObjectCollection appEntry = bill.getDynamicObjectCollection("writeoffapply");
            if (appEntry == null || appEntry.size() == 0) {
                return;
            }
            DynamicObjectCollection expEntry = bill.getDynamicObjectCollection("expenseentryentity");
            switch (type) {
                case "1": {
                    Map expeCurrcyAmount = AmountUtils.groupByCurrencyToObject((String)"expquotetype", (DynamicObjectCollection)expEntry, (String)"expeapproveamount", (String)"expeapprovecurramount", (String)"entrycurrency", (String)"exchangerate");
                    Map appCurrencyAmount = AmountUtils.groupByCurrency((DynamicObjectCollection)appEntry, (String)"applycurrency", (String)"reimbursedamount");
                    Map<Object, Object> collect = appEntry.stream().collect(Collectors.toMap(v -> ((DynamicObject)v.get("applycurrency")).getPkValue().toString(), v -> v.get("applycurrency"), (V1, V2) -> V2));
                    for (Map.Entry appItem : appCurrencyAmount.entrySet()) {
                        String currencyName;
                        DynamicObject applycurrency;
                        AmountObject expAmount = (AmountObject)expeCurrcyAmount.get(appItem.getKey());
                        if (expAmount == null) {
                            applycurrency = (DynamicObject)collect.get(appItem.getKey());
                            currencyName = applycurrency.getString("name");
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7533\u8bf7\u7684\u5e01\u79cd\u201c%s\u201d\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"ReimSubmitCheckAmountValidator_3", (String)"fi-er-opplugin", (Object[])new Object[]{currencyName}));
                            continue block8;
                        }
                        if (expAmount.getOrgiAmount().compareTo((BigDecimal)appItem.getValue()) >= 0) continue;
                        applycurrency = (DynamicObject)collect.get(appItem.getKey());
                        currencyName = applycurrency.getString("name");
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5173\u8054\u7533\u8bf7\u7684%1$s\u51b2\u9500\u91d1\u989d\u6c47\u603b\u5408\u8ba1\u5927\u4e8e\u8d39\u7528\u660e\u7ec6%2$s\u6838\u5b9a\u91d1\u989d\u6c47\u603b\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ReimSubmitCheckAmountValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), currencyName, currencyName));
                    }
                    continue block8;
                }
                case "2": {
                    approveAmount = expEntry.stream().map(e -> e.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    writeOffAmount = appEntry.stream().map(e -> e.getBigDecimal("reimbursedcurramount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    if (approveAmount.compareTo(writeOffAmount) >= 0) continue block8;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5173\u8054\u7533\u8bf7\u7684\u51b2\u9500\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u6c47\u603b\u5408\u8ba1\u5927\u4e8e\u8d39\u7528\u660e\u7ec6\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u6c47\u603b\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ReimSubmitCheckAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue block8;
                }
            }
        }
    }
}

