/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.ExchangeRateService;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl.ErBillBaseImportHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class PubReimburseBillImportHandle
extends ErBillBaseImportHandle {
    @Override
    public boolean handleHeadData(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject paycompany;
        QFilter orgFilter;
        QFilter treeTypeFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject dynamicObject;
        if (!super.handleHeadData(data, iterator, logger)) {
            return false;
        }
        JSONObject dataMap = data.getData();
        if (dataMap.get("paycompany") != null && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)(selectFields = "isfreeze"), (QFilter[])(filters = new QFilter[]{treeTypeFilter = new QFilter("view.number", "=", (Object)"08"), orgFilter = new QFilter("org.number", "=", (paycompany = (JSONObject)dataMap.get("paycompany")).get((Object)"number"))}))) == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u652f\u4ed8\u516c\u53f8\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_04", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> billpayertypeArr = new ArrayList<String>(){
            {
                this.add("bd_supplier");
                this.add("bd_customer");
                this.add("bos_user");
            }
        };
        if (dataMap.get("billpayertype") != null && !billpayertypeArr.contains(String.valueOf(dataMap.get("billpayertype")))) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5f80\u6765\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"PubReimburseBillInitImportHandle_03", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataMap.get("billpayerid") != null && ((JSONObject)dataMap.get("billpayerid")).get((Object)"number") != null) {
            String payerType;
            JSONObject billpayerid = (JSONObject)dataMap.get("billpayerid");
            switch (payerType = String.valueOf(dataMap.get("billpayertype"))) {
                case "bd_supplier": 
                case "bd_customer": {
                    DynamicObject[] accountBanks;
                    Map map;
                    QFilter orgfilter = null;
                    JSONObject costcompany = (JSONObject)dataMap.get("costcompany");
                    if (costcompany.getLong("id") != null) {
                        orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)payerType, (Long)costcompany.getLong("id"));
                    }
                    if ((map = orgfilter == null ? BusinessDataServiceHelper.loadFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", billpayerid.get((Object)"number"))}) : BusinessDataServiceHelper.loadFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", billpayerid.get((Object)"number")).and(orgfilter)})) == null || (accountBanks = map.values().toArray(new DynamicObject[0])) != null && accountBanks.length != 0) break;
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u5b58\u5728\u6216\u8d39\u7528\u627f\u62c5\u516c\u53f8\u65e0\u5f80\u6765\u5355\u4f4d\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"PubReimburseBillInitImportHandle_08", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                case "bos_org": {
                    DynamicObject[] accountBanks;
                    Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", billpayerid.get((Object)"number"))});
                    if (map == null || (accountBanks = map.values().toArray(new DynamicObject[0])) != null && accountBanks.length != 0) break;
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u804c\u5458\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_21", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleExpenseEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        String entityName = data.getEntityMapping().getEntityType().getName();
        JSONObject dataMap = data.getData();
        JSONArray expenseEntry = (JSONArray)dataMap.get("expenseentryentity");
        if (expenseEntry.isEmpty()) {
            return false;
        }
        if (dataMap.get("ismultireimburser") == null) {
            dataMap.put("ismultireimburser", false);
        }
        boolean isMultiReimburser = (Boolean)dataMap.get("ismultireimburser");
        int costOrgShowTypes = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)dataMap.get("companyid")));
        BigDecimal amount = new BigDecimal(0);
        int i = 0;
        while (true) {
            BigDecimal taxamount;
            int amtprecision;
            BigDecimal exchangeRate;
            BigDecimal expenseAmount;
            Map row;
            block71: {
                block74: {
                    int entryPriceprecision;
                    int expIndex;
                    block70: {
                        DynamicObject currencyDy;
                        block72: {
                            Date bizDate;
                            block73: {
                                JSONObject costcompany;
                                JSONObject expenseitem;
                                if (i >= expenseEntry.size()) {
                                    String amountStr = amount.toString();
                                    dataMap.put("reimburseamount", amountStr);
                                    dataMap.put("approveamount", amountStr);
                                    dataMap.put("notpayamount", amountStr);
                                    dataMap.put("payamount", amountStr);
                                    return true;
                                }
                                row = (Map)expenseEntry.get(i);
                                expIndex = (Integer)row.get("rowNum");
                                if (row.get("expenseamount") == null) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                if (row.get("expenseitem") == null) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_16", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                if (row.get("offset") == null) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_17", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                JSONObject entryCostDept = (JSONObject)row.get("entrycostdept");
                                JSONObject entryCostCompany = (JSONObject)row.get("entrycostcompany");
                                if (row.get("happendate") != null) {
                                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                                    try {
                                        Date happendate = format.parse(String.valueOf(row.get("happendate")));
                                        if (happendate.after(new Date()) && !ErStdConfig.getBoolean((String)"expense.hanppendDate.noControl")) {
                                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u4e0d\u5e94\u8be5\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"ReimburseBillImportHandle_40", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                            return false;
                                        }
                                    }
                                    catch (ParseException e) {
                                        this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u683c\u5f0f\u4e0d\u5bf9\u3002", (String)"PubReimburseBillInitImportHandle_01", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                        return false;
                                    }
                                }
                                if ((expenseitem = (JSONObject)row.get("expenseitem")) == null || StringUtils.isEmpty((CharSequence)expenseitem.getString("number"))) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d39\u7528\u9879\u76ee\u3002", (String)"ReimburseBillImportHandle_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                if (!ImportUtils.isenableExpenseItem((String)expenseitem.getString("number"), (String)entityName)) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u53ef\u7528\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u8d39\u7528\u9879\u76ee\u88ab\u7981\u7528\uff0c\u6216\u4e3a\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u6216\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u7528\u3002", (String)"ReimburseBillImportHandle_19", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                if (entryCostCompany != null) {
                                    String costCompanyNumber = entryCostCompany.getString("number");
                                    DynamicObject costCompanyObject = ImportUtils.getCompany((String)costCompanyNumber);
                                    if (costCompanyObject == null) {
                                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u5c01\u5b58\uff0c\u6216\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ErBillBaseImportHandle_18", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                        return false;
                                    }
                                    String orgNumber = entryCostDept.getString("number");
                                    DynamicObject entrycostdeptdyn = ImportUtils.getOrgByNumber((String)orgNumber);
                                    List costcompanyNumbers = ErOrgUtils.getCostCompanySelectable((Long)ErCommonUtils.getPk((Object)entrycostdeptdyn), (Long)((Long)dataMap.get("companyid")));
                                    if (costcompanyNumbers.size() > 0 && !costcompanyNumbers.contains(costCompanyNumber)) {
                                        this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5728\u9009\u62e9\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"ErBillBaseImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                        return false;
                                    }
                                }
                                if (entryCostDept == null || entryCostDept.get((Object)"number") == null || costOrgShowTypes == 1) {
                                    row.put("entrycostdept", dataMap.get("costdept"));
                                    if (entryCostCompany == null || entryCostCompany.get((Object)"number") == null) {
                                        row.put("entrycostcompany", dataMap.get("costcompany"));
                                    }
                                } else if (entryCostDept != null) {
                                    String orgNumber = entryCostDept.getString("number");
                                    DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
                                    if (org == null) {
                                        this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ReimburseBillImportHandle_32", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                        return false;
                                    }
                                    Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)org));
                                    DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
                                    if (entryCostCompany == null || entryCostCompany.get((Object)"number") == null) {
                                        JSONObject jsonObject = ImportUtils.packageJsonObject((DynamicObject)company);
                                        jsonObject.put("id", company.getPkValue());
                                        row.put("entrycostcompany", jsonObject);
                                    } else {
                                        JSONObject entrycostcompany = (JSONObject)row.get("entrycostcompany");
                                        DynamicObject costCompany = ImportUtils.getCompany((String)entryCostCompany.getString("number"));
                                        if (costCompany != null) {
                                            entrycostcompany.put("id", costCompany.getPkValue());
                                        }
                                    }
                                    if (i == 0) {
                                        dataMap.put("costdept", row.get("entrycostdept"));
                                        dataMap.put("costcompany", row.get("entrycostcompany"));
                                    }
                                }
                                if (costOrgShowTypes == 1 && (costcompany = (JSONObject)dataMap.get("costcompany")) != null && entryCostCompany != null && !StringUtils.equals((CharSequence)costcompany.getString("number"), (CharSequence)entryCostCompany.getString("number"))) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0e\u90e8\u95e8\u5728\u5355\u5934\u663e\u793a\uff0c\u8981\u6c42\u5206\u5f55\u627f\u62c5\u516c\u53f8\u4e0d\u586b\u6216\u4e0e\u5355\u5934\u627f\u62c5\u516c\u53f8\u4e00\u81f4\u3002", (String)"ReimburseBillImportHandle_36", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                if (row.get("std_project") != null) {
                                    QFilter bdProjectFilter;
                                    entryCostCompany = (JSONObject)row.get("entrycostcompany");
                                    JSONObject std_project = (JSONObject)row.get("std_project");
                                    String number = std_project.getString("number");
                                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_project", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("status", "=", (Object)"C"), bdProjectFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", (Long)entryCostCompany.getLong("id"))});
                                    if (dynamicObject == null) {
                                        this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u6838\u7b97\u7ec4\u7ec7\u65e0\u4f7f\u7528\u6743\u9650\u3002", (String)"PubReimburseBillInitImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                        return false;
                                    }
                                }
                                if (isMultiReimburser) {
                                    JSONObject jsonReimburser = (JSONObject)row.get("pubreimburser");
                                    if (jsonReimburser == null) {
                                        row.put("pubreimburser", dataMap.get("applier"));
                                    } else {
                                        String reimburserNumber = jsonReimburser.getString("number");
                                        DynamicObject reimburser = ImportUtils.getUserByNumber((String)reimburserNumber);
                                        if (reimburser == null) {
                                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u4eba\u4e0d\u5b58\u5728\u3002", (String)"ReimburseBillImportHandle_04", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                            return false;
                                        }
                                        String value = (String)ErCommonUtils.getEMParameter((long)((Long)dataMap.get("companyid")), (String)"scopeofmultireimburser");
                                        DynamicObjectCollection entryentity = reimburser.getDynamicObjectCollection("entryentity");
                                        if ("0".equals(value)) {
                                            boolean org = false;
                                            for (DynamicObject item : entryentity) {
                                                DynamicObject dept = item.getDynamicObject("dpt");
                                                if (!dept.getString("number").equals(((JSONObject)dataMap.get("org")).getString("number"))) continue;
                                                org = true;
                                            }
                                            if (!org) {
                                                this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u7981\u6b62\u5bfc\u5165\u975e\u672c\u90e8\u95e8\u4eba\u5458\u3002", (String)"ReimburseBillImportHandle_21", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                                return false;
                                            }
                                        }
                                        if ("1".equals(value)) {
                                            boolean org = false;
                                            ArrayList<Long> companyid = new ArrayList<Long>();
                                            companyid.add((Long)dataMap.get("companyid"));
                                            List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, companyid, (boolean)true);
                                            for (DynamicObject item : entryentity) {
                                                DynamicObject dept = item.getDynamicObject("dpt");
                                                if (!allOrgList.contains(dept.getLong("masterid"))) continue;
                                                org = true;
                                            }
                                            if (!org) {
                                                this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u53ea\u80fd\u5bfc\u5165\u672c\u516c\u53f8\u4eba\u5458\u3002", (String)"ReimburseBillImportHandle_25", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                                return false;
                                            }
                                        }
                                        if ("2".equals(value)) {
                                            // empty if block
                                        }
                                        if (reimburser == null) {
                                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u4eba\u4e0d\u5b58\u5728\u3002", (String)"ReimburseBillImportHandle_04", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                            return false;
                                        }
                                        if (!reimburser.getBoolean("enable")) {
                                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u4eba\u88ab\u7981\u7528\u3002", (String)"ReimburseBillImportHandle_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                            return false;
                                        }
                                    }
                                } else {
                                    row.put("pubreimburser", dataMap.get("applier"));
                                }
                                try {
                                    expenseAmount = new BigDecimal((String)row.get("expenseamount"));
                                }
                                catch (Exception e) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReimburseBillImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                exchangeRate = BigDecimal.ONE;
                                entryPriceprecision = -1;
                                if (row.get("entrycurrency") == null || ((JSONObject)row.get("entrycurrency")).get((Object)"number") == null) break block72;
                                if (!((JSONObject)dataMap.get("currency")).get((Object)"number").equals(((JSONObject)row.get("entrycurrency")).get((Object)"number"))) {
                                    dataMap.put("iscurrency", true);
                                } else {
                                    dataMap.putIfAbsent("iscurrency", false);
                                }
                                bizDate = dataMap.get("bizdate") == null || dataMap.get("bizdate") instanceof Date ? (Date)dataMap.get("bizdate") : new Date();
                                JSONObject entrycurrency = (JSONObject)row.get("entrycurrency");
                                String exchangeRateStr = (String)row.get("exchangerate");
                                currencyDy = ImportUtils.getCurrencyIdByNumber((String)entrycurrency.getString("number"));
                                if (currencyDy == null) {
                                    this.fail(expIndex, iterator, logger, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]), entrycurrency.getString("number")));
                                    return false;
                                }
                                entryPriceprecision = currencyDy.getInt("amtprecision");
                                if (StringUtils.isBlank((CharSequence)exchangeRateStr)) break block73;
                                try {
                                    exchangeRate = new BigDecimal(exchangeRateStr);
                                }
                                catch (Exception e) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReimburseBillImportHandle_33", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                boolean quoteType = ExchangeRateService.getRateConversionConfig((Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizDate);
                                row.put("expquotetype", quoteType ? "1" : "0");
                                break block70;
                            }
                            if (dataMap.get("currency") != null && currencyDy.getPkValue().equals(((JSONObject)dataMap.get("currency")).getLong("id"))) {
                                boolean quoteType = ExchangeRateService.getRateConversionConfig((Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizDate);
                                exchangeRate = BigDecimal.ONE;
                                row.put("expquotetype", quoteType ? "1" : "0");
                                break block70;
                            } else if (dataMap.get("company") != null && dataMap.get("costcompany") != null) {
                                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateAndQuoteTypeNoDefault((Object)((JSONObject)dataMap.get("company")).get((Object)"id"), (Object)((JSONObject)dataMap.get("costcompany")).get((Object)"id"), (Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizDate);
                                if (exchangeRateAndQuoteType.get("exchangeRate") == null) {
                                    this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"PubReimburseBillInitImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                exchangeRate = (BigDecimal)exchangeRateAndQuoteType.get("exchangeRate");
                                row.put("expquotetype", exchangeRateAndQuoteType.get("quoteType"));
                                break block70;
                            } else {
                                this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"PubReimburseBillInitImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                        }
                        row.put("entrycurrency", dataMap.get("currency"));
                        row.put("expquotetype", "0");
                        currencyDy = ImportUtils.getCurrencyIdByNumber((String)((JSONObject)dataMap.get("currency")).getString("number"));
                    }
                    exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
                    row.put("exchangerate", exchangeRate);
                    amtprecision = ((JSONObject)dataMap.get("currency")).getInteger("amtprecision");
                    Object taxrate = row.get("taxrate");
                    taxamount = BigDecimal.ZERO;
                    if (!row.containsKey("taxamount") && taxrate != null) {
                        try {
                            BigDecimal rate = new BigDecimal((String)taxrate).divide(new BigDecimal("100"));
                            String airportconstructionfee = (String)row.get("airportconstructionfee");
                            BigDecimal airport = BigDecimal.ZERO;
                            if (StringUtils.isNotBlank((CharSequence)airportconstructionfee)) {
                                airport = new BigDecimal(airportconstructionfee);
                            }
                            taxamount = expenseAmount.subtract(airport).multiply(rate).divide(BigDecimal.ONE.add(rate), entryPriceprecision > -1 ? entryPriceprecision : amtprecision, 4);
                            row.put("taxamount", taxamount);
                        }
                        catch (Exception e) {
                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u7a0e\u7387\u683c\u5f0f\u6709\u8bef\u3002", (String)"PubReimburseBillInitImportHandle_23", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                    }
                    BigDecimal expenseOriAmount = "1".equals(row.get("expquotetype")) ? expenseAmount.divide(exchangeRate, amtprecision, 4) : expenseAmount.multiply(exchangeRate).setScale(amtprecision, 4);
                    row.put("currexpenseamount", expenseOriAmount.toString());
                    row.put("expeapproveamount", expenseAmount.toString());
                    row.put("expeapprovecurramount", expenseOriAmount.toString());
                    amount = amount.add(expenseOriAmount);
                    boolean offset = (Boolean)row.get("offset");
                    BigDecimal deductibletax = new BigDecimal(0);
                    if (!offset) break block74;
                    String deductibletaxeStr = (String)row.get("deductibletax");
                    if (StringUtils.isBlank((CharSequence)deductibletaxeStr)) {
                        row.put("deductibletax", "0");
                        break block71;
                    } else {
                        try {
                            deductibletax = new BigDecimal(deductibletaxeStr);
                            if (deductibletax.compareTo(new BigDecimal(0)) < 0) {
                                this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u53ef\u62b5\u6263\u91d1\u989d\u683c\u5f0f\u5e94\u4e3a\u6b63\u6570\u3002", (String)"ReimburseBillImportHandle_34", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                            if (deductibletax.compareTo(expenseAmount) > 0) {
                                this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u989d\u8d85\u8fc7\u62a5\u9500\u91d1\u989d\u3002", (String)"ReimburseBillImportHandle_31", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                            break block71;
                        }
                        catch (Exception e) {
                            this.fail(expIndex, iterator, logger, ResManager.loadKDString((String)"\u62b5\u6263\u91d1\u989d\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ReimburseBillImportHandle_35", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                    }
                }
                row.put("deductibletax", "0");
            }
            row.put("orientryamount", expenseAmount.subtract(taxamount));
            if (!row.containsKey("price")) {
                row.put("price", row.get("orientryamount"));
            }
            if (!row.containsKey("curprice")) {
                BigDecimal curprice;
                BigDecimal price = (BigDecimal)row.get("price");
                Object quoteTypeObj = row.get("expquotetype");
                if ("0".equals(quoteTypeObj)) {
                    curprice = price.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP);
                } else {
                    exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
                    curprice = price.divide(exchangeRate, amtprecision, RoundingMode.HALF_UP);
                }
                row.put("curprice", curprice);
            }
            if (row.get("taxamount") != null && row.get("approvetax") == null) {
                row.put("approvetax", row.get("taxamount"));
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleAccountEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        BigDecimal reimburseAmountSum = null;
        String amountStr = (String)dataMap.get("amount");
        if (amountStr == null) {
            amountStr = (String)dataMap.get("reimburseamount");
        }
        try {
            reimburseAmountSum = new BigDecimal(amountStr);
        }
        catch (Exception e) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ErBillBaseImportHandle_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal receiveAmountSum = new BigDecimal(0L);
        Date bizdate = new Date();
        if (dataMap.get("bizdate") instanceof Date) {
            bizdate = (Date)dataMap.get("bizdate");
        }
        if (dataMap.get("bizdate") != null && dataMap.get("bizdate") instanceof String) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                bizdate = sdf.parse(String.valueOf(dataMap.get("bizdate")));
            }
            catch (ParseException e) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"TripReimburseBillImportHandle_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        BigDecimal onaccountamount = BigDecimal.ZERO;
        boolean isOnAccount = false;
        JSONArray accountEntry = (JSONArray)dataMap.get("accountentry");
        for (int i = 0; i < accountEntry.size(); ++i) {
            BigDecimal orireceiveAmount;
            BigDecimal exchangeRate;
            Map row;
            block58: {
                block59: {
                    DynamicObject currencyDy;
                    block60: {
                        String payerType;
                        DynamicObject accountInfo = null;
                        row = (Map)accountEntry.get(i);
                        if (row.get("payertype") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_05", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (row.get("payername") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        String payername = (String)row.get("payername");
                        switch (payerType = String.valueOf(row.get("payertype"))) {
                            case "bd_supplier": 
                            case "bd_customer": {
                                QFilter orgfilter = null;
                                JSONObject costcompany = (JSONObject)dataMap.get("costcompany");
                                if (costcompany.getLong("id") != null) {
                                    orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)payerType, (Long)costcompany.getLong("id"));
                                }
                                if ((accountInfo = orgfilter == null ? BusinessDataServiceHelper.loadSingleFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername)}) : BusinessDataServiceHelper.loadSingleFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername).and(orgfilter)})) != null) break;
                                this.fail(data.getStartIndex(), iterator, logger, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6536\u6b3e\u4eba\u67e5\u627e\u4e0d\u5230\u6216\u8be5\u7ec4\u7ec7\u65e0\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"LoanBillImportDataOp_50", (String)"fi-er-opplugin", (Object[])new Object[0]), payername));
                                return false;
                            }
                            case "bos_org": {
                                String selectFields = "isfreeze";
                                QFilter treeTypeFilter = new QFilter("view.number", "=", (Object)"08");
                                QFilter orgFilter = new QFilter("org.number", "=", (Object)payername);
                                QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
                                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
                                if (dynamicObject == null) {
                                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8be5\u8d44\u91d1\u7ec4\u7ec7\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_06", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number, name, enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername)});
                                if (bosOrg == null) {
                                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8be5\u8d44\u91d1\u7ec4\u7ec7\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_06", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                accountInfo = bosOrg;
                                break;
                            }
                            case "er_payeer": {
                                QFilter userFilter = new QFilter("payer.number", "=", (Object)payername);
                                DynamicObject applier = BusinessDataServiceHelper.loadSingleFromCache((String)"er_payeer", (String)"outpayer, enable", (QFilter[])new QFilter[]{userFilter});
                                if (applier == null) {
                                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_07", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                accountInfo = applier;
                                break;
                            }
                        }
                        if (accountInfo != null) {
                            if (!"er_payeer".equals(payerType)) {
                                row.put("payername", accountInfo.get("name"));
                            } else {
                                row.put("payername", accountInfo.get("outpayer"));
                            }
                        }
                        PayerTypeEnum payerEnum = PayerTypeEnum.getValue((String)payerType);
                        JSONObject casorg = new JSONObject();
                        if (accountInfo != null && payerEnum != PayerTypeEnum.PAYER) {
                            casorg.put("number", (Object)accountInfo.getString("number"));
                        }
                        if (PayerTypeEnum.CASORG == payerEnum) {
                            row.put("casorg", casorg);
                        } else if (PayerTypeEnum.SUPPLIER == payerEnum) {
                            row.put("supplier", casorg);
                        } else if (PayerTypeEnum.CUSTOMER == payerEnum) {
                            row.put("customer", casorg);
                        } else if (PayerTypeEnum.PAYER == payerEnum) {
                            casorg.put("number", row.get("payeraccount"));
                            row.put("payer", casorg);
                        }
                        if (row.get("payerbank") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_09", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (row.get("orireceiveamount") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (row.get("ispaynow") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7acb\u5373\u652f\u4ed8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_14", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        if (row.get("payeraccount") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PubReimburseBillInitImportHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        JSONObject payerbank = (JSONObject)row.get("payerbank");
                        QFilter treeTypeFilter = new QFilter("number", "=", payerbank.get((Object)"number"));
                        QFilter[] filters = new QFilter[]{treeTypeFilter, new QFilter("enable", "=", (Object)"1")};
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bebank", (String)"number", (QFilter[])filters);
                        if (dynamicObject == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5f00\u6237\u94f6\u884c\u4e0d\u5b58\u5728\u3002", (String)"PubReimburseBillInitImportHandle_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        exchangeRate = BigDecimal.ONE;
                        if (row.get("accountcurrency") != null && !((JSONObject)dataMap.get("currency")).get((Object)"number").equals(((JSONObject)row.get("accountcurrency")).get((Object)"number"))) {
                            dataMap.put("iscurrency", true);
                        } else {
                            dataMap.putIfAbsent("iscurrency", false);
                        }
                        if (row.get("paymode") == null) {
                            QFilter qFilter = new QFilter("isdefault", "=", (Object)true);
                            qFilter.and(new QFilter("enable", "=", (Object)true));
                            DynamicObject payMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"number,name,enable", (QFilter[])new QFilter[]{qFilter});
                            if (payMode != null) {
                                row.put("paymode", ImportUtils.packageJsonObject((DynamicObject)payMode));
                            }
                        } else {
                            JSONObject jsonPaymode = (JSONObject)row.get("paymode");
                            QFilter qFilter = new QFilter("number", "=", (Object)jsonPaymode.getString("number"));
                            DynamicObject payMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"number,name,enable", (QFilter[])new QFilter[]{qFilter});
                            if (payMode != null && !payMode.getBoolean("enable")) {
                                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u5df2\u7981\u7528\u3002", (String)"ErBillBaseImportHandle_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                        }
                        if (row.get("accountcurrency") == null || ((JSONObject)row.get("accountcurrency")).getString("number") == null) break block59;
                        JSONObject accountcurrency = (JSONObject)row.get("accountcurrency");
                        String accountcurrencyNumber = accountcurrency.getString("number");
                        currencyDy = ImportUtils.getCurrencyIdByNumber((String)accountcurrencyNumber);
                        if (currencyDy == null) {
                            this.fail(data.getStartIndex(), iterator, logger, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]), accountcurrencyNumber));
                            return false;
                        }
                        String exchangeRateStr = (String)row.get("accexchangerate");
                        if (row.get("accexchangerate") == null) break block60;
                        try {
                            exchangeRate = new BigDecimal(exchangeRateStr);
                        }
                        catch (Exception e) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReimburseBillImportHandle_33", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        boolean quoteType = ExchangeRateService.getRateConversionConfig((Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizdate);
                        row.put("accquotetype", quoteType ? "1" : "0");
                        break block58;
                    }
                    if (currencyDy.getPkValue().equals(((JSONObject)dataMap.get("currency")).getLong("id"))) {
                        row.put("accquotetype", "0");
                        break block58;
                    } else if (dataMap.get("company") != null && dataMap.get("costcompany") != null) {
                        Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateAndQuoteTypeNoDefault((Object)((JSONObject)dataMap.get("company")).get((Object)"id"), (Object)((JSONObject)dataMap.get("costcompany")).get((Object)"id"), (Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizdate);
                        if (exchangeRateAndQuoteType.get("exchangeRate") == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"PubReimburseBillInitImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        exchangeRate = (BigDecimal)exchangeRateAndQuoteType.get("exchangeRate");
                        row.put("accquotetype", exchangeRateAndQuoteType.get("quoteType"));
                        break block58;
                    } else {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"PubReimburseBillInitImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                row.put("accountcurrency", dataMap.get("currency"));
                row.put("accquotetype", "0");
            }
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
            row.put("accexchangerate", exchangeRate);
            int amtprecision = ((JSONObject)dataMap.get("currency")).getInteger("amtprecision");
            String orireceiveAmountStr = (String)row.get("orireceiveamount");
            try {
                orireceiveAmount = new BigDecimal(orireceiveAmountStr);
            }
            catch (Exception e) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684\u6536\u6b3e\u91d1\u989d\u3002", (String)"ErBillBaseImportHandle_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal receiveAmount = "1".equals(row.get("accquotetype")) ? orireceiveAmount.divide(exchangeRate, amtprecision, 4) : orireceiveAmount.multiply(exchangeRate).setScale(amtprecision, 4);
            receiveAmountSum = receiveAmountSum.add(receiveAmount);
            row.put("receiveamount", receiveAmount);
            row.put("oriaccnotpayamount", orireceiveAmount);
            row.put("accnotpayamount", receiveAmount);
            if (!row.containsKey("ispaynow") || null == row.get("ispaynow") || ((Boolean)row.get("ispaynow")).booleanValue()) continue;
            onaccountamount = onaccountamount.add(receiveAmount);
            isOnAccount = true;
        }
        dataMap.put("onaccountamount", onaccountamount);
        dataMap.put("isonaccount", isOnAccount);
        if (receiveAmountSum.setScale(10, 4).compareTo(reimburseAmountSum.setScale(10, 4)) != 0) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u7b49\u4e8e\u62a5\u9500\u91d1\u989d\u3002", (String)"ErBillBaseImportHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        dataMap.put("encashamount", receiveAmountSum);
        dataMap.put("isimport", Boolean.TRUE);
        dataMap.put("reimbursetype", "expense");
        return true;
    }
}

