/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.billingpool.api.BillingPoolAPI;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.model.BillingWrtieBackArgs;
import kd.fi.er.business.billingpool.model.PoolSyncRange;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.invoicecloud.model.InvoiceTypeModel;
import kd.fi.er.business.invoicecloud.util.BillingPoolUtils;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.model.RelationMainView;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.pool.PoolAmountModel;
import kd.fi.er.common.model.invoice.pool.PoolGenerateModel;
import kd.fi.er.common.model.invoice.pool.PoolHeadModel;
import kd.fi.er.common.model.invoice.pool.PoolOtherModel;
import kd.fi.er.common.model.invoice.pool.PoolRelation;
import kd.fi.er.common.model.invoice.pool.PoolRelationModel;
import kd.fi.er.common.model.invoice.pool.PoolResultModel;
import kd.fi.er.common.model.invoice.pool.PoolSellerPurchaserModel;
import kd.fi.er.common.model.invoice.pool.PoolTravelModel;
import kd.fi.er.validator.invoicecloud.billingpool.BillingPoolControlValidator;

public class BillPoolOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BillPoolOp.class);
    private Map<String, List<InvoiceTypeModel>> invoiceMap = null;
    private Long poolTypeId = 0L;
    private Long billTypeId = 0L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        if ("submit".equals(this.getOperateType())) {
            Function<ExtendedDataEntity, List<BillingPoolControlValidator.BillingPoolControlValidatorArgs>> controlValidatorFunc = extendedDataEntity -> {
                ArrayList list = Lists.newArrayListWithExpectedSize((int)8);
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                Long accountOrg = (Long)dataEntity.getDynamicObject("costcompany").getPkValue();
                DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
                for (DynamicObject invoiceentry : invoiceEntries) {
                    Date invoiceDate = invoiceentry.getDate("invoicedate");
                    String invoiceNo = invoiceentry.getString("invoiceno");
                    Long billingId = invoiceentry.getLong("billingpoolid");
                    boolean ismutilreimburse = invoiceentry.getBoolean("ismutilreimburse");
                    BillingPoolControlValidator.BillingPoolControlValidatorArgs args = new BillingPoolControlValidator.BillingPoolControlValidatorArgs(accountOrg, invoiceDate, invoiceNo, billingId, ismutilreimburse);
                    list.add(args);
                }
                return list;
            };
            e.addValidator((AbstractValidator)new BillingPoolControlValidator(controlValidatorFunc));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("submit".equals(this.getOperateType())) {
            this.updateBillData(dataEntities);
            this.addNewBilling(dataEntities);
        } else if ("audit".equals(this.getOperateType())) {
            this.updateBillData(dataEntities);
            this.updateBilling(dataEntities);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        this.clearBillingInfo(e.getDataEntitys());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (!"submit".equals(this.getOperateType()) && !"audit".equals(this.getOperateType())) {
            this.clearBillingInfo(e.getDataEntities());
        }
    }

    private void clearBillingInfo(DynamicObject[] dataEntities) {
        HashSet billingPks = Sets.newHashSetWithExpectedSize((int)0);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
            for (DynamicObject invoiceEntry : invoiceEntries) {
                if (!invoiceEntry.getBoolean("ispool")) continue;
                billingPks.add(invoiceEntry.get("billingpoolid"));
            }
        }
        if (!billingPks.isEmpty()) {
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"BillPoolOp.clear", (String)"er_billingpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billingPks)}, (String)"id");
            while (queryDataSet.hasNext()) {
                billingPks.remove(queryDataSet.next().get("id"));
            }
        }
        if (!billingPks.isEmpty()) {
            DynamicObject[] reloadDataEntites;
            ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                ids.add(dataEntity.getLong("id"));
            }
            for (DynamicObject dataEntity : reloadDataEntites = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"invoiceentry.ispool,invoiceentry.billingpoolid", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
                DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
                for (DynamicObject invoiceEntry : invoiceEntries) {
                    if (!invoiceEntry.getBoolean("ispool") || !billingPks.contains(invoiceEntry.get("billingpoolid"))) continue;
                    invoiceEntry.set("ispool", (Object)false);
                    invoiceEntry.set("billingpoolid", (Object)0L);
                }
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])reloadDataEntites);
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    private void updateBillData(DynamicObject[] dataEntities) {
        this.updateSmallReim(dataEntities);
    }

    private void updateSmallReim(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            List<DynamicObject> invoiceList;
            DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
            if (CollectionUtils.isEmpty((Collection)invoiceEntry) || CollectionUtils.isEmpty(invoiceList = invoiceEntry.stream().filter(invoice -> !invoice.getBoolean("ismutilreimburse")).collect(Collectors.toList()))) continue;
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
            Map invoiceViewRelationGroup = InvoiceUtils2.getAllInvoiceRelationGroup((DynamicObject)dataEntity, (RelationMainView)RelationMainView.VIEW_INVOICE);
            boolean smallReim = this.checkInvoiceSmallReim(invoiceList, (List<DynamicObject>)entryEntity, invoiceViewRelationGroup);
            dataEntity.set("issmallreim", (Object)smallReim);
        }
    }

    private void updateBilling(DynamicObject[] dataEntities) {
    }

    private void addNewBilling(DynamicObject[] dataEntities) {
        List allInvoiceTypeModels = InvoiceTypeUtils.loadInvoiceModels();
        this.invoiceMap = allInvoiceTypeModels.stream().collect(Collectors.groupingBy(InvoiceTypeModel::getNumber));
        QFilter poolTypeFilter = new QFilter("number", "=", (Object)"01");
        poolTypeFilter.and("enable", "=", (Object)"1");
        DynamicObject billPoolType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_bd_billingpool_type", (QFilter[])new QFilter[]{poolTypeFilter});
        if (billPoolType != null) {
            this.poolTypeId = (Long)billPoolType.getPkValue();
        }
        QFilter billTypeFilter = new QFilter("number", "=", (Object)"er_billingpool_BT_GENERIC");
        billTypeFilter.and("enable", "=", (Object)"1");
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])new QFilter[]{billTypeFilter});
        if (billPoolType != null) {
            this.billTypeId = (Long)billType.getPkValue();
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
            List poolConfigModels = BillingPoolConfigUtils.queryPoolConfigs((Long)ErCommonUtils.getPk((Object)costCompany));
            if (poolConfigModels.isEmpty()) continue;
            BillingPoolConfigModel configModel = (BillingPoolConfigModel)poolConfigModels.get(0);
            String range = configModel.getRangOfSync();
            DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
            List<Object> poolInvoice = new ArrayList();
            if (PoolSyncRange.ALL.equalRange(range)) {
                poolInvoice = invoiceEntry.stream().filter(invoice -> !invoice.getBoolean("ispool")).collect(Collectors.toList());
            } else if (PoolSyncRange.MutilAndManual.equalRange(range)) {
                poolInvoice = invoiceEntry.stream().filter(invoice -> (InvoiceFrom.ManualAdd.equalsFrom(invoice.getString("invoicefrom")) || invoice.getBoolean("ismutilreimburse")) && !invoice.getBoolean("ispool")).collect(Collectors.toList());
            }
            if (poolInvoice.isEmpty()) continue;
            List<PoolGenerateModel> poolGenerateModels = this.buildPoolModels(dataEntity, poolInvoice);
            PoolResultModel resultModel = BillingPoolUtils.createPoolDynamicOb(poolGenerateModels);
            if (!resultModel.getSuccess().booleanValue()) {
                String errorMsg = resultModel.getErrorMsg();
                throw new KDBizException(errorMsg);
            }
            List poolRelationList = resultModel.getPoolRelation();
            Map<Long, PoolRelation> collect = poolRelationList.stream().collect(Collectors.toMap(relation -> relation.getEntryId(), relation -> relation));
            DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
            for (DynamicObject dynamicObject : invoiceEntries) {
                Long invoiceHeadId = (Long)dynamicObject.getPkValue();
                PoolRelation poolRelation = collect.get(invoiceHeadId);
                if (poolRelation == null) continue;
                dynamicObject.set("billingpoolid", (Object)poolRelation.getPoolId());
                dynamicObject.set("ispool", (Object)true);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        long currUserId = RequestContext.get().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
            ArrayList args = Lists.newArrayListWithExpectedSize((int)invoiceEntries.size());
            if ("save".equals(this.getOperateType()) && invoiceEntries.isEmpty()) {
                BillingWrtieBackArgs arg = new BillingWrtieBackArgs();
                arg.setBillno(dataEntity.getString("billno")).setEntityType(dataEntity.getDataEntityType().getName()).setOperateType(this.getOperateType()).setTid(ErCommonUtils.getPk((Object)dataEntity.getPkValue())).setCreator(Long.valueOf(currUserId));
                args.add(arg);
            } else {
                for (DynamicObject invoiceEntry : invoiceEntries) {
                    if (!invoiceEntry.getBoolean("ispool")) continue;
                    BillingWrtieBackArgs arg = new BillingWrtieBackArgs();
                    arg.setBillingid(Long.valueOf(invoiceEntry.getLong("billingpoolid"))).setCurrency(ErCommonUtils.getPk((Object)invoiceEntry.get("invoicecurrency"))).setPoolreimburseamount(invoiceEntry.getBigDecimal("poolreimburseamount")).setOffsetamount(invoiceEntry.getBigDecimal("offsetamount")).setInoutamount(invoiceEntry.getBigDecimal("inoutamount")).setBillno(dataEntity.getString("billno")).setEntityType(dataEntity.getDataEntityType().getName()).setOperateType(this.getOperateType()).setTid(ErCommonUtils.getPk((Object)dataEntity.getPkValue())).settEntryid(ErCommonUtils.getPk((Object)invoiceEntry.getPkValue())).setCreator(Long.valueOf(currUserId)).setOffset_invoice(invoiceEntry.getBoolean("offset_invoice")).setMutilreimburse(invoiceEntry.getBoolean("ismutilreimburse")).setSmallReimburse(dataEntity.getBoolean("issmallreim")).setExcessreim(invoiceEntry.getBoolean("isexcessreim")).setAccountOrg((Long)dataEntity.getDynamicObject("costcompany").getPkValue()).setReasonfortransferout(invoiceEntry.getString("reasonfortransferout")).setNodeductionreason(invoiceEntry.getString("nodeductionreason"));
                    args.add(arg);
                }
            }
            BillingPoolAPI.execWriteOff((List)args);
        }
    }

    private String getOperateType() {
        return (String)this.operateMeta.get("type");
    }

    private List<PoolGenerateModel> buildPoolModels(DynamicObject dataEntity, List<DynamicObject> poolInvoice) {
        String billNo = dataEntity.getString("billno");
        DynamicObject applier = dataEntity.getDynamicObject("applier");
        Long applierId = ErCommonUtils.getPk((Object)applier);
        DynamicObject company = dataEntity.getDynamicObject("company");
        Long companyId = ErCommonUtils.getPk((Object)company);
        DynamicObject costDept = dataEntity.getDynamicObject("costdept");
        Long costDeptId = ErCommonUtils.getPk((Object)costDept);
        DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
        Long costCompanyId = ErCommonUtils.getPk((Object)costCompany);
        DynamicObject org = dataEntity.getDynamicObject("org");
        Long orgId = ErCommonUtils.getPk((Object)org);
        DynamicObject projectType = dataEntity.getDynamicObject("projecttype");
        Long projectTypeId = ErCommonUtils.getPk((Object)projectType);
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        Long currencyId = ErCommonUtils.getPk((Object)currency);
        String billTypeName = dataEntity.getDataEntityType().getName();
        ArrayList<Long> projectwer = new ArrayList<Long>(1);
        projectwer.add((Long)applier.getPkValue());
        ArrayList<PoolGenerateModel> poolModels = new ArrayList<PoolGenerateModel>(poolInvoice.size());
        for (DynamicObject invoiceDynamicObj : poolInvoice) {
            PoolGenerateModel poolGenerateModel = new PoolGenerateModel();
            PoolHeadModel headModel = new PoolHeadModel();
            headModel.setApplierId(applierId);
            headModel.setGatherId(applierId);
            headModel.setCompanyId(companyId);
            headModel.setCostDeptId(costDeptId);
            headModel.setCostCompanyId(costCompanyId);
            headModel.setValidateOrgId(costCompanyId);
            headModel.setOrgId(orgId);
            poolGenerateModel.setPoolHeadModel(headModel);
            String invoiceTypeNumber = invoiceDynamicObj.getString("invoicetype");
            if (this.invoiceMap.containsKey(invoiceTypeNumber)) {
                headModel.setInvoiceTypeId(this.invoiceMap.get(invoiceTypeNumber).get(0).getId());
            }
            headModel.setBillPoolTypeId(this.poolTypeId);
            headModel.setBillTypeId(this.billTypeId);
            headModel.setProjectower(projectwer);
            DynamicObject country = invoiceDynamicObj.getDynamicObject("country");
            headModel.setCountryId(ErCommonUtils.getPk((Object)country));
            headModel.setCountryStr(invoiceDynamicObj.getString("countrystr"));
            headModel.setInvoiceDate(invoiceDynamicObj.getDate("invoiceDate"));
            headModel.setExpiryPayDate(invoiceDynamicObj.getDate("expirypaydate"));
            headModel.setInvoiceNo(invoiceDynamicObj.getString("invoiceno"));
            headModel.setInvoiceCode(invoiceDynamicObj.getString("invoicecode"));
            headModel.setProjectTypeId(projectTypeId);
            DynamicObject invoiceCurrency = invoiceDynamicObj.getDynamicObject("invoicecurrency");
            headModel.setInvoiceCurrencyId(ErCommonUtils.getPk((Object)invoiceCurrency));
            headModel.setCurrencyId(currencyId);
            String isRed = invoiceDynamicObj.getString("isred");
            headModel.setIsRed(isRed);
            headModel.setOffset_invoice(invoiceDynamicObj.getBoolean("offset_invoice"));
            headModel.setOffsetExpense(invoiceDynamicObj.getBoolean("offset_invoice"));
            headModel.setMutilReimburse(invoiceDynamicObj.getBoolean("ismutilreimburse"));
            headModel.setOriUsedAmount(invoiceDynamicObj.getBigDecimal("poolreimburseamount"));
            headModel.setOriBalanceAmount(invoiceDynamicObj.getBigDecimal("totalamount"));
            headModel.setRelBillType(billTypeName);
            headModel.setRelBill(billNo);
            headModel.setSerialNo(invoiceDynamicObj.getString("serialno"));
            headModel.setInvoiceFrom(invoiceDynamicObj.getString("invoicefrom"));
            headModel.setBillCreateTime(invoiceDynamicObj.getDate("billcreatetime") == null ? new Date() : invoiceDynamicObj.getDate("billcreatetime"));
            poolGenerateModel.setPoolHeadModel(headModel);
            if ("1".equals(isRed)) {
                headModel.setInvoiceStatus("redInvoice");
            } else {
                String ticketChanges = invoiceDynamicObj.getString("ticketchanges");
                if ("2".equals(ticketChanges)) {
                    headModel.setInvoiceStatus("rescheduled");
                } else if ("3".equals(ticketChanges)) {
                    headModel.setInvoiceStatus("ticketSale");
                } else if ("4".equals(ticketChanges)) {
                    headModel.setInvoiceStatus("ticketRefund");
                } else {
                    headModel.setInvoiceStatus("normal");
                }
            }
            PoolSellerPurchaserModel sellerPurchaserModel = new PoolSellerPurchaserModel();
            DynamicObject buyerOrg = invoiceDynamicObj.getDynamicObject("buyerorg");
            sellerPurchaserModel.setBuyerOrgId(ErCommonUtils.getPk((Object)buyerOrg));
            sellerPurchaserModel.setBuyerOrgName(invoiceDynamicObj.getString("buyerorgname"));
            sellerPurchaserModel.setBuyerTaxNo(invoiceDynamicObj.getString("buyertaxno"));
            DynamicObject sellerOrg = invoiceDynamicObj.getDynamicObject("sellerorg");
            sellerPurchaserModel.setSellerOrgId(ErCommonUtils.getPk((Object)sellerOrg));
            sellerPurchaserModel.setMakeOutCompName(invoiceDynamicObj.getString("makeoutcompname"));
            sellerPurchaserModel.setSalerTaxNo_h(invoiceDynamicObj.getString("salertaxno_h"));
            poolGenerateModel.setPoolSellerPurchaserModel(sellerPurchaserModel);
            PoolTravelModel travelModel = new PoolTravelModel();
            travelModel.setFlightTrainNums(invoiceDynamicObj.getString("flighttrainnums"));
            travelModel.setSeatGrade(invoiceDynamicObj.getString("seatgrade"));
            travelModel.setTimeGetOn(invoiceDynamicObj.getDate("timegeton"));
            travelModel.setTimeGetOff(invoiceDynamicObj.getDate("timegetoff"));
            travelModel.setInvoiceFromCity(invoiceDynamicObj.getString("invoicefromcity"));
            travelModel.setInvoiceFromCity(invoiceDynamicObj.getString("invoicetocity"));
            travelModel.setiStartProvince(invoiceDynamicObj.getString("istartprovince"));
            travelModel.setiDestProvince(invoiceDynamicObj.getString("idestprovince"));
            travelModel.setiStartCity(invoiceDynamicObj.getString("istartcity"));
            travelModel.setiDestCity(invoiceDynamicObj.getString("idestcity"));
            travelModel.setPassengerName(invoiceDynamicObj.getString("passengername"));
            travelModel.setCustomerIdNumber(invoiceDynamicObj.getString("customeridnumber"));
            poolGenerateModel.setPoolTravelModel(travelModel);
            PoolAmountModel amountModel = new PoolAmountModel();
            amountModel.setTotalAmount(invoiceDynamicObj.getBigDecimal("totalamount"));
            amountModel.setAllTaxRate(invoiceDynamicObj.getString("alltaxrate"));
            amountModel.setTaxDetails(invoiceDynamicObj.getString("taxdetails"));
            amountModel.setTaxAmount_invoice(invoiceDynamicObj.getBigDecimal("taxamount_invoice"));
            amountModel.setInvoiceNoTaxAmount(invoiceDynamicObj.getBigDecimal("invoicenotaxamount"));
            amountModel.setOffsetAmount(BigDecimal.ZERO);
            amountModel.setInOutAmount(BigDecimal.ZERO);
            amountModel.setGatherTotalAmount(invoiceDynamicObj.getBigDecimal("totalamount"));
            amountModel.setGatherTaxAmount(invoiceDynamicObj.getBigDecimal("taxamount_invoice"));
            amountModel.setInsurancePremium(invoiceDynamicObj.getBigDecimal("insurancepremium"));
            amountModel.setAirConstFee(invoiceDynamicObj.getBigDecimal("airconstfee"));
            amountModel.setOtherTotalTaxAmount(invoiceDynamicObj.getBigDecimal("othertotaltaxamount"));
            poolGenerateModel.setPoolAmountModel(amountModel);
            PoolOtherModel otherModel = new PoolOtherModel();
            otherModel.setIe_validaTest(invoiceDynamicObj.getString("ie_validatest"));
            String isChangeStr = invoiceDynamicObj.getString("invoiceischange");
            if ("1".equals(isChangeStr)) {
                otherModel.setInvoiceIsChange(Boolean.valueOf(false));
            } else {
                otherModel.setInvoiceIsChange(Boolean.valueOf(true));
            }
            otherModel.setSequenceNum(invoiceDynamicObj.getString("sequencenum"));
            otherModel.setSequenceNumInfo(invoiceDynamicObj.getString("sequencenuminfo"));
            otherModel.setValidateMessage(invoiceDynamicObj.getString("validatemessage"));
            otherModel.setReasonForTransferOut(invoiceDynamicObj.getString("reasonfortransferout"));
            otherModel.setNodeductionreason(invoiceDynamicObj.getString("nodeductionreason"));
            otherModel.setRemark_invoice(invoiceDynamicObj.getString("remark_invoice"));
            poolGenerateModel.setPoolOtherModel(otherModel);
            ArrayList<PoolRelationModel> relationModels = new ArrayList<PoolRelationModel>(1);
            PoolRelationModel relationModel = new PoolRelationModel();
            relationModel.setRelBillId(dataEntity.getPkValue().toString());
            relationModel.setRelbills(dataEntity.getString("billno"));
            relationModel.setEntityId(dataEntity.getDataEntityType().getName());
            relationModel.setRelEntryId((Long)invoiceDynamicObj.getPkValue());
            relationModels.add(relationModel);
            poolGenerateModel.setPoolRelationModels(relationModels);
            poolModels.add(poolGenerateModel);
        }
        return poolModels;
    }

    private boolean checkInvoiceSmallReim(List<DynamicObject> invoiceObjs, List<DynamicObject> entryEntity, Map<Long, InvoiceRelation> invoiceViewRelationGroup) {
        BigDecimal invoiceTotalAmount;
        BigDecimal totalApproveAmount;
        Set<Long> invoiceHeadIdSet = invoiceViewRelationGroup.keySet();
        List needCheckInvoiceList = invoiceObjs.stream().filter(invoiceObj -> invoiceHeadIdSet.contains(invoiceObj.getPkValue())).collect(Collectors.toList());
        Set expenseIdSet = needCheckInvoiceList.stream().map(invoiceObj -> (InvoiceRelation)invoiceViewRelationGroup.get(invoiceObj.getPkValue())).flatMap(relation -> relation.getOtherViewIds().stream()).collect(Collectors.toSet());
        List needCheckExpenseList = entryEntity.stream().filter(entity -> expenseIdSet.contains(entity.getPkValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(needCheckExpenseList)) {
            return false;
        }
        Set entryCurrencySet = needCheckExpenseList.stream().map(entity -> ErCommonUtils.getPk((Object)entity.getDynamicObject("entrycurrency"))).collect(Collectors.toSet());
        Set invoiceCurrencySet = needCheckInvoiceList.stream().map(entity -> ErCommonUtils.getPk((Object)entity.getDynamicObject("invoicecurrency"))).collect(Collectors.toSet());
        if (entryCurrencySet.size() != 1 || invoiceCurrencySet.size() != 1) {
            return false;
        }
        return entryCurrencySet.containsAll(invoiceCurrencySet) && (totalApproveAmount = needCheckExpenseList.stream().map(entity -> entity.getBigDecimal("expeapproveamount")).reduce(BigDecimal::add).get()).compareTo(invoiceTotalAmount = needCheckInvoiceList.stream().map(entity -> entity.getBigDecimal("totalamount")).reduce(BigDecimal::add).get()) < 0;
    }
}

