/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.checkingpay;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.opplugin.invoicecloud.checkingpay.SavePlugin;
import kd.fi.er.validator.invoicecloud.checkInvoice.CheckingPaySubmitCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class SubmitPlugin
extends SavePlugin {
    private static Log log = LogFactory.getLog(SubmitPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("entryentity");
        list.add("actentryamount");
        list.add("invoiceentry");
        list.add("totalamount");
        list.add("appliercompany");
        list.add(this.getInvocieOrgName());
        list.add("totalamount_head");
        list.add("totalaccloanamount");
        list.add("company");
        list.add("invoiceentry");
        list.add("personalinvoice");
        list.add("passverifybuyername");
        list.add("passverifybuyertaxno");
        list.add("ie_validatest");
        list.add("writeoffmoney");
        list.add("writeoffmoney.loanamount");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extendedDataEntities;
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
                    BigDecimal entryAmount;
                    BigDecimal totalaccloanamount;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    BigDecimal settleamount_head = dataEntity.getBigDecimal("settleamount");
                    DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                    BigDecimal total_actentryamount = BigDecimal.ZERO;
                    if (null != entryentity) {
                        for (DynamicObject dynamicObject : entryentity) {
                            total_actentryamount = total_actentryamount.add(dynamicObject.getBigDecimal("actentryamount"));
                        }
                    }
                    if (settleamount_head.compareTo(total_actentryamount) != 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5934\u7684\u201c\u7ed3\u7b97\u91d1\u989d\u201d\u5e94\u7b49\u4e8e\u201c\u7ed3\u7b97\u5355\u5173\u8054\u4fe1\u606f\u201d\u5206\u5f55\u7684\u201c\u7ed3\u7b97\u91d1\u989d\u201d\u4e4b\u548c\u3002", (String)"SubmitPlugin_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    if ((totalaccloanamount = dataEntity.getBigDecimal("totalaccloanamount")).compareTo(entryAmount = AmountUtils.getEntryAmount((DynamicObjectCollection)dataEntity.getDynamicObjectCollection("writeoffmoney"), (String)"loanamount")) <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6838\u9500\u91d1\u989d\u5df2\u5927\u4e8e\u603b\u501f\u6b3e\u4f59\u989d\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u540e\u91cd\u8bd5\u3002", (String)"SubmitPlugin_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.addValidator((AbstractValidator)new CheckingPaySubmitCheckInvoiceValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((String)this.operateMeta.get("key")), (CharSequence)"submit")) continue;
            InvoiceUtils.checkTaxAmount((DynamicObject)dynamicObject, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.CheckingPayBill);
        }
    }

    @Override
    protected DynamicObject getApplyCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("appliercompany");
    }
}

