/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.kingdee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.image.ImageServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.model.InvoiceData;
import kd.fi.er.business.invoicecloud.model.UpdateInvoiceStatusParam;
import kd.fi.er.business.invoicecloud.provider.param.req.BillOperationInfo;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.model.invoice.bo.ReasonForTransferOut;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class BillOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(BillOpPlugin.class);
    private Map<Object, Boolean> invokeInvoiceCloudCache = new HashMap<Object, Boolean>();
    protected Object operationId = null;
    protected boolean isAsyncOperation = false;
    protected Object icpId;
    protected String billEntityName;
    private boolean isWorkflow = false;
    protected Map<Object, DynamicObject> oldBillMap = Maps.newHashMapWithExpectedSize((int)0);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.isWorkflow = this.isWorkflowInvoke();
        Map<Object, DynamicObject> oldEntitiesMap = Stream.of(e.getDataEntities()).filter(o -> o.getDataEntityState().getFromDatabase()).collect(Collectors.toMap(DataEntityBase::getPkValue, a -> a));
        Set<Object> pkSet = oldEntitiesMap.keySet();
        if (!pkSet.isEmpty()) {
            DynamicObject[] oldBills = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)("id,invoiceentry.serialno," + this.getInvocieOrgName()), (QFilter[])new QFilter[]{new QFilter("id", "in", pkSet)});
            this.oldBillMap = Arrays.stream(oldBills).collect(Collectors.toMap(DataEntityBase::getPkValue, b -> b));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("billno");
        list.add("serialno");
        list.add(this.getInvocieOrgName());
        list.add("invoicemerge.serialno_merge");
        list.add("company");
        list.add("invoiceentry.offset_invoice");
        list.add("invoiceentry.offsetamount");
        list.add("invoiceentry.taxamount_invoice");
        list.add("invoiceentry.reasonfortransferout");
        list.add("invoiceentry.inoutamount");
        list.add("invoiceentry.invoicefrom");
        list.add("invoiceentry.invoicetype");
        list.add("invoiceentry.nodeductionreason");
        list.add("billstatus");
        list.add("creator");
        list.add("applier");
        list.add("invokeinvoicecloud");
        list.add("invoiceattachinfo");
        list.add("invoiceattachinfo.attachno");
    }

    private boolean isWorkflowInvoke() {
        String wfVariableValue = this.getOption().getVariableValue("WF", "FALSE");
        return wfVariableValue != null && wfVariableValue.equalsIgnoreCase("TRUE");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> successList;
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.analyzeInvokeInvoiceCloud(dataEntities);
        if (dataEntities.length > 1 && !(successList = this.batchInvoiceOperation(dataEntities, false)).isEmpty()) {
            e.setDataEntities(successList.toArray(new DynamicObject[0]));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        if (e.getDataEntities().length == 1) {
            this.batchInvoiceOperation(e.getDataEntities(), false);
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        super.rollbackOperation(e);
        DynamicObject[] dataEntities = e.getDataEntitys();
        this.batchInvoiceOperation(dataEntities, true);
    }

    private void analyzeInvokeInvoiceCloud(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (!KingdeeInvoiceCloudConfig.isEnabled((long)((Long)this.getInvoiceOrgDO(dataEntity).getPkValue()))) {
                this.invokeInvoiceCloudCache.put(dataEntity.getPkValue(), false);
                continue;
            }
            long applyCompanyId = this.getApplyCompany(dataEntity).getLong("id");
            boolean mapInvoiceCloudImage = SystemParamterUtil.isMapInvoiceCloudImage((Long)applyCompanyId);
            mapInvoiceCloudImage = mapInvoiceCloudImage && SystemParamterUtil.isPaperlessReport((Long)applyCompanyId);
            boolean containInvoiceFromCloud = false;
            if (dataEntity.getDynamicObjectType().getProperty("invoiceentry") != null) {
                DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
                containInvoiceFromCloud = invoiceEntries.stream().anyMatch(v -> InvoiceFrom.InvoiceCloud.getValue().equals(v.getString("invoicefrom")));
            }
            boolean containAttachFromCloud = AttachmentCountUtils.getInvoiceAttachmentCount((DynamicObject)dataEntity) > 0L;
            boolean invokeInvoiceCloudOld = dataEntity.getBoolean("invokeInvoiceCloud");
            boolean invokeInvoiceCloud = mapInvoiceCloudImage || containInvoiceFromCloud || containAttachFromCloud;
            this.invokeInvoiceCloudCache.put(dataEntity.getPkValue(), invokeInvoiceCloudOld || invokeInvoiceCloud);
            dataEntity.set("invokeinvoicecloud", (Object)invokeInvoiceCloud);
        }
    }

    protected void showInView(DynamicObject dataEntity, String errorInfoStr, String title) {
        OperationResult operationResult = this.getOperationResult();
        OperateErrorInfo errorInfo = new OperateErrorInfo(title, ErrorLevel.Error, dataEntity.getPkValue());
        errorInfo.setMessage(errorInfoStr);
        errorInfo.setTitle(title);
        operationResult.addErrorInfo(errorInfo);
    }

    private void invoiceOperation(DynamicObject dataEntity, boolean isRollback) throws RuntimeException {
        if (this.getInvoiceOrgDO(dataEntity) == null) {
            return;
        }
        if (!KingdeeInvoiceCloudConfig.isEnabled((long)((Long)this.getInvoiceOrgDO(dataEntity).getPkValue()))) {
            return;
        }
        logger.info("\u8d39\u7528\u627f\u62c5\u516c\u53f8id: {}", this.getInvoiceOrgDO(dataEntity).getPkValue());
        Boolean invokeInvoiceCloud = this.invokeInvoiceCloudCache.get(dataEntity.getPkValue());
        if (invokeInvoiceCloud != null && invokeInvoiceCloud.booleanValue()) {
            String billno = dataEntity.getString("billno");
            logger.info(String.format("\u5355\u636e %s \u6267\u884c %s", billno, this.getOpDesc()));
            String taxRegNum = this.getTaxRegNum(dataEntity);
            if (taxRegNum == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25, \u5931\u8d25\u539f\u56e0:\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", (String)"BillOpPlugin_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            try {
                UpdateInvoiceStatusRespParam updateInvoiceStatus;
                UpdateInvoiceStatusRespParam updateInvoiceStatusRespParam = updateInvoiceStatus = isRollback ? this.updateInvoiceStatus(dataEntity, isRollback) : this.updateInvoiceStatus(dataEntity, taxRegNum);
                if (!updateInvoiceStatus.isSuccess()) {
                    String tipsInfo = updateInvoiceStatus.getDescription();
                    if (tipsInfo != null && tipsInfo.contains("DEAL_FAIL")) {
                        tipsInfo = ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u7cfb\u7edf\u65e0\u6cd5\u8bbf\u95ee\u3002", (String)"BillOpPlugin_10", (String)"fi-er-opplugin", (Object[])new Object[0]);
                    }
                    logger.info(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25, \u5931\u8d25\u539f\u56e0:%s", (String)"BillOpPlugin_13", (String)"fi-er-opplugin", (Object[])new Object[0]), tipsInfo));
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25, \u53d1\u7968\u4e91\u53cd\u9988\u5931\u8d25\u539f\u56e0:%s", (String)"BillOpPlugin_11", (String)"fi-er-opplugin", (Object[])new Object[0]), tipsInfo));
                }
            }
            catch (Exception e1) {
                logger.info("\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25:" + e1.getMessage());
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25, \u5931\u8d25\u539f\u56e0:%s", (String)"BillOpPlugin_13", (String)"fi-er-opplugin", (Object[])new Object[0]), e1.getMessage()), e1);
            }
        }
    }

    private List<DynamicObject> batchInvoiceOperation(DynamicObject[] dataEntities, boolean isRollback) {
        boolean isBatch;
        logger.info(String.format("isRollback: %s", isRollback));
        boolean bl = isBatch = dataEntities.length > 1;
        if (!isRollback) {
            String plugin = ((Object)((Object)this)).getClass().getName();
            DynamicObject operation = QueryServiceHelper.queryOne((String)"er_operation", (String)"id,sync", (QFilter[])new QFilter[]{new QFilter("plugin", "=", (Object)plugin)});
            if (operation != null) {
                this.isAsyncOperation = this.isWorkflow || !operation.getBoolean("sync");
                this.operationId = operation.get("id");
            }
            this.billEntityName = dataEntities[0].getDataEntityType().getName();
            DynamicObject icp = QueryServiceHelper.queryOne((String)"er_invoicecloudprovider", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)true).toArray());
            this.icpId = icp.get("id");
        }
        ArrayList successList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        String errorInfoFormat = ResManager.loadKDString((String)"\u5355\u636e%1$s\u6267\u884c%2$s\u5931\u8d25\u3002\u539f\u56e0\uff1a%3$s\u3002", (String)"BillOpPlugin_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
        for (DynamicObject dataEntity : dataEntities) {
            String billNo = dataEntity.getString("billno");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                String errorInfo = String.format(errorInfoFormat, billNo, this.getOpDesc(), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillOpPlugin_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                if (isBatch) {
                    this.showInView(dataEntity, errorInfo, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BillOpPlugin_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                throw new KDBizException(errorInfo);
            }
            try {
                this.invoiceOperation(dataEntity, isRollback);
                if (!isBatch) continue;
                successList.add(dataEntity);
            }
            catch (Exception e2) {
                logger.error((Throwable)e2);
                String errorInfo = String.format(errorInfoFormat, billNo, this.getOpDesc(), e2.getMessage());
                if (isBatch) {
                    this.showInView(dataEntity, errorInfo, ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"BillOpPlugin_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                throw new KDBizException((Throwable)e2, new ErrorCode("BillOpPlugin,afterExecuteOperationTransaction", errorInfo), new Object[0]);
            }
        }
        return successList;
    }

    protected String getTaxRegNum(DynamicObject dataEntity) {
        Object orgPk = dataEntity.get(this.getInvocieOrgName() + ".id");
        if (orgPk == null) {
            return null;
        }
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)((Long)orgPk));
        if (taxRegNum == null) {
            logger.info(String.format("%s\u5355\u636e%s\uff0c\u4f01\u4e1a\u7a0e\u53f7\u4e3a\u7a7a", this.getOpDesc(), dataEntity.getString("billno")));
            return null;
        }
        return taxRegNum;
    }

    protected UpdateInvoiceStatusRespParam updateInvoiceStatus(DynamicObject dataEntity, String taxRegNum) throws Exception {
        return this.updateInvoiceStatus(dataEntity, false);
    }

    private UpdateInvoiceStatusRespParam updateInvoiceStatus(DynamicObject dataEntity, boolean isRollback) throws Exception {
        UpdateInvoiceStatusRespParam response;
        long billId = dataEntity.getLong("id");
        String billNo = dataEntity.getString("billno");
        DynamicObject invoiceOrgDO = this.getInvoiceOrgDO(dataEntity);
        Long invoiceOrgId = ErCommonUtils.getPk((Object)invoiceOrgDO);
        DynamicObjectCollection invoiceEntryDOs = new DynamicObjectCollection();
        if (isRollback) {
            DynamicObject oldBill = this.oldBillMap.get(dataEntity.getLong("id"));
            if (oldBill != null && oldBill.getDynamicObjectType().getProperty("invoiceentry") != null) {
                invoiceEntryDOs = oldBill.getDynamicObjectCollection("invoiceentry");
            }
        } else if (dataEntity.getDynamicObjectType().getProperty("invoiceentry") != null) {
            invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        }
        String type = (String)this.operateMeta.get("type");
        String operationNo = (String)this.operateMeta.get("key");
        HashSet operationNos = Sets.newHashSet((Object[])new String[]{"saveinvoice", "checking", "converttoc", "audit", "fixcoverdata"});
        HashSet operationTypes = Sets.newHashSet((Object[])new String[]{"submit", "audit"});
        InvoiceStatusEnum invoiceStatus = isRollback ? this.getRollbackStatus(dataEntity) : this.getTargetStatus();
        UpdateInvoiceStatusParam param = operationNos.contains(operationNo) || operationTypes.contains(type) ? this.buildUpdateInvoiceStatusParamWithCovertData(dataEntity, invoiceOrgId, invoiceStatus, true, invoiceEntryDOs) : this.buildUpdateInvoiceStatusParam(dataEntity, invoiceOrgId, invoiceStatus, false, invoiceEntryDOs);
        if (this.operationId != null) {
            BillOperationInfo billOperationInfo = new BillOperationInfo();
            billOperationInfo.setBillId(billId);
            billOperationInfo.setBillNumber(billNo);
            billOperationInfo.setBillMetadataNumber(this.billEntityName);
            billOperationInfo.setIcpId(this.icpId);
            billOperationInfo.setOperationId(this.operationId);
            billOperationInfo.setAsync(this.isAsyncOperation);
            billOperationInfo.setWorkflow(this.isWorkflow);
            billOperationInfo.setOrgId((Object)invoiceOrgId);
            param.setBillOperation(billOperationInfo);
        }
        if (!(response = InvoiceService.getInstanceService().updateInvoiceStatus(dataEntity, param)).isSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25, \u5931\u8d25\u539f\u56e0:%s", (String)"BillOpPlugin_13", (String)"fi-er-opplugin", (Object[])new Object[0]), response.getDescription()));
        }
        return response;
    }

    protected abstract InvoiceStatusEnum getTargetStatus();

    protected abstract InvoiceStatusEnum getRollbackStatus(DynamicObject var1);

    protected abstract String getOpDesc();

    protected DynamicObject getInvoiceOrgDO(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject(this.getInvocieOrgName());
    }

    protected String getInvocieOrgName() {
        return "costcompany";
    }

    protected DynamicObject getApplyCompany(DynamicObject dataEntity) {
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"company")) {
            return dataEntity.getDynamicObject("company");
        }
        return null;
    }

    protected UpdateInvoiceStatusParam buildUpdateInvoiceStatusParam(DynamicObject dataEntity, Long invoiceOrgId, InvoiceStatusEnum status, boolean isVerify, DynamicObjectCollection invoiceEntrys) {
        UpdateInvoiceStatusParam param = new UpdateInvoiceStatusParam();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)invoiceOrgId);
        String taxRegnum = config.getTaxRegnum();
        String companyName = config.getFirmname();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = taxNoList.size() < companyNameList.size() ? taxNoList.size() : companyNameList.size();
        ArrayList companyInfos = Lists.newArrayListWithExpectedSize((int)companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            companyInfos.add(new UpdateInvoiceStatusParam.CompanyInfo((String)taxNoList.get(i), (String)companyNameList.get(i)));
        }
        param.setCompanyInfo((List)companyInfos);
        String entityId = dataEntity.getDataEntityType().getName();
        param.setBillType(entityId);
        param.setBillNo(dataEntity.getString("billno"));
        param.setBillId(dataEntity.getPkValue().toString());
        param.setEntityId(entityId);
        param.setViewPage(entityId);
        param.setOrgId(invoiceOrgId.toString());
        param.setStatus(String.valueOf(status.getValue()));
        Long applierId = null;
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"applier")) {
            applierId = ErCommonUtils.getPk((Object)dataEntity.get("applier"));
        }
        logger.info("applierId: {}", applierId);
        if (applierId != null && applierId.compareTo(0L) > 0) {
            param.setBillUser(String.valueOf(applierId));
        } else {
            param.setBillUser(String.valueOf(RequestContext.get().getCurrUserId()));
        }
        param.setAppId(this.getAppId(entityId));
        if (isVerify) {
            param.setVerifyFlag("1");
        }
        ArrayList<InvoiceData> invoiceDataList = new ArrayList<InvoiceData>();
        if (invoiceEntrys != null && !invoiceEntrys.isEmpty()) {
            invoiceDataList = new ArrayList(invoiceEntrys.size());
            DynamicProperty isPool = invoiceEntrys.getDynamicObjectType().getProperty("ispool");
            Object normalInvoiceDyObjs = null;
            List poolInvoiceDyObjs = null;
            if (isPool == null) {
                normalInvoiceDyObjs = invoiceEntrys;
            } else {
                normalInvoiceDyObjs = invoiceEntrys.stream().filter(inv -> !inv.getBoolean("ispool")).collect(Collectors.toList());
                poolInvoiceDyObjs = invoiceEntrys.stream().filter(inv -> inv.getBoolean("ispool")).collect(Collectors.toList());
            }
            List<InvoiceData> normalInvoiceDataList = this.buildDefaultInvoiceData(invoiceOrgId, (Collection<DynamicObject>)normalInvoiceDyObjs);
            invoiceDataList.addAll(normalInvoiceDataList);
            List<InvoiceData> poolInvoiceDataList = this.buildPoolInvoiceData(invoiceOrgId, poolInvoiceDyObjs);
            invoiceDataList.addAll(poolInvoiceDataList);
        }
        param.setInvoiceData(invoiceDataList);
        String delAttachment = this.getOption().getVariableValue("cache_attachno_bydelete_invoice", "");
        Set removeSet = new HashSet(0);
        if (StringUtils.isNotEmpty((CharSequence)delAttachment)) {
            removeSet = (Set)SerializationUtils.fromJsonString((String)delAttachment, HashSet.class);
        }
        Set attachmentSerialNos = AttachmentCountUtils.getInvoiceAttachmentSerialNos((DynamicObject)dataEntity, removeSet);
        param.setAttachmentFids(attachmentSerialNos.stream().collect(Collectors.joining(",")));
        return param;
    }

    protected UpdateInvoiceStatusParam buildUpdateInvoiceStatusParamWithCovertData(DynamicObject dataEntity, Long invoiceOrgId, InvoiceStatusEnum status, boolean isVerify, DynamicObjectCollection invoiceEntrys) {
        UpdateInvoiceStatusParam param = this.buildUpdateInvoiceStatusParam(dataEntity, invoiceOrgId, status, isVerify, invoiceEntrys);
        UpdateInvoiceStatusParam.CoverData coverData = new UpdateInvoiceStatusParam.CoverData();
        String mainEntityId = dataEntity.getDataEntityType().getName();
        DynamicObject applyCompanyDO = null;
        Long orgId = 0L;
        applyCompanyDO = this.getApplyCompany(dataEntity);
        if (applyCompanyDO != null) {
            orgId = (Long)ObjectUtils.defaultIfNull((Object)ErCommonUtils.getPk((Object)applyCompanyDO), (Object)0L);
        }
        String configedPrintTemplateFormId = ImageServiceHelper.getConfigedPrintTplFormNumber((DynamicObject)dataEntity, (String)mainEntityId, (Long)orgId);
        logger.info("updateInvoiceStatus: mainEntityId=" + mainEntityId + ", orgId=" + orgId + ", configedPrintTemplateFormId=" + configedPrintTemplateFormId + ", pkId=" + dataEntity.getPkValue());
        if (StringUtils.isNotBlank((CharSequence)configedPrintTemplateFormId)) {
            String imageNumber = ImageServiceHelper.getImageNumber((String)dataEntity.getDataEntityType().getName(), (Long)((Long)dataEntity.getPkValue()));
            if (StringUtils.isNotBlank((CharSequence)imageNumber)) {
                String fakePageId = "fake-" + UUID.randomUUID().toString().replace("-", "");
                byte[] imagePdf = ImageServiceHelper.createSinglePdf((String)fakePageId, (String)mainEntityId, (String)configedPrintTemplateFormId, (Object)dataEntity.getPkValue());
                if (imagePdf != null && imagePdf.length > 0) {
                    String base64Str = ImageServiceHelper.convertBase64Str((byte[])imagePdf);
                    coverData.setBase64(base64Str);
                    coverData.setCoveType("pdf");
                    coverData.setCoveNo(imageNumber);
                    param.setCoverData(coverData);
                    logger.info("request Param: " + JSON.toJSONString((Object)param, (SerializeFilter)UpdateInvoiceStatusParam.CoverData.valueFilter, (SerializerFeature[])new SerializerFeature[0]));
                } else {
                    logger.warn("\u672a\u83b7\u53d6\u5230pdf\u6587\u4ef6\u6d41");
                }
            } else {
                logger.info("\u5f71\u50cf\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u4f20\u5c01\u9762\u3002");
            }
        } else {
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u914d\u7f6e\u7684\u6253\u5370\u6a21\u677f");
        }
        return param;
    }

    private String getAppId(String entityId) {
        String appId = "kdem";
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isExpenseRecordBill((String)entityId)) {
            appId = "exp";
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            appId = "tra";
        }
        return appId;
    }

    private List<InvoiceData> buildDefaultInvoiceData(Long invoiceOrgId, Collection<DynamicObject> normalInvoiceDyObjs) {
        if (normalInvoiceDyObjs == null || normalInvoiceDyObjs.isEmpty()) {
            return new ArrayList<InvoiceData>();
        }
        ArrayList<InvoiceData> invoiceDataList = new ArrayList<InvoiceData>(normalInvoiceDyObjs.size());
        for (DynamicObject invoiceObj : normalInvoiceDyObjs) {
            InvoiceData invoiceData = new InvoiceData();
            String serialNo = invoiceObj.getString("serialno");
            invoiceData.setSerialNo(serialNo);
            DataEntityPropertyCollection invoiceEntityProperty = invoiceObj.getDataEntityType().getProperties();
            if (invoiceEntityProperty.get((Object)"offset_invoice") != null) {
                invoiceData.setIsOffset(Boolean.valueOf(invoiceObj.getBoolean("offset_invoice")));
            }
            if (ErStdConfig.getPostBackTeype() == 2) {
                if (invoiceEntityProperty.get((Object)"offsetamount") != null && invoiceEntityProperty.get((Object)"inoutamount") != null) {
                    invoiceData.setOffsetAmount(invoiceObj.getBigDecimal("offsetamount").add(invoiceObj.getBigDecimal("inoutamount")));
                }
            } else if (ErStdConfig.getPostBackTeype() == 3) {
                if (invoiceEntityProperty.get((Object)"taxamount_invoice") != null) {
                    invoiceData.setOffsetAmount(invoiceObj.getBigDecimal("taxamount_invoice"));
                }
            } else if (invoiceEntityProperty.get((Object)"offsetamount") != null) {
                invoiceData.setOffsetAmount(invoiceObj.getBigDecimal("offsetamount"));
            }
            if (invoiceEntityProperty.get((Object)"reasonfortransferout") != null) {
                invoiceData.setInOutReson(ReasonForTransferOut.getReason((String)invoiceObj.getString("reasonfortransferout")));
            }
            if (invoiceEntityProperty.get((Object)"nodeductionreason") != null) {
                invoiceData.setNoDeductionReason(invoiceObj.getString("nodeductionreason"));
            }
            if (invoiceEntityProperty.get((Object)"inoutamount") != null) {
                invoiceData.setOutAount(invoiceObj.getBigDecimal("inoutamount"));
            }
            if (invoiceEntityProperty.get((Object)"invoicefrom") != null) {
                invoiceData.setInvoiceFrom(invoiceObj.getString("invoicefrom"));
            }
            if (invoiceEntityProperty.get((Object)"invoicetype") != null) {
                invoiceData.setInvoiceType(invoiceObj.getString("invoicetype"));
            }
            invoiceData.setInvoiceOrgId(invoiceOrgId);
            invoiceDataList.add(invoiceData);
        }
        return invoiceDataList;
    }

    private List<InvoiceData> buildPoolInvoiceData(Long invoiceOrgId, Collection<DynamicObject> poolInvoiceDyObjs) {
        if (poolInvoiceDyObjs == null || poolInvoiceDyObjs.isEmpty()) {
            return new ArrayList<InvoiceData>();
        }
        ArrayList<InvoiceData> invoiceDataList = new ArrayList<InvoiceData>(poolInvoiceDyObjs.size());
        List billingPoolIds = poolInvoiceDyObjs.stream().map(inv -> inv.getLong("billingpoolid")).collect(Collectors.toList());
        DynamicObject[] billingPoolCollection = BillingPoolConfigUtils.queryBillingPoolByIds(billingPoolIds);
        List<Object> existsPoolIds = billingPoolCollection == null || billingPoolCollection.length == 0 ? new ArrayList() : Arrays.stream(billingPoolCollection).map(pool -> (Long)pool.getPkValue()).collect(Collectors.toList());
        List<DynamicObject> notPoolInvoices = poolInvoiceDyObjs.stream().filter(invoice -> !existsPoolIds.contains(invoice.getLong("billingpoolid"))).collect(Collectors.toList());
        if (notPoolInvoices != null && !notPoolInvoices.isEmpty()) {
            invoiceDataList.addAll(this.buildDefaultInvoiceData(invoiceOrgId, notPoolInvoices));
        }
        if (billingPoolCollection != null && billingPoolCollection.length != 0) {
            for (DynamicObject billingPool : billingPoolCollection) {
                DynamicObject invoicetype;
                InvoiceData invoiceData = new InvoiceData();
                String serialNo = billingPool.getString("serialno");
                invoiceData.setSerialNo(serialNo);
                DataEntityPropertyCollection billingPoolProperties = billingPool.getDataEntityType().getProperties();
                if (billingPoolProperties.get((Object)"offset_invoice") != null) {
                    invoiceData.setIsOffset(Boolean.valueOf(billingPool.getBoolean("offset_invoice")));
                }
                if (ErStdConfig.getPostBackTeype() == 2) {
                    if (billingPoolProperties.get((Object)"offsetamount") != null && billingPoolProperties.get((Object)"inoutamount") != null) {
                        invoiceData.setOffsetAmount(billingPool.getBigDecimal("offsetamount").add(billingPool.getBigDecimal("inoutamount")));
                    }
                } else if (ErStdConfig.getPostBackTeype() == 3) {
                    if (billingPoolProperties.get((Object)"taxamount_invoice") != null) {
                        invoiceData.setOffsetAmount(billingPool.getBigDecimal("taxamount_invoice"));
                    }
                } else if (billingPoolProperties.get((Object)"offsetamount") != null) {
                    invoiceData.setOffsetAmount(billingPool.getBigDecimal("offsetamount"));
                }
                if (billingPoolProperties.get((Object)"reasonfortransferout") != null) {
                    invoiceData.setInOutReson(ReasonForTransferOut.getReason((String)billingPool.getString("reasonfortransferout")));
                }
                if (billingPoolProperties.get((Object)"nodeductionreason") != null) {
                    invoiceData.setNoDeductionReason(billingPool.getString("nodeductionreason"));
                }
                if (billingPoolProperties.get((Object)"inoutamount") != null) {
                    invoiceData.setOutAount(billingPool.getBigDecimal("inoutamount"));
                }
                if (billingPoolProperties.get((Object)"invoicefrom") != null) {
                    invoiceData.setInvoiceFrom(billingPool.getString("invoicefrom"));
                }
                if (billingPoolProperties.get((Object)"invoicetype") != null && (invoicetype = billingPool.getDynamicObject("invoicetype")) != null) {
                    invoiceData.setInvoiceType(invoicetype.getString("number"));
                }
                if (billingPoolProperties.get((Object)"costcompany") != null) {
                    invoiceData.setInvoiceOrgId(ErCommonUtils.getPk((Object)billingPool.get("costcompany")));
                }
                invoiceDataList.add(invoiceData);
            }
        }
        return invoiceDataList;
    }
}

