/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.isc.xk;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class DailyBillIscXkOp
extends AbstractOperationServicePlugIn {
    private String entityNumber;

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        MainEntityType entityType = this.billEntityType;
        BillEntityType mainType = null;
        if (entityType instanceof BillEntityType) {
            mainType = (BillEntityType)entityType;
        }
        if (mainType != null) {
            this.entityNumber = mainType.getName();
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        boolean isIscXk = SystemParamterUtil.isIscXk((long)RequestContext.get().getOrgId());
        if (!isIscXk) {
            return;
        }
        List fieldKeys = e.getFieldKeys();
        if (ErEntityTypeUtils.isRepaymentBill((String)this.entityNumber)) {
            fieldKeys.add("repaymententry");
        } else {
            fieldKeys.add("accountentry");
        }
        fieldKeys.add("accountcurrency");
        fieldKeys.add("paymode");
        fieldKeys.add("company");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    String vaildateStr;
                    DynamicObject bill = billEntity.getDataEntity();
                    if (bill.getDynamicObject("company") == null) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    boolean isIscXk = SystemParamterUtil.isIscXk((long)ErCommonUtils.getPk((Object)bill.get("company")));
                    if (!isIscXk || !StringUtils.isNotBlank((CharSequence)(vaildateStr = DailyBillIscXkOp.this.getVaildateStr(bill)))) continue;
                    this.addErrorMessage(billEntity, vaildateStr);
                }
            }
        });
    }

    private String getVaildateStr(DynamicObject bill) {
        String vaildateStr = "";
        DynamicObjectCollection entrys = null;
        entrys = ErEntityTypeUtils.isRepaymentBill((String)this.entityNumber) ? bill.getDynamicObjectCollection("repaymententry") : bill.getDynamicObjectCollection("accountentry");
        if (entrys == null || entrys.isEmpty() || entrys.size() < 1) {
            return vaildateStr;
        }
        Set<Long> accCurrencyIdSet = this.getDOIdSet(entrys, "accountcurrency");
        if (accCurrencyIdSet == null || accCurrencyIdSet.size() < 1) {
            return vaildateStr;
        }
        if (ErEntityTypeUtils.isTripReqBill((String)this.entityNumber)) {
            if (entrys.size() > 1) {
                return ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u8bbe\u7f6e\u7cfb\u7edf\u53c2\u6570\u201c\u4e0e\u661f\u7a7a\u96c6\u6210\u201d\u4e3a\u662f\uff0c\u6536\u6b3e\u4fe1\u606f\u53ea\u5141\u8bb8\u586b\u5199\u4e00\u884c\uff0c\u4e0d\u5141\u8bb8\u591a\u884c\u3002", (String)"DailyBillIscXkOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            Set<Long> reqCurrencyIdSet = this.getDOIdSet(bill.getDynamicObjectCollection("tripentry"), "tripcurrency");
            if (reqCurrencyIdSet != null && reqCurrencyIdSet.size() > 1) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u5e01\u79cd\u5fc5\u987b\u4e0e\u501f\u6b3e\u660e\u7ec6\u5e01\u79cd\u4e00\u81f4\u3002", (String)"DailyBillIscXkOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            if (reqCurrencyIdSet != null && reqCurrencyIdSet.size() == 1 && reqCurrencyIdSet.addAll(accCurrencyIdSet)) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u5e01\u79cd\u5fc5\u987b\u4e0e\u501f\u6b3e\u660e\u7ec6\u5e01\u79cd\u4e00\u81f4\u3002", (String)"DailyBillIscXkOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)this.entityNumber)) {
            if (entrys.size() > 1) {
                return ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u8bbe\u7f6e\u7cfb\u7edf\u53c2\u6570\u201c\u4e0e\u661f\u7a7a\u96c6\u6210\u201d\u4e3a\u662f\uff0c\u6536\u6b3e\u4fe1\u606f\u53ea\u5141\u8bb8\u586b\u5199\u4e00\u884c\uff0c\u4e0d\u5141\u8bb8\u591a\u884c\u3002", (String)"DailyBillIscXkOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            Set<Long> loanCurrencyIdSet = this.getDOIdSet(bill.getDynamicObjectCollection("expenseentryentity"), "entrycurrency");
            if (loanCurrencyIdSet != null && loanCurrencyIdSet.size() > 1) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u5e01\u79cd\u5fc5\u987b\u4e0e\u501f\u6b3e\u660e\u7ec6\u5e01\u79cd\u4e00\u81f4\u3002", (String)"DailyBillIscXkOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            if (loanCurrencyIdSet != null && loanCurrencyIdSet.size() == 1 && loanCurrencyIdSet.addAll(accCurrencyIdSet)) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u5e01\u79cd\u5fc5\u987b\u4e0e\u501f\u6b3e\u660e\u7ec6\u5e01\u79cd\u4e00\u81f4\u3002", (String)"DailyBillIscXkOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
        }
        if (ErEntityTypeUtils.isDailyReimburseBill((String)this.entityNumber) || ErEntityTypeUtils.isPublicReimburseBill((String)this.entityNumber) || ErEntityTypeUtils.isTripReimburseBill((String)this.entityNumber)) {
            if (accCurrencyIdSet.size() > 1) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u5e01\u79cd\u9700\u4e00\u81f4\u3002", (String)"DailyBillIscXkOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            Set<Long> accPayModeIdSet = this.getDOIdSet(entrys, "paymode");
            if (accPayModeIdSet.size() > 1) {
                return ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u652f\u4ed8\u65b9\u5f0f\u5fc5\u987b\u76f8\u540c\u3002", (String)"DailyBillIscXkOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
        }
        if (ErEntityTypeUtils.isRepaymentBill((String)this.entityNumber) && accCurrencyIdSet.size() > 1) {
            return ResManager.loadKDString((String)"\u8fd8\u6b3e\u660e\u7ec6\u5e01\u79cd\u9700\u76f8\u540c\u3002", (String)"DailyBillIscXkOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        return vaildateStr;
    }

    private Set<Long> getDOIdSet(DynamicObjectCollection entrys, String propName) {
        Set<Long> doIdSet = entrys.stream().filter(v -> v.getDynamicObject(propName) != null).map(v -> (Long)v.getDynamicObject(propName).getPkValue()).collect(Collectors.toSet());
        return doIdSet;
    }
}

