/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.contract;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.publicbiz.bill.contract.ErContractCodeValidator;
import kd.fi.er.validator.publicbiz.bill.contract.ErContractProjectAmountValidator;
import org.apache.commons.lang3.StringUtils;

public class ContractToChangeBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("frameworkcontract");
        e.getFieldKeys().add("biztype_changebill");
        e.getFieldKeys().add("projectentryentity");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("contractcurrency");
        e.getFieldKeys().add("payterms");
        e.getFieldKeys().add("expenseitem");
        e.getFieldKeys().add("paymenttypeid");
        e.getFieldKeys().add("changerate");
        e.getFieldKeys().add("termentry");
        e.getFieldKeys().add("itemcode");
        e.getFieldKeys().add("itemname");
        e.getFieldKeys().add("itemcontent");
        e.getFieldKeys().add("detailtype");
        e.getFieldKeys().add("oriapplyamount");
        e.getFieldKeys().add("changeamount");
        e.getFieldKeys().add("expenseentryentity");
        e.getFieldKeys().add("contractamount");
        e.getFieldKeys().add("acexpeapproveamount");
        e.getFieldKeys().add("entryorichangeamount");
        e.getFieldKeys().add("entrycontractamount");
        e.getFieldKeys().add("detailtype");
        e.getFieldKeys().add("biztype_changebill");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("expenseamount");
        e.getFieldKeys().add("itemfrom");
        e.getFieldKeys().add("orientryamount");
        e.getFieldKeys().add("currexpenseamount");
        e.getFieldKeys().add("projectcanamount");
        e.getFieldKeys().add("changerate");
        e.getFieldKeys().add("paypercent");
        e.getFieldKeys().add("paybyrata");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("availableamount");
        e.getFieldKeys().add("currexpenseamount");
        e.getFieldKeys().add("wbsrcbillid");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("srcbilltype");
        e.getFieldKeys().add("oriavailableamount");
        e.getFieldKeys().add("contractcode");
        e.getFieldKeys().add("projectcurrency");
        e.getFieldKeys().add("oriprojectcanamount");
        e.getFieldKeys().add("entrycurrency");
        e.getFieldKeys().add("oriprojectwriteoffamount");
        e.getFieldKeys().add("projectwriteoffamount");
        e.getFieldKeys().add("stdbilltype");
        e.getFieldKeys().add("signcontract");
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                    boolean paybyrata;
                    boolean aBoolean;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    String detailType = dataEntity.getString("detailtype");
                    String changetype = dataEntity.getString("changetype");
                    DynamicObjectCollection itemcodeTermentry = dataEntity.getDynamicObjectCollection("termentry");
                    itemcodeTermentry.stream().filter(it -> it.get("itemcode") != null).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("itemcode"))).entrySet().forEach(itr -> {
                        List value = (List)itr.getValue();
                        if (value.size() > 1) {
                            String err = String.format(ResManager.loadKDString((String)"\u5408\u540c\u6761\u6b3e\u7684\u6761\u6b3e\u7f16\u53f7\u201c%s\u201d\u91cd\u590d\u3002", (String)"ContractToChangeBillOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), itr.getKey());
                            this.addErrorMessage(extendedDataEntity, err);
                        }
                    });
                    itemcodeTermentry.stream().filter(it -> it.get("itemname") != null).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("itemname"))).entrySet().forEach(itr -> {
                        List value = (List)itr.getValue();
                        if (value.size() > 1) {
                            String err = String.format(ResManager.loadKDString((String)"\u5408\u540c\u6761\u6b3e\u7684\u6761\u6b3e\u540d\u79f0\u201c%s\u201d\u91cd\u590d\u3002", (String)"ContractToChangeBillOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]), itr.getKey());
                            this.addErrorMessage(extendedDataEntity, err);
                        }
                    });
                    if (detailType.equalsIgnoreCase("biztype_applybill") || detailType.equalsIgnoreCase("biztype_changebill")) {
                        String err;
                        String err2;
                        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("contractpartyentry");
                        DynamicObject parta = dynamicObjectCollection.stream().filter(v -> "0".equals(v.getString("signcontract"))).findAny().orElse(null);
                        DynamicObject partb = dynamicObjectCollection.stream().filter(v -> "1".equals(v.getString("signcontract"))).findAny().orElse(null);
                        Set collectA = dynamicObjectCollection.stream().filter(v -> "0".equals(v.getString("signcontract"))).map(p -> p.getString("partytype")).collect(Collectors.toSet());
                        Set collectB = dynamicObjectCollection.stream().filter(v -> "1".equals(v.getString("signcontract"))).map(p -> p.getString("partytype")).collect(Collectors.toSet());
                        if (parta == null || partb == null) {
                            err2 = ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u81f3\u5c11\u6709\u4e00\u4e2a\u7532\u65b9\u548c\u4e00\u4e2a\u4e59\u65b9\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ContractToChangeBillOp_10", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(extendedDataEntity, err2);
                            break;
                        }
                        if (collectA.size() > 1) {
                            err2 = ResManager.loadKDString((String)"\u7532\u65b9\u7b7e\u7ea6\u65b9\u7c7b\u578b\u987b\u76f8\u540c\u3002", (String)"ContractToChangeBillOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(extendedDataEntity, err2);
                            break;
                        }
                        if (collectB.size() > 1) {
                            err2 = ResManager.loadKDString((String)"\u4e59\u65b9\u7b7e\u7ea6\u65b9\u7c7b\u578b\u987b\u76f8\u540c\u3002", (String)"ContractToChangeBillOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            this.addErrorMessage(extendedDataEntity, err2);
                            break;
                        }
                        HashSet<Long> collectPA = new HashSet<Long>();
                        HashSet<Long> collectPB = new HashSet<Long>();
                        HashSet<Long> collectPother = new HashSet<Long>();
                        int pA = 0;
                        int pB = 0;
                        int pOther = 0;
                        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                            DynamicObject partyDynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                            String signcontract = partyDynamicObject.getString("signcontract");
                            DynamicObject contractparty = partyDynamicObject.getDynamicObject("contractparty");
                            if ("0".equals(signcontract) && contractparty != null) {
                                collectPA.add((Long)contractparty.getPkValue());
                                ++pA;
                                continue;
                            }
                            if ("1".equals(signcontract) && contractparty != null) {
                                collectPB.add((Long)contractparty.getPkValue());
                                ++pB;
                                continue;
                            }
                            if (!"2".equals(signcontract) || contractparty == null) continue;
                            collectPother.add((Long)contractparty.getPkValue());
                            ++pOther;
                        }
                        StringBuilder stb = new StringBuilder();
                        if (collectPA.size() != pA) {
                            err = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u7532\u65b9\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"EM-E-182135", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            stb.append(err);
                        }
                        if (collectPB.size() != pB) {
                            err = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u4e59\u65b9\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"EM-E-218242", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            stb.append(err);
                        }
                        if (collectPother.size() != pOther) {
                            err = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u5176\u4ed6\u65b9\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"EM-E-667004", (String)"fi-er-opplugin", (Object[])new Object[0]);
                            stb.append(err);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)stb.toString())) {
                            this.addErrorMessage(extendedDataEntity, stb.toString());
                            break;
                        }
                    }
                    if (aBoolean = dataEntity.getBoolean("frameworkcontract")) continue;
                    DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
                    if (expenseEntrys.size() == 0 && "true".equals(ErStdConfig.get((String)"contratct.expenseentity.must"))) {
                        String err = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u3002", (String)"ContractToChangeBillOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(extendedDataEntity, err);
                        break;
                    }
                    for (int i = 0; i < expenseEntrys.size(); ++i) {
                        DynamicObject expDynamicObject = (DynamicObject)expenseEntrys.get(i);
                        BigDecimal expenseamount = expDynamicObject.getBigDecimal("expenseamount");
                        BigDecimal orientryamount = expDynamicObject.getBigDecimal("orientryamount");
                        String itemfrom = expDynamicObject.getString("itemfrom");
                        String err = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u7b2c%1$s\u884c\uff1a\u201c\u542b\u7a0e\u91d1\u989d\u201d\u3002", (String)"ContractToChangeBillOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1);
                        String err2 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u8ba1\u5212\u201d\u7b2c%1$s\u884c\uff1a\u201c\u53d8\u66f4\u7a0e\u989d\u201d\u3002", (String)"ContractToChangeBillOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1);
                        if (detailType.equalsIgnoreCase("biztype_changebill") && ("A".equals(changetype) || "C".equals(changetype))) {
                            if (!"0".equals(itemfrom) || expenseamount.compareTo(BigDecimal.ZERO) != 0 && orientryamount.compareTo(BigDecimal.ZERO) != 0) continue;
                            this.addErrorMessage(extendedDataEntity, err2);
                            break;
                        }
                        if (!detailType.equalsIgnoreCase("biztype_applybill") || expenseamount.compareTo(BigDecimal.ZERO) != 0 && orientryamount.compareTo(BigDecimal.ZERO) != 0) continue;
                        this.addErrorMessage(extendedDataEntity, err);
                        break;
                    }
                    if (detailType.equalsIgnoreCase("biztype_changebill") && ("A".equals(changetype) || "C".equals(changetype)) && expenseEntrys != null && expenseEntrys.size() > 0) {
                        BigDecimal currexpenseamount = AmountUtils.getEntryAmount((DynamicObjectCollection)expenseEntrys, (String)"currexpenseamount");
                        BigDecimal expenseamount = AmountUtils.getEntryAmount((DynamicObjectCollection)expenseEntrys, (String)"expenseamount");
                        BigDecimal availableamount = dataEntity.getBigDecimal("availableamount");
                        BigDecimal oriavailableamount = dataEntity.getBigDecimal("oriavailableamount");
                        long wbsrcbillid = ((DynamicObject)expenseEntrys.get(0)).getLong("wbsrcbillid");
                        DynamicObject contract = QueryServiceHelper.queryOne((String)"er_contractbill", (String)"id,availableamount,oriavailableamount", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wbsrcbillid)});
                        if (contract != null) {
                            availableamount = contract.getBigDecimal("availableamount");
                            oriavailableamount = contract.getBigDecimal("oriavailableamount");
                        }
                        if (currexpenseamount.add(availableamount).compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                            continue;
                        }
                        if (expenseamount.add(oriavailableamount).compareTo(BigDecimal.ZERO) < 0) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\uff08\u539f\u5e01\uff09\u3002", (String)"RelationContractAmountValidator_18", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                            continue;
                        }
                    }
                    if (!(paybyrata = dataEntity.getBoolean("paybyrata"))) continue;
                    BigDecimal paypercent = expenseEntrys.stream().map(v -> v.getBigDecimal("paypercent")).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
                    if (paypercent.compareTo(new BigDecimal(100L)) != 0) {
                        String err = ResManager.loadKDString((String)"\u4ed8\u6b3e\u6bd4\u4f8b\u5408\u8ba1\u5fc5\u987b\u7b49\u4e8e100%\uff0c\u8bf7\u5148\u4fee\u6539\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"ContractToChangeBillOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(extendedDataEntity, err);
                        break;
                    }
                    BigDecimal prorataamount = dataEntity.getBigDecimal("prorataamount");
                    BigDecimal totalexpenseamount = expenseEntrys.stream().map(v -> v.getBigDecimal("expenseamount")).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
                    if (totalexpenseamount.compareTo(prorataamount) == 0) continue;
                    String err = ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5206\u5f55\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5355\u5934\u5408\u540c\u91d1\u989d\u3002", (String)"ContractToChangeBillOp_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedDataEntity, err);
                    break;
                }
            }
        });
        e.addValidator((AbstractValidator)new ErContractProjectAmountValidator());
        e.addValidator((AbstractValidator)new ErContractCodeValidator());
    }
}

