/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.reverseorder;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.servicehelper.ReverseBillServiceHelper;

public class PublicReimBillReverseOrderOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PublicReimBillReverseOrderOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Integer isreimburse = 1;
        Integer isapprove = 0;
        String billstatus = "A";
        String reimburseStatus = "B";
        switch (e.getOperationKey()) {
            case "delete": 
            case "invalid": {
                isreimburse = 0;
                isapprove = 0;
                billstatus = "A";
                reimburseStatus = "A";
                break;
            }
            case "audit": {
                isapprove = 1;
                billstatus = "C";
                break;
            }
            case "converttoi": 
            case "closebill": {
                reimburseStatus = "C";
                isapprove = 1;
                billstatus = "C";
            }
        }
        this.reverseOrderStatus(dataEntities, isreimburse, isapprove, billstatus, reimburseStatus);
    }

    private void reverseOrderStatus(DynamicObject[] dataEntities, Integer isreimburse, Integer isapprove, String billstatus, String reimburseStatus) {
        if (dataEntities != null) {
            logger.info("\u53cd\u5199\u5546\u65c5\u8ba2\u5355\u603b\u8868\u903b\u8f91 \uff1a" + Arrays.stream(dataEntities).map(d -> d.getString("billno")).collect(Collectors.toSet()));
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                String billno = dataEntity.getString("billno");
                String formId = dataEntity.getDataEntityType().getName();
                if (isreimburse == 0) {
                    billno = "";
                    formId = "";
                }
                Map sourceBillIds = BFTrackerServiceHelper.findSourceBills((String)dataEntity.getDataEntityType().getName(), (Long[])new Long[]{Long.parseLong(dataEntity.getPkValue().toString())});
                ReverseBillServiceHelper.reverseOrderStatus((Map)sourceBillIds, (Integer)isreimburse, (Integer)isapprove, (String)billstatus, (String)reimburseStatus, (String)billno, (String)formId);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Integer isreimburse = 1;
        Integer isapprove = 0;
        String billstatus = "A";
        if (Arrays.asList("save", "submit").contains(e.getOperationKey())) {
            this.reverseOrderStatus(dataEntities, isreimburse, isapprove, billstatus, "B");
        }
    }
}

