/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.share;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.share.ERHandleBeforeShareService;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.OperateUtils;
import org.apache.commons.lang3.StringUtils;

public class EntryBeforeShareOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    Boolean isShare = bill.getBoolean("isbeforeshare");
                    if (!isShare.booleanValue()) {
                        DynamicObjectCollection shareDetailEntrys;
                        bill.set("sharerule_startdate", null);
                        bill.set("sharerule_enddate", null);
                        bill.set("isshared", (Object)false);
                        DynamicObjectCollection waitEntrys = bill.getDynamicObjectCollection("expenseentryentity");
                        if (waitEntrys != null && waitEntrys.size() > 0) {
                            for (int i = 0; i < waitEntrys.size(); ++i) {
                                DynamicObject expenEntry = (DynamicObject)waitEntrys.get(i);
                                DynamicObjectCollection shareEntrys = expenEntry.getDynamicObjectCollection("expenseentryentity_rule");
                                if (shareEntrys == null || shareEntrys.size() <= 0) continue;
                                shareEntrys.clear();
                            }
                        }
                        if ((shareDetailEntrys = bill.getDynamicObjectCollection("sharedetailentry")) == null || shareDetailEntrys.size() <= 0) continue;
                        shareDetailEntrys.clear();
                        continue;
                    }
                    Object shareRule = bill.get("sharerule");
                    if (shareRule == null) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u644a\u89c4\u5219\u3002", (String)"EntryBeforeShareOpPlugin_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection waitEntrys = bill.getDynamicObjectCollection("expenseentryentity");
                    if (waitEntrys == null || waitEntrys.size() <= 0) continue;
                    for (int i = 0; i < waitEntrys.size(); ++i) {
                        DynamicObject expenEntry = (DynamicObject)waitEntrys.get(i);
                        DynamicObjectCollection ruleEntrys = expenEntry.getDynamicObjectCollection("expenseentryentity_rule");
                        if (this.validateEntryRule(billEntity, bill, ruleEntrys, i).booleanValue()) continue;
                        return;
                    }
                }
            }

            private Boolean validateEntryRule(ExtendedDataEntity billEntity, DynamicObject bill, DynamicObjectCollection ruleEntrys, int expenIndex) {
                BigDecimal doing_shareRate;
                BigDecimal sumShareRate;
                IDataEntityType entityType = bill.getDataEntityType();
                String entityId = entityType.getName();
                String expenEntryTips = "";
                if (ErEntityTypeUtils.isApplyProjectBill((String)entityId)) {
                    expenEntryTips = String.format(ResManager.loadKDString((String)"\u5728\u7b2c%s\u884c\u7acb\u9879\u660e\u7ec6\u4e2d", (String)"EntryBeforeShareOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]), expenIndex + 1);
                }
                if (ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
                    expenEntryTips = String.format(ResManager.loadKDString((String)"\u5728\u7b2c%s\u884c\u6682\u4f30\u660e\u7ec6\u4e2d", (String)"EntryBeforeShareOpPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]), expenIndex + 1);
                }
                if (ruleEntrys == null || ruleEntrys.isEmpty()) {
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u644a\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5206\u644a\u660e\u7ec6\u3002", (String)"EntryBeforeShareOpPlugin_3", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips));
                    return false;
                }
                Object shareMethod = bill.get("sharemethod");
                Object shareRule = bill.get("sharerule");
                if (StringUtils.equals((CharSequence)"orgrule", (CharSequence)String.valueOf(shareRule))) {
                    sumShareRate = BigDecimal.ZERO;
                    int index = 1;
                    for (Object obj : ruleEntrys) {
                        DynamicObject entryCostCompany = obj.getDynamicObject("entrycostcompany_orgrule");
                        DynamicObject entryCostDept = obj.getDynamicObject("entrycostdept_orgrule");
                        doing_shareRate = obj.getBigDecimal("sharerate_comrule");
                        if (null == entryCostDept) {
                            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u5b57\u6bb5\u3002", (String)"EntryBeforeShareOpPlugin_15", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips, index));
                            return false;
                        }
                        if (null == entryCostCompany) {
                            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u5b57\u6bb5\u3002", (String)"EntryBeforeShareOpPlugin_16", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips, index));
                            return false;
                        }
                        if ("rate".equalsIgnoreCase((String)shareMethod) && (null == doing_shareRate || doing_shareRate.compareTo(BigDecimal.ZERO) == 0)) {
                            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u5206\u644a\u6bd4\u4f8b\u201d\u5b57\u6bb5\u3002", (String)"EntryBeforeShareOpPlugin_17", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips, index));
                            return false;
                        }
                        sumShareRate = sumShareRate.add(doing_shareRate);
                        ++index;
                    }
                    BigDecimal shareRate = new BigDecimal(100);
                    if ("rate".equalsIgnoreCase((String)shareMethod) && sumShareRate.compareTo(shareRate) != 0) {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u7b49\u4e8e100%%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"EntryBeforeShareOpPlugin_8", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips));
                        return false;
                    }
                    if ("amount".equalsIgnoreCase((String)shareMethod) && this.shareAmountValidate(billEntity)) {
                        return false;
                    }
                }
                if (StringUtils.equals((CharSequence)"monthrule", (CharSequence)String.valueOf(shareRule)) || StringUtils.equals((CharSequence)"yearrule", (CharSequence)String.valueOf(shareRule))) {
                    sumShareRate = BigDecimal.ZERO;
                    HashSet<Date> allMonth = new HashSet<Date>(4);
                    int index = 1;
                    for (DynamicObject obj : ruleEntrys) {
                        Date entryMonth = obj.getDate("entrymonth_monthrule");
                        doing_shareRate = obj.getBigDecimal("sharerate_comrule");
                        if (null == entryMonth) {
                            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u6708\u4efd\u201d\u5b57\u6bb5\u3002", (String)"EntryBeforeShareOpPlugin_18", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips, index));
                            return false;
                        }
                        allMonth.add(entryMonth);
                        if ("rate".equalsIgnoreCase((String)shareMethod) && (null == doing_shareRate || doing_shareRate.compareTo(BigDecimal.ZERO) == 0)) {
                            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u586b\u5199\u201c\u5206\u644a\u660e\u7ec6\u201d\u7b2c%2$s\u884c\u201c\u5206\u644a\u6bd4\u4f8b\u201d\u5b57\u6bb5\u3002", (String)"EntryBeforeShareOpPlugin_19", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips, index));
                            return false;
                        }
                        sumShareRate = sumShareRate.add(doing_shareRate);
                        ++index;
                    }
                    if (allMonth.size() != ruleEntrys.size()) {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u644a\u660e\u7ec6\u6708\u4efd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryBeforeShareOpPlugin_10", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips));
                        return false;
                    }
                    BigDecimal shareRate = new BigDecimal(100);
                    if ("rate".equalsIgnoreCase((String)shareMethod) && sumShareRate.compareTo(shareRate) != 0) {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u644a\u6bd4\u4f8b\u5408\u8ba1\u4e0d\u7b49\u4e8e100%%\uff0c\u8bf7\u5148\u4fee\u6539\u5206\u644a\u6bd4\u4f8b\u3002", (String)"EntryBeforeShareOpPlugin_8", (String)"fi-er-opplugin", (Object[])new Object[0]), expenEntryTips));
                        return false;
                    }
                    if ("amount".equalsIgnoreCase((String)shareMethod) && this.shareAmountValidate(billEntity)) {
                        return false;
                    }
                }
                return true;
            }

            private boolean shareAmountValidate(ExtendedDataEntity billEntity) {
                DynamicObjectCollection expEntrys = billEntity.getDataEntity().getDynamicObjectCollection("expenseentryentity");
                String expenseEntryName_CN = ((IDataEntityProperty)billEntity.getDataEntity().getDynamicObjectType().getProperties().get((Object)"expenseentryentity")).getDisplayName().getLocaleValue_zh_CN();
                HashSet<Integer> indexs = new HashSet<Integer>();
                for (int i = 0; i < expEntrys.size(); ++i) {
                    BigDecimal approveamount = ((DynamicObject)expEntrys.get(i)).getBigDecimal("expeapproveamount");
                    BigDecimal sumShareAmount = BigDecimal.ZERO;
                    DynamicObjectCollection ruleEntrys = ((DynamicObject)expEntrys.get(i)).getDynamicObjectCollection("expenseentryentity_rule");
                    for (int j = 0; j < ruleEntrys.size(); ++j) {
                        DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(j);
                        BigDecimal shareAppAmount = ruleEntry.getBigDecimal("shareappamount_comrule");
                        if (shareAppAmount.compareTo(BigDecimal.ZERO) == 0) {
                            String format = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7acb\u9879\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u7b2c%2$s\u884c\u5206\u644a\u91d1\u989d\u6216\u6838\u5b9a\u91d1\u989d\u3002", (String)"EntryBeforeShareOpPlugin_11", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1, j + 1);
                            this.addErrorMessage(billEntity, format);
                            return true;
                        }
                        sumShareAmount = sumShareAmount.add(shareAppAmount);
                    }
                    if (sumShareAmount.compareTo(approveamount) == 0) continue;
                    indexs.add(i + 1);
                }
                if (indexs.size() != 0) {
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7533\u8bf7\u91d1\u989d\u4e0d\u7b49\u4e8e\u5206\u644a\u91d1\u989d\u5408\u8ba1\u3002", (String)"EntryBeforeShareOpPlugin_12", (String)"fi-er-opplugin", (Object[])new Object[0]), indexs));
                    return true;
                }
                return false;
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            ERHandleBeforeShareService.buildAndGetDoneEntrys((DynamicObject)bill, (Boolean)false);
        }
    }
}

