/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.share;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.share.ERHandleBeforeShareService;
import kd.fi.er.business.share.ErVerifyShareRuleHelper;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.amount.control.AmounRangeValidator;
import org.apache.commons.lang3.StringUtils;

public class ExspenseBeforeShareOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ExspenseBeforeShareOpPlugin.class);
    private AddValidatorsEventArgs e1;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.e1 = e;
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    Boolean isShare = bill.getBoolean("isbeforeshare");
                    if (!isShare.booleanValue()) {
                        DynamicObjectCollection shareDetailEntrys;
                        bill.set("sharerule_startdate", null);
                        bill.set("sharerule_enddate", null);
                        bill.set("isshared", (Object)false);
                        DynamicObjectCollection shareEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
                        if (shareEntrys != null && shareEntrys.size() > 0) {
                            shareEntrys.clear();
                        }
                        if ((shareDetailEntrys = bill.getDynamicObjectCollection("sharedetailentry")) != null && shareDetailEntrys.size() > 0) {
                            shareDetailEntrys.clear();
                        }
                        return;
                    }
                    String msg = ErVerifyShareRuleHelper.getVerifyShareRuleMsg((DynamicObject)bill);
                    if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
                    this.addErrorMessage(billEntity, msg);
                    return;
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            ERHandleBeforeShareService.buildAndGetDoneEntrys((DynamicObject)bill, (Boolean)false);
        }
        if (null != this.e1 && null != this.e1.getValidators() && !this.e1.getValidators().isEmpty()) {
            ValidateContext validateContext1 = ((AbstractValidator)this.e1.getValidators().get(0)).getValidateContext();
            ExtendedDataEntitySet set = new ExtendedDataEntitySet();
            set.Parse((DynamicObject[])e.getValidExtDataEntities().stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new), (MainEntityType)e.getDataEntities()[0].getDataEntityType());
            ValidateContext validateContext = new ValidateContext(validateContext1.getValidationMeta(), validateContext1.getEntityNumber(), validateContext1.getOperateKey(), set);
            validateContext.setSubEntityType(validateContext1.getSubEntityType());
            AmounRangeValidator amounRangeValidator = new AmounRangeValidator();
            amounRangeValidator.setValidateContext(validateContext);
            amounRangeValidator.setExtendedDataEntitySet(set);
            amounRangeValidator.initializeConfiguration();
            amounRangeValidator.setDataEntities(e.getValidExtDataEntities().toArray(new ExtendedDataEntity[0]));
            amounRangeValidator.initialize();
            amounRangeValidator.validate();
            ValidateResult res = amounRangeValidator.getValidateResult();
            if (!res.isSuccess()) {
                for (OperateErrorInfo operateErrorInfo : res.getAllErrorInfo()) {
                    this.operationResult.addErrorInfo(operateErrorInfo);
                }
                for (DynamicObject billEntity : e.getDataEntities()) {
                    DynamicObjectCollection shareDetailEntrys = billEntity.getDynamicObjectCollection("sharedetailentry");
                    if (shareDetailEntrys == null || shareDetailEntrys.size() <= 0) continue;
                    shareDetailEntrys.clear();
                }
                e.cancel = true;
            }
        }
    }
}

