/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.share;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.share.befshare.BeforeShareBillGeneratorFactory;
import kd.fi.er.business.utils.ErStdConfig;

public class GenBeforeShareOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("autogenshare");
        list.add("billstatus");
        list.add("isbeforeshare");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        boolean genBeforeShareBill = ErStdConfig.getBoolean((String)"genBeforeShareBill");
        if (!genBeforeShareBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6253\u5f00\u8d39\u7528\u5168\u5c40\u914d\u7f6e\u53c2\u6570\uff1agenBeforeShareBill\u3002", (String)"GenBeforeShareOpPlugin_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys = this.getDataEntities();
                String entityName = this.getEntityKey();
                HashSet<Object> billIds = new HashSet<Object>();
                HashMap<Object, ExtendedDataEntity> billBoxMap = new HashMap<Object, ExtendedDataEntity>();
                List<String> billStatusLst = Arrays.asList("E", "F", "G");
                for (ExtendedDataEntity billEntity : billEntitys) {
                    DynamicObject bill = billEntity.getDataEntity();
                    if (!billStatusLst.contains(bill.getString("billstatus"))) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7\u3001\u7b49\u5f85\u4ed8\u6b3e\u3001\u5df2\u4ed8\u6b3e\u3002", (String)"GenBeforeShareOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!bill.getBoolean("isbeforeshare")) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u5355\u5934\u201c\u5206\u644a\u201d\u5b57\u6bb5\u5fc5\u987b\u4e3a\u201c\u662f\u201d\u3002", (String)"GenBeforeShareOpPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (bill.getBoolean("autogenshare")) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u201c\u81ea\u52a8\u751f\u6210\u5206\u644a\u5355\u201d\u6309\u94ae\u5fc5\u987b\u4e3a\u5173\u95ed\u3002", (String)"GenBeforeShareOpPlugin_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    billIds.add(bill.getPkValue());
                    billBoxMap.put(bill.getPkValue(), billEntity);
                }
                if (billIds.isEmpty()) {
                    return;
                }
                Long shareBillTableId = EntityMetadataCache.loadTableDefine((String)"er_expensesharebill", (String)"er_expensesharebill").getTableId();
                Map loadBillLinkDownNodes = BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityName, (Long[])billIds.toArray(new Long[0]), (boolean)true);
                block1: for (Map.Entry mapEntry : loadBillLinkDownNodes.entrySet()) {
                    Long billId = (Long)mapEntry.getKey();
                    BFRowLinkDownNode downNode = (BFRowLinkDownNode)mapEntry.getValue();
                    Map tNodes = downNode.getTNodes();
                    for (Map.Entry mapEntry2 : tNodes.entrySet()) {
                        Long mainTableId = ((BFRowId)mapEntry2.getKey()).getMainTableId();
                        if (!mainTableId.equals(shareBillTableId)) continue;
                        this.addErrorMessage((ExtendedDataEntity)billBoxMap.get(billId), ResManager.loadKDString((String)"\u5df2\u751f\u6210\u8d39\u7528\u5206\u644a\u5355\uff0c\u4f46\u62a5\u9500\u5355\u7684\u81ea\u52a8\u751f\u6210\u5206\u644a\u5355\u5b57\u6bb5\u6ca1\u6709\u56de\u5199\u3002", (String)"GenBeforeShareOpPlugin_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.handleBeforeShare(e);
    }

    private void handleBeforeShare(EndOperationTransactionArgs e) {
        String entityName = this.billEntityType.getName();
        DynamicObject[] dataEntities = e.getDataEntities();
        Set reimBillIds = Stream.of(dataEntities).map(v -> v.getPkValue()).collect(Collectors.toSet());
        BeforeShareBillGeneratorFactory.get((String)entityName).genBeforeShareBill(reimBillIds);
    }
}

