/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.checking;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang.StringUtils;

public class AllCheckingBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AllCheckingBillSaveOp.class);
    protected static final String[] reverseProps = new String[]{"isreconciliation", "vouchernum"};

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.saveDetailCheckingBill(e);
    }

    private void saveDetailCheckingBill(EndOperationTransactionArgs e) {
        logger.info("save detail checking bill begin");
        DynamicObject[] dataEntities = e.getDataEntities();
        String checkingSelectStr = "id," + StringUtils.join((Object[])reverseProps, (String)",");
        IDataEntityType dataEntityType = dataEntities[0].getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<DynamicObject> checkingBills = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            String checkingFormId = dataEntity.getString("checkingformid");
            String checkingId = dataEntity.getString("checkingid");
            if (StringUtils.isBlank((String)checkingFormId) || StringUtils.isBlank((String)checkingId)) {
                logger.info("save detail checkingbill error.");
                continue;
            }
            logger.info("save detail checkingbill:" + checkingId);
            DynamicObject detailCheckingBill = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(checkingId), (String)checkingFormId, (String)checkingSelectStr);
            for (String reverseProp : reverseProps) {
                if (properties.get((Object)reverseProp) == null) continue;
                detailCheckingBill.set(reverseProp, dataEntity.get(reverseProp));
            }
            checkingBills.add(detailCheckingBill);
        }
        if (!checkingBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])checkingBills.toArray(new DynamicObject[checkingBills.size()]));
        }
        logger.info("save detail checking bill end");
    }
}

