/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.checking;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CheckingBillServiceHelper;
import kd.fi.er.validator.trip.checking.CheckingBillUnAuditValidator;

public class CheckingBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("hasinvoice");
        e.getFieldKeys().add("totaltax");
        e.getFieldKeys().add("checkingbillnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new CheckingBillUnAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List validExtDataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity validExtDataEntity : validExtDataEntities) {
            validExtDataEntity.setValue("hasinvoice", (Object)"0");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.updatAllCheckingBillStatus(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<String> checkingbillnumList = new HashSet<String>(dataEntities.length);
        HashSet<String> checkingBillIds = new HashSet<String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("billstatus", (Object)"A");
            String checkingbillnum = dataEntity.getString("checkingbillnum");
            checkingbillnumList.add(checkingbillnum);
            checkingBillIds.add(String.valueOf(dataEntity.getPkValue()));
        }
        Map checkings = BusinessDataServiceHelper.loadFromCache((String)"er_allcheckingbill", (String)"id,billstatus,checkingid", (QFilter[])new QFilter[]{new QFilter("checkingid", "in", checkingBillIds)});
        if (null != checkings) {
            for (DynamicObject value : checkings.values()) {
                value.set("billstatus", (Object)"A");
            }
            SaveServiceHelper.save((DynamicObject[])checkings.values().toArray(new DynamicObject[0]));
        }
        CheckingBillServiceHelper.updatCheckingHeaderBillStatusList(checkingbillnumList);
    }

    private void updatAllCheckingBillStatus(EndOperationTransactionArgs e) {
        IErDao settlesDao;
        DynamicObject[] settleDyns;
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet checkingBillIdSet = Sets.newHashSetWithExpectedSize((int)32);
        String entryname = "";
        for (DynamicObject dataEntity : dataEntities) {
            Long checkingBillId = (Long)dataEntity.getPkValue();
            checkingBillIdSet.add(checkingBillId);
            entryname = dataEntity.getDataEntityType().getName();
        }
        ORM orm = ORM.create();
        WithDistinctable withDistinctable = WithDistinctable.get();
        DataSet er_invoicesettle_rel1 = orm.queryDataSet("updatAllCheckingBillStatus-er_invoicesettle_rel1", "er_invoicesettle_rel", "invoiceid", new QFilter[]{new QFilter("settleid", "in", (Object)checkingBillIdSet)}, "", -1, (Distinctable)withDistinctable);
        HashSet invoiceidSet = Sets.newHashSetWithExpectedSize((int)32);
        if (null != er_invoicesettle_rel1) {
            while (er_invoicesettle_rel1.hasNext()) {
                Row next = er_invoicesettle_rel1.next();
                Long invoiceid = next.getLong("invoiceid");
                invoiceidSet.add(invoiceid);
            }
        }
        HashSet invoiceids = Sets.newHashSetWithExpectedSize((int)32);
        QFilter qFilter = new QFilter("id", "in", (Object)invoiceidSet);
        qFilter.and(new QFilter("invoicestatus", "in", (Object)new String[]{"1", "5"}));
        DataSet er_invoiceorderbill = orm.queryDataSet("updatAllCheckingBillStatus-er_invoiceorderbill", "er_invoiceorderbill", "id", new QFilter[]{qFilter}, "", -1, (Distinctable)withDistinctable);
        if (null != er_invoiceorderbill) {
            while (er_invoiceorderbill.hasNext()) {
                Row next = er_invoiceorderbill.next();
                Long id = next.getLong("id");
                invoiceids.add(id);
            }
        }
        DataSet er_invoicesettle_rel2 = orm.queryDataSet("updatAllCheckingBillStatus-er_invoicesettle_rel2", "er_invoicesettle_rel", "settleid", new QFilter[]{new QFilter("invoiceid", "in", (Object)invoiceids)}, "", -1, (Distinctable)withDistinctable);
        HashSet settleidSet = Sets.newHashSetWithExpectedSize((int)32);
        if (null != er_invoicesettle_rel2) {
            while (er_invoicesettle_rel2.hasNext()) {
                Row next = er_invoicesettle_rel2.next();
                Long id = next.getLong("settleid");
                settleidSet.add(id);
            }
        }
        if ((settleDyns = (settlesDao = ErDaoFactory.getInstance((String)entryname)).query("id,hasinvoice,totaltax", new QFilter("id", "in", (Object)settleidSet))) != null) {
            for (DynamicObject settleDyn : settleDyns) {
                settleDyn.set("hasinvoice", (Object)"0");
                settleDyn.set("totaltax", (Object)BigDecimal.ZERO);
            }
            if (settleDyns.length > 0) {
                settlesDao.save(settleDyns);
            }
        }
        QFilter qFilter2 = new QFilter("id", "in", (Object)invoiceids);
        QFilter[] qFilters2 = new QFilter[]{qFilter2};
        DeleteServiceHelper.delete((String)"er_invoiceorderbill", (QFilter[])qFilters2);
        QFilter qFilter3 = new QFilter("invoiceid", "in", (Object)invoiceids);
        QFilter[] qFilters3 = new QFilter[]{qFilter3};
        DeleteServiceHelper.delete((String)"er_invoicesettle_rel", (QFilter[])qFilters3);
    }
}

