/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.dailybiz;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.er.business.utils.ErCommonUtils;

public class ErCheckingExpListWriteBackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("ordernum");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String entityNumber = "";
        String operateKey = "";
        MainEntityType billEntityType = this.billEntityType;
        BillEntityType mainType = null;
        if (billEntityType instanceof BillEntityType) {
            mainType = (BillEntityType)billEntityType;
        }
        if (mainType != null) {
            entityNumber = mainType.getName();
        }
        if (!entityNumber.equals("er_checking_exp_list")) {
            return;
        }
        if (!this.compareByGrade(entityNumber, "er_checking_exp_list")) {
            return;
        }
        Map opParameter = this.operateMeta;
        if (opParameter != null && opParameter.get("key") != null) {
            operateKey = (String)opParameter.get("key");
        }
        switch (operateKey) {
            case "audit": {
                DynamicObject[] vehicleBills;
                DynamicObject[] dataEntities = e.getDataEntities();
                ArrayList billNos = Lists.newArrayListWithCapacity((int)dataEntities.length);
                for (DynamicObject dataEntity : dataEntities) {
                    billNos.add(dataEntity.get("billno"));
                }
                DynamicObject[] expCheckingList = BusinessDataServiceHelper.load((String)"er_checking_exp_list", (String)"entryentity,id,entryentity.ordernum,entryentity.isconfirm,entryentity.totalamount,confirmamount", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
                if (expCheckingList == null || expCheckingList.length <= 0) break;
                DynamicObject dynamicObject = expCheckingList[0];
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                HashSet<String> orderNums = new HashSet<String>();
                HashMap<String, String> orderIsConfirmMap = new HashMap<String, String>(entryentity.size());
                BigDecimal confirmAmount = BigDecimal.ZERO;
                for (DynamicObject object : entryentity) {
                    String orderNum = object.get("ordernum") == null ? "" : object.get("ordernum").toString();
                    orderNums.add(orderNum);
                    String isconfirm = object.getString("isconfirm");
                    if (StringUtils.isNotEmpty((String)isconfirm) && isconfirm.equals("true")) {
                        orderIsConfirmMap.put(orderNum, "1");
                        confirmAmount = confirmAmount.add(object.getBigDecimal("totalamount"));
                        continue;
                    }
                    orderIsConfirmMap.put(orderNum, "0");
                }
                DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er_vehiclecheckingbill", (String)"allorderbase,id,ordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", orderNums)});
                HashSet<DynamicObject[]> orderIds = new HashSet<DynamicObject[]>(checkingBills.size());
                HashMap checkingBillIsConfirmMap = new HashMap(orderIsConfirmMap.size());
                for (DynamicObject checkingBill : checkingBills) {
                    DynamicObject[] orderId = ErCommonUtils.getPk((Object)checkingBill.get("allorderbase"));
                    orderIds.add(orderId);
                    checkingBillIsConfirmMap.put(orderId, orderIsConfirmMap.get(checkingBill.getString("ordernum")));
                }
                DynamicObject[] orderBills = BusinessDataServiceHelper.load((String)"er_allorderbill", (String)"deptconfirm,id,ordernum", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds)});
                HashMap<String, Long> orderNumMap = new HashMap<String, Long>(orderBills.length);
                for (DynamicObject orderBill : orderBills) {
                    orderBill.set("deptconfirm", checkingBillIsConfirmMap.get(orderBill.getLong("id")));
                    orderNumMap.put(orderBill.getString("ordernum"), orderBill.getLong("id"));
                }
                for (DynamicObject vehicleBill : vehicleBills = BusinessDataServiceHelper.load((String)"er_vehiclebill", (String)"allorderbase,id,ordernum", (QFilter[])new QFilter[]{new QFilter("ordernum", "in", orderNums)})) {
                    vehicleBill.set("allorderbase_id", orderNumMap.get(vehicleBill.getString("ordernum")));
                }
                dynamicObject.set("confirmamount", (Object)confirmAmount);
                SaveServiceHelper.update((DynamicObject)dynamicObject);
                SaveServiceHelper.update((DynamicObject[])orderBills);
                SaveServiceHelper.update((DynamicObject[])vehicleBills);
            }
        }
    }

    private boolean compareByGrade(String formId, String compareFormId) {
        if (formId.equals(compareFormId)) {
            return true;
        }
        DynamicObject formmeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,parentid.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        if (formmeta == null && formId.endsWith("_mob")) {
            formmeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)"id,parentid.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId.replace("_mob", ""))});
        }
        if (formmeta != null) {
            return this.compareByGrade(formmeta.getString("parentid.number"), compareFormId);
        }
        return false;
    }
}

