/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.order;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class OrderBillDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderBillDeleteOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.deleteOrderBill(e);
    }

    private void deleteOrderBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ORM orm = ORM.create();
        ArrayList<Long> orderBillIds = new ArrayList<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            String formId = dynamicObjectType.getName();
            String orderBillId = dataEntity.getPkValue().toString();
            logger.info("order formId:" + formId + " orderBillId:" + orderBillId);
            QFilter qFilter = new QFilter("orderformid", "=", (Object)formId);
            qFilter = qFilter.and(new QFilter("orderid", "=", (Object)orderBillId));
            DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"er.orderbill", (String)"er_allorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");
            for (DynamicObject orderBill : orderBills) {
                long allOrderId = orderBill.getLong("id");
                logger.info("delete allOrderId:" + allOrderId);
                orderBillIds.add(allOrderId);
            }
        }
        if (orderBillIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)orm.getDataEntityType("er_allorderbill"), (Object[])orderBillIds.toArray());
        }
    }
}

