/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.OperateUtils;
import org.apache.commons.lang.ArrayUtils;

public class ErBillChangeAuditPlugin
extends AbstractOperationServicePlugIn {
    public static final Map<String, String> UPDATE_PROP_MAP;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
        e.getFieldKeys().add("originalentry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InnerValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] data = e.getDataEntities();
        Map typeMaps = Arrays.stream(data).flatMap(bill -> bill.getDynamicObjectCollection("changeentry").stream()).collect(Collectors.groupingBy(row -> row.getString("changebilltype"), Collectors.mapping(row -> row, Collectors.toList())));
        Long applyPayBillTableId = 0L;
        HashMap<Long, Long> indexOfApplyPayAndPublicReim = null;
        for (Map.Entry entry : typeMaps.entrySet()) {
            Map<Long, DynamicObject> entryIDMap = entry.getValue().stream().collect(Collectors.toMap(row -> Long.valueOf(row.getString("changeentryid")), row -> row, (v1, v2) -> v1));
            QFilter qFilter = new QFilter(" accountentry.id", "in", entryIDMap.keySet());
            String srcBillEntityId = entry.getKey();
            Object[] bills = BusinessDataServiceHelper.load((String)srcBillEntityId, (String)this.getQueryFields(srcBillEntityId), (QFilter[])new QFilter[]{qFilter});
            if (ErEntityTypeUtils.isPublicReimburseBill((String)srcBillEntityId)) {
                String applyPayBillEntityId = "er_applypaybill";
                if (applyPayBillTableId == 0L) {
                    applyPayBillTableId = EntityMetadataCache.loadMainTableDefine((String)"er_applypaybill").getTableId();
                }
                List publicReimBurseDownNodes = BFTrackerServiceHelper.loadTargetRowIds((String)"er_publicreimbursebill", (Long[])((Long[])Arrays.stream(bills).map(bill -> bill.getLong("id")).toArray(Long[]::new)), (OperateOption)OperateOption.create());
                indexOfApplyPayAndPublicReim = new HashMap<Long, Long>(publicReimBurseDownNodes.size());
                ArrayList<Long> applyPayBillPks = new ArrayList<Long>(publicReimBurseDownNodes.size());
                for (BFRow publicReimBurseDownNode : publicReimBurseDownNodes) {
                    BFRowId bFRowId = publicReimBurseDownNode.getSId();
                    BFRowId tgtBFRow = publicReimBurseDownNode.getId();
                    if (tgtBFRow.getMainTableId().compareTo(applyPayBillTableId) != 0) continue;
                    applyPayBillPks.add(tgtBFRow.getBillId());
                    indexOfApplyPayAndPublicReim.put(tgtBFRow.getEntryId(), bFRowId.getEntryId());
                }
                if (!applyPayBillPks.isEmpty()) {
                    Object[] applypayBills = BusinessDataServiceHelper.load((String)applyPayBillEntityId, (String)this.getQueryFields(applyPayBillEntityId), (QFilter[])new QFilter[]{new QFilter("id", "in", applyPayBillPks)});
                    bills = (DynamicObject[])ArrayUtils.addAll((Object[])bills, (Object[])applypayBills);
                }
            }
            HashSet<DynamicObject> changeBills = new HashSet<DynamicObject>(bills.length);
            HashSet<DynamicObject> changeBills_tmp = new HashSet<DynamicObject>(bills.length / 2);
            for (DynamicObject dynamicObject : bills) {
                List rows;
                boolean isPublicReimWithApplyPay;
                String entityId = dynamicObject.getDataEntityType().getName();
                DynamicObjectCollection accountEntry = dynamicObject.getDynamicObjectCollection("accountentry");
                boolean bl = isPublicReimWithApplyPay = ErEntityTypeUtils.isApplyPayBill((String)entityId) && indexOfApplyPayAndPublicReim != null;
                if (isPublicReimWithApplyPay) {
                    HashMap<Long, Long> finalIndexOfApplyPayAndPublicReim = indexOfApplyPayAndPublicReim;
                    rows = accountEntry.stream().filter(row -> finalIndexOfApplyPayAndPublicReim.containsKey(row.getLong("id"))).collect(Collectors.toList());
                } else {
                    rows = accountEntry.stream().filter(row -> entryIDMap.containsKey(row.getLong("id"))).collect(Collectors.toList());
                }
                for (DynamicObject row2 : rows) {
                    long entryId = row2.getLong("id");
                    if (isPublicReimWithApplyPay) {
                        entryId = (Long)indexOfApplyPayAndPublicReim.get(entryId);
                    }
                    DynamicObject changeInfo = entryIDMap.get(entryId);
                    DataEntityPropertyCollection properties = row2.getDataEntityType().getProperties();
                    if (changeInfo == null) continue;
                    if (isPublicReimWithApplyPay) {
                        changeBills_tmp.add(dynamicObject);
                    } else {
                        changeBills.add(dynamicObject);
                    }
                    for (Map.Entry<String, String> propEntry : UPDATE_PROP_MAP.entrySet()) {
                        Object value;
                        if (!properties.containsKey((Object)propEntry.getKey())) continue;
                        row2.set(propEntry.getKey(), (value = changeInfo.get(propEntry.getValue())) instanceof DynamicObject ? ErCommonUtils.getPk((Object)value) : value);
                    }
                }
            }
            if (!changeBills.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])changeBills.toArray(new DynamicObject[0]));
            }
            if (changeBills_tmp.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])changeBills_tmp.toArray(new DynamicObject[0]));
        }
    }

    protected String getQueryFields(String billType) {
        String fields = "billno, id,accountentry.id, accountentry.payertype, accountentry.payer,accountentry.payername,accountentry.payeraccount,accountentry.payeraccountname,accountentry.payerbank";
        switch (billType) {
            case "er_publicreimbursebill": 
            case "er_dailyloanbill": 
            case "er_prepaybill": 
            case "er_applypaybill": {
                return fields + ", accountentry.supplier,accountentry.customer, accountentry.casorg";
            }
        }
        return fields;
    }

    static {
        Map<String, String> tamp = Arrays.stream(new String[][]{{"payertype", "changepayertype"}, {"supplier", "changesupplier"}, {"customer", "changecustomer"}, {"casorg", "changecasorg"}, {"payer", "changepayeer"}, {"payeraccount", "changepayeraccount"}, {"payeraccountname", "changepayeraccountname"}, {"payerbank", "changepayerbank"}, {"payername", "changepayername"}}).collect(Collectors.toMap(item -> item[0], item -> item[1]));
        UPDATE_PROP_MAP = Collections.unmodifiableMap(tamp);
    }

    static class InnerValidator
    extends AbstractValidator {
        InnerValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            Map idMap = Arrays.stream(dataEntities).flatMap(dataEntity -> dataEntity.getDataEntity().getDynamicObjectCollection("originalentry").stream()).collect(Collectors.groupingBy(row -> row.getString("sourcebilltype"), Collectors.mapping(row -> Long.valueOf(row.getString("sourcebillid")), Collectors.toSet())));
            QFilter statusFilter = new QFilter("billstatus", "not in", Arrays.asList("E", "F"));
            statusFilter.and("accountentry.buildedamount", "!=", (Object)0);
            HashMap errorBillmap = new HashMap(idMap.size());
            for (Map.Entry entry : idMap.entrySet()) {
                QFilter qFilter = new QFilter("id", "in", entry.getValue());
                qFilter.and(statusFilter);
                DynamicObjectCollection bills = QueryServiceHelper.query((String)entry.getKey(), (String)"billno, id", (QFilter[])new QFilter[]{qFilter});
                errorBillmap.put(entry.getKey(), bills.stream().map(bill -> String.valueOf(bill.getLong("id"))).collect(Collectors.toSet()));
            }
            String template = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002\u7b2c%s1$s\u884c\uff0c\u5355\u636e%2$s\uff0c\u5355\u636e\u7c7b\u578b%3$s\u4e0d\u7b26\u5408\u53d8\u66f4\u8981\u6c42\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"ErBillChangeAuditPlugin_01", (String)"fi-er-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity dataEntity2 : dataEntities) {
                DynamicObjectCollection entry = dataEntity2.getDataEntity().getDynamicObjectCollection("originalentry");
                for (DynamicObject row2 : entry) {
                    Set errBillIdSet = (Set)errorBillmap.get(row2.getString("sourcebilltype"));
                    if (errBillIdSet == null || !errBillIdSet.contains(row2.getString("sourcebillid"))) continue;
                    String errMsg = String.format(template, row2.getString("seq"), row2.getString("sourcebillno"), row2.getString("sourcebilltype"));
                    this.addErrorMessage(dataEntity2, errMsg);
                }
            }
        }
    }
}

