/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.OperateUtils;

public class ErReapymentRefundOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ErReapymentRefundOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Object[] pKids;
            DynamicObjectCollection repaymententry = dataEntity.getDynamicObjectCollection("repaymententry");
            if (repaymententry == null || repaymententry.size() <= 0) continue;
            String srcbilltype = ((DynamicObject)repaymententry.get(0)).getString("srcbilltype");
            OperateOption option = OperateOption.create();
            if ("er_prepaybill".equals(srcbilltype)) {
                OperationResult operationResult;
                List bills;
                pKids = repaymententry.stream().map(v -> v.getLong("sourcebillid")).distinct().toArray(Object[]::new);
                DynamicObject[] prebills = BusinessDataServiceHelper.load((Object[])pKids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"er_prepaybill"));
                if (prebills != null && prebills.length > 0 && (bills = Arrays.stream(Arrays.stream(prebills).filter(v -> !v.getBoolean("ispush")).toArray()).collect(Collectors.toList())) != null && bills.size() > 0) {
                    try (TXHandle h = TX.required();){
                        try {
                            DynamicObject[] dynamicObjectArr = new DynamicObject[bills.size()];
                            int i = 0;
                            for (Object bill : bills) {
                                PublicBillUtil.calPreContractRefundMoney((DynamicObject)((DynamicObject)bill));
                                dynamicObjectArr[i++] = (DynamicObject)bill;
                            }
                            SaveServiceHelper.save((DynamicObject[])dynamicObjectArr);
                        }
                        catch (Throwable exception) {
                            h.markRollback();
                            logger.error(exception);
                        }
                    }
                }
                if ((operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_prepaybill", (Object[])pKids, (OperateOption)option)).isSuccess()) {
                    logger.info("\u9884\u4ed8\u5355\u53cd\u5199\u7acb\u9879\u5355\u6216\u5408\u540c\u5355\u6210\u529f");
                    continue;
                }
                ValidateResultCollection validateResult = operationResult.getValidateResult();
                logger.info("\u9884\u4ed8\u5355\u53cd\u5199\u7acb\u9879\u5355\u6216\u5408\u540c\u5355\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                continue;
            }
            if (!"er_dailyloanbill".equals(srcbilltype)) continue;
            pKids = repaymententry.stream().map(v -> v.getLong("sourcebillid")).distinct().toArray(Object[]::new);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_dailyloanbill", (Object[])pKids, (OperateOption)option);
            if (operationResult.isSuccess()) {
                logger.info("\u501f\u6b3e\u5355\u53cd\u5199\u7acb\u9879\u5355\u6210\u529f");
                continue;
            }
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            logger.info("\u501f\u6b3e\u5355\u53cd\u5199\u7acb\u9879\u5355\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
        }
    }
}

