/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SyncReqToYZJAuditOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(SyncReqToYZJAuditOp.class);
    public static final String SCHEDULE_ENTITY_ID = "sch_schedule";

    public static DynamicObject getScheduleDO() {
        return BusinessDataServiceHelper.loadSingle((String)SCHEDULE_ENTITY_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)"3IGQX4KNN==G")});
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("multitravelers");
        fieldKeys.add("travelers");
        fieldKeys.add("changetime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject scheduleDO = SyncReqToYZJAuditOp.getScheduleDO();
        if (scheduleDO == null) {
            return;
        }
        boolean isenable = scheduleDO.getBoolean("status");
        if (!isenable) {
            return;
        }
        for (DynamicObject bill : e.getDataEntities()) {
            String billno = bill.getString("billno");
            ArrayList<DynamicObject> deleteDyns = SyncReqToYZJAuditOp.buildDeleteDyn(billno, new Date());
            SaveServiceHelper.save((DynamicObject[])deleteDyns.toArray(new DynamicObject[0]));
            ArrayList<DynamicObject> tripentryDyns = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> formInfoDyns = new ArrayList<DynamicObject>();
            HashMap allformInfos = new HashMap();
            DynamicObjectCollection tripentries = bill.getDynamicObjectCollection("tripentry");
            long[] longs = ORM.create().genLongIds("er_syntripentry", tripentries.size());
            int i = 0;
            Date createDate = new Date();
            for (DynamicObject tripentry : tripentries) {
                Object startdate = tripentry.get("startdate");
                Timestamp enddate = tripentry.get("enddate") instanceof Date ? new Timestamp(((Date)tripentry.get("enddate")).getTime()) : (Timestamp)tripentry.get("enddate");
                DynamicObject to = (DynamicObject)tripentry.get("to");
                DynamicObject tripentrydyn = BusinessDataServiceHelper.newDynamicObject((String)"er_syntripentry");
                tripentrydyn.set("startdate", startdate);
                if (enddate.getHours() == 0 && enddate.getMinutes() == 0 && enddate.getSeconds() == 0 && enddate.getNanos() == 0) {
                    tripentrydyn.set("enddate", (Object)new Timestamp(enddate.getTime() + 86400000L - 1L));
                } else {
                    tripentrydyn.set("enddate", (Object)enddate);
                }
                tripentrydyn.set("cityname", to.get("name"));
                tripentrydyn.set("citynumber", to.get("number"));
                tripentrydyn.set("createtime", (Object)createDate);
                Long tripentryid = longs[i];
                ++i;
                tripentrydyn.set("id", (Object)tripentryid);
                tripentryDyns.add(tripentrydyn);
                DynamicObjectCollection travelers = tripentry.getDynamicObjectCollection("travelers");
                HashMap<String, DynamicObject> currformInfos = new HashMap<String, DynamicObject>();
                for (DynamicObject traveler : travelers) {
                    DynamicObject user = (DynamicObject)traveler.get("fbasedataid");
                    String useropenid = user.getString("useropenid");
                    String userNumber = user.getString("number");
                    if (StringUtils.isBlank((CharSequence)userNumber)) {
                        userNumber = useropenid;
                    }
                    if (StringUtils.isBlank((CharSequence)useropenid)) {
                        useropenid = userNumber;
                    }
                    if (allformInfos.containsKey(useropenid)) {
                        DynamicObject formInfo2 = (DynamicObject)allformInfos.get(useropenid);
                        formInfo2.set("entryid", (Object)(formInfo2.get("entryid").toString() + "," + tripentryid));
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{formInfo2});
                        currformInfos.put(useropenid, formInfo2);
                        continue;
                    }
                    formInfoDyns.add(SyncReqToYZJAuditOp.buildsyntripreqDyn(billno, billno + "-" + userNumber, useropenid, "PASS", "no", createDate, createDate, tripentryid.toString()));
                }
                currformInfos.putAll(formInfoDyns.stream().collect(Collectors.toMap(formInfo -> formInfo.get("travelerid").toString(), formInfo -> formInfo, (v1, v2) -> v2)));
                allformInfos.putAll(currformInfos);
            }
            SaveServiceHelper.save((DynamicObject[])tripentryDyns.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])formInfoDyns.toArray(new DynamicObject[0]));
        }
    }

    protected static ArrayList<DynamicObject> buildDeleteDyn(String billno, Date date) {
        ArrayList<DynamicObject> deletes = new ArrayList<DynamicObject>();
        DynamicObjectCollection CreateFormInfosByBillno = QueryServiceHelper.query((String)"er_syntripreq", (String)"", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno), new QFilter("optype", "=", (Object)"PASS")});
        if (CreateFormInfosByBillno.size() != 0) {
            Optional<DynamicObject> optional = CreateFormInfosByBillno.stream().max(Comparator.comparing(r -> r.getDate("createtime")));
            Date maxDate = optional.map(dynamicObject -> new Date(dynamicObject.getDate("createtime").getTime())).orElse(null);
            List latestCreateFormInfosByBillno = CreateFormInfosByBillno.stream().filter(v -> v.getDate("createtime").compareTo(maxDate) == 0).collect(Collectors.toList());
            for (DynamicObject dynamicObject2 : latestCreateFormInfosByBillno) {
                String datano = (String)dynamicObject2.get("datano");
                String travelerid = (String)dynamicObject2.get("travelerid");
                String entryid = (String)dynamicObject2.get("entryid");
                deletes.add(SyncReqToYZJAuditOp.buildsyntripreqDyn(billno, datano, travelerid, "DELETE", "no", date, date, entryid));
            }
        }
        return deletes;
    }

    protected static DynamicObject buildsyntripreqDyn(String tripreqbillno, String datano, String openId, String optype, String synstate, Date createtime, Date modifytime, String tripentryid) {
        DynamicObject formInfo = BusinessDataServiceHelper.newDynamicObject((String)"er_syntripreq");
        formInfo.set("billno", (Object)tripreqbillno);
        formInfo.set("datano", (Object)datano);
        formInfo.set("travelerid", (Object)openId);
        formInfo.set("optype", (Object)optype);
        formInfo.set("synstate", (Object)synstate);
        formInfo.set("createtime", (Object)createtime);
        formInfo.set("modifytime", (Object)modifytime);
        formInfo.set("entryid", (Object)tripentryid);
        return formInfo;
    }
}

