/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.validator.TripReimburseLoanValidator;

public class TripReimburseApproveSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List registerList = e.getFieldKeys();
        registerList.add("entryentity");
        registerList.add("entryappamount");
        registerList.add("clearloanentry");
        registerList.add("loanclearamount");
        registerList.add("accountentry");
        registerList.add("receiveamount");
        registerList.add("tripentry");
        registerList.add("entryentity");
        registerList.add("settlementtype");
        registerList.add("encashamount");
        registerList.add("notpayamount");
        registerList.add("loanchecktype");
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("formid");
        fieldKeys.add("amount");
        fieldKeys.add("rstartdate");
        fieldKeys.add("rfirstenddate");
        fieldKeys.add("renddate");
        fieldKeys.add("rvehicle");
        fieldKeys.add("rfrom");
        fieldKeys.add("rto");
        fieldKeys.add("encashamount");
        fieldKeys.add("notpayamount");
        fieldKeys.add("payamount");
        fieldKeys.add("company");
        fieldKeys.add("costcompany");
        fieldKeys.add("costdept");
        fieldKeys.add("applier");
        fieldKeys.add("applierpositionstr");
        fieldKeys.add("overdesc");
        fieldKeys.add("approveamount");
        fieldKeys.add("balanceamount");
        fieldKeys.add("isloan");
        fieldKeys.add("tripamount");
        fieldKeys.add("usedamount");
        fieldKeys.add("createtime");
        fieldKeys.add("tel");
        fieldKeys.add("creator");
        fieldKeys.add("triporiamount");
        fieldKeys.add("modifytime");
        fieldKeys.add("comment");
        fieldKeys.add("currency");
        fieldKeys.add("monthsettleamount");
        fieldKeys.add("rfirstto");
        fieldKeys.add("loanchecktype");
        fieldKeys.add("from");
        fieldKeys.add("vehicle");
        fieldKeys.add("to");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("tripentryarea");
        fieldKeys.add("tripexpenseitem");
        fieldKeys.add("tripcurrency");
        fieldKeys.add("tripapporiamount");
        fieldKeys.add("expenseitem");
        fieldKeys.add("entryamount");
        fieldKeys.add("entrycurrency");
        fieldKeys.add("orientryamount");
        fieldKeys.add("daycount");
        fieldKeys.add("caldaycount");
        fieldKeys.add("notaxamount");
        fieldKeys.add("taxrate");
        fieldKeys.add("taxamount");
        fieldKeys.add("exchangerate");
        fieldKeys.add("orientryappamount");
        fieldKeys.add("entryappamount");
        fieldKeys.add("deductibletax");
        fieldKeys.add("accsourceentryid");
        fieldKeys.add("accloanamount");
        fieldKeys.add("receiveamount");
        fieldKeys.add("lastaccloanamount");
        fieldKeys.add("accexchangerate");
        fieldKeys.add("payeraccount");
        fieldKeys.add("accountcurrency");
        fieldKeys.add("paymode");
        fieldKeys.add("payerbank");
        fieldKeys.add("accreimamount");
        fieldKeys.add("payer");
        fieldKeys.add("reqaccountentryid");
        fieldKeys.add("loancurrency");
        fieldKeys.add("iscurrency");
        fieldKeys.add("loanclearamount");
        fieldKeys.add("loanclearoriamount");
        fieldKeys.add("settlementtype");
        fieldKeys.add("isreimburse");
        fieldKeys.add("expcommitcomnum");
        fieldKeys.add("orderformid");
        fieldKeys.add("snaploanclearoriamount");
        fieldKeys.add("snaploanclearamount");
        fieldKeys.add("checkloanamount");
        fieldKeys.add("loanoribalanceamount");
        fieldKeys.add("ordernum");
        fieldKeys.add("serialno_entry");
        fieldKeys.add("tripexchangerate");
        fieldKeys.add("tripcurrency");
        fieldKeys.add("deductibletax");
        fieldKeys.add("taxamount_invoice");
        fieldKeys.add("invoiceitementry");
        fieldKeys.add("itementryid");
        fieldKeys.add("invoiceheadentryid");
        fieldKeys.add("invoiceandexpense");
        fieldKeys.add("expenseentryid");
        fieldKeys.add("invoiceentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    BigDecimal encashamount;
                    DynamicObjectCollection tripEntrys = entity.getDataEntity().getDynamicObjectCollection("tripentry");
                    BigDecimal totalEntryAppAmount = BigDecimal.ZERO;
                    for (DynamicObject tripEntity : tripEntrys) {
                        DynamicObjectCollection entrys = tripEntity.getDynamicObjectCollection("entryentity");
                        for (DynamicObject entry : entrys) {
                            BigDecimal entryAppAmount = entry.getBigDecimal("entryappamount");
                            totalEntryAppAmount = totalEntryAppAmount.add(entryAppAmount);
                        }
                    }
                    BigDecimal totalLoanClearAmount = BigDecimal.ZERO;
                    DynamicObjectCollection clearLoanEntry = entity.getDataEntity().getDynamicObjectCollection("clearloanentry");
                    if (clearLoanEntry != null) {
                        totalLoanClearAmount = clearLoanEntry.stream().map(row -> row.getBigDecimal("loanclearamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElseGet(() -> BigDecimal.ZERO);
                    }
                    BigDecimal totalReceiveAmount = BigDecimal.ZERO;
                    DynamicObjectCollection accountEntry = entity.getDataEntity().getDynamicObjectCollection("accountentry");
                    if (accountEntry != null) {
                        totalReceiveAmount = accountEntry.stream().map(row -> row.getBigDecimal("receiveamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElseGet(() -> BigDecimal.ZERO);
                    }
                    if (totalReceiveAmount.compareTo(encashamount = entity.getDataEntity().getBigDecimal("encashamount")) != 0) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01\u4e4b\u548c\u5e94\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"TripReimburseApproveSubmitOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    BigDecimal notpayamount = entity.getDataEntity().getBigDecimal("notpayamount");
                    if (notpayamount.compareTo(encashamount) != 0) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u672a\u4ed8\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"TripReimburseApproveSubmitOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    List results = InvoiceUtils.checkOffsetTaxAmount((DynamicObject)entity.getDataEntity(), (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.TripReimburse);
                    for (String result : results) {
                        this.addErrorMessage(entity, result);
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new TripReimburseLoanValidator());
    }
}

