/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.ReverseBillServiceHelper;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.field.invoiceentry.InvoiceEntryfields;
import kd.fi.er.opplugin.web.TripBaseSubmitOp;
import kd.fi.er.opplugin.web.TripChangedValidator;
import kd.fi.er.validator.LoanAndAccountCurrencyUniqueValidator;
import kd.fi.er.validator.ReverseBillSubmitValidator;
import kd.fi.er.validator.SameCurrencySubmitValidator;
import kd.fi.er.validator.TripDateControlValidator;
import kd.fi.er.validator.TripNoReimburseOrderValidator;
import kd.fi.er.validator.TripReimburseLoanValidator;
import kd.fi.er.validator.TripReimburseSubmitValidator;
import kd.fi.er.validator.TripStandardValidator;
import kd.fi.er.validator.invoicecloud.checkInvoice.TripReimSubmitCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseSubmitOp
extends TripBaseSubmitOp {
    private static final Log logger = LogFactory.getLog(TripReimburseSubmitOp.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillid");
        fieldKeys.add("formid");
        fieldKeys.add("amount");
        fieldKeys.add("rstartdate");
        fieldKeys.add("rfirstenddate");
        fieldKeys.add("renddate");
        fieldKeys.add("rvehicle");
        fieldKeys.add("rfrom");
        fieldKeys.add("rto");
        fieldKeys.add("encashamount");
        fieldKeys.add("notpayamount");
        fieldKeys.add("payamount");
        fieldKeys.add("company");
        fieldKeys.add("costcompany");
        fieldKeys.add("costdept");
        fieldKeys.add("applier");
        fieldKeys.add("applierpositionstr");
        fieldKeys.add("overdesc");
        fieldKeys.add("approveamount");
        fieldKeys.add("balanceamount");
        fieldKeys.add("isloan");
        fieldKeys.add("tripamount");
        fieldKeys.add("usedamount");
        fieldKeys.add("createtime");
        fieldKeys.add("tel");
        fieldKeys.add("creator");
        fieldKeys.add("triporiamount");
        fieldKeys.add("modifytime");
        fieldKeys.add("comment");
        fieldKeys.add("currency");
        fieldKeys.add("monthsettleamount");
        fieldKeys.add("rfirstto");
        fieldKeys.add("loanchecktype");
        fieldKeys.add("trippartneraccstdtype");
        fieldKeys.add("noinvoice");
        fieldKeys.add("from");
        fieldKeys.add("vehicle");
        fieldKeys.add("to");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("tripentryarea");
        fieldKeys.add("tripexpenseitem");
        fieldKeys.add("tripcurrency");
        fieldKeys.add("traveler");
        fieldKeys.add("tripapporiamount");
        fieldKeys.add("expenseitem");
        fieldKeys.add("entryamount");
        fieldKeys.add("entrycurrency");
        fieldKeys.add("orientryamount");
        fieldKeys.add("daycount");
        fieldKeys.add("caldaycount");
        fieldKeys.add("notaxamount");
        fieldKeys.add("taxrate");
        fieldKeys.add("taxamount");
        fieldKeys.add("exchangerate");
        fieldKeys.add("orientryappamount");
        fieldKeys.add("entryappamount");
        fieldKeys.add("expenseseatgrade");
        fieldKeys.add("tripstandardamount");
        fieldKeys.add("invoiceno_entry");
        fieldKeys.add("useroutstdctrl");
        fieldKeys.add("accsourceentryid");
        fieldKeys.add("accloanamount");
        fieldKeys.add("receiveamount");
        fieldKeys.add("lastaccloanamount");
        fieldKeys.add("accexchangerate");
        fieldKeys.add("payeraccount");
        fieldKeys.add("accountcurrency");
        fieldKeys.add("paymode");
        fieldKeys.add("payerbank");
        fieldKeys.add("accreimamount");
        fieldKeys.add("payer");
        fieldKeys.add("oriaccnotpayamount");
        fieldKeys.add("accnotpayamount");
        fieldKeys.add("reqaccountentryid");
        fieldKeys.add("loancurrency");
        fieldKeys.add("iscurrency");
        fieldKeys.add("loanclearamount");
        fieldKeys.add("loanclearoriamount");
        fieldKeys.add("settlementtype");
        fieldKeys.add("isreimburse");
        fieldKeys.add("expcommitcomnum");
        fieldKeys.add("orderformid");
        fieldKeys.add("snaploanclearoriamount");
        fieldKeys.add("snaploanclearamount");
        fieldKeys.add("checkloanamount");
        fieldKeys.add("loanoribalanceamount");
        fieldKeys.add("ordernum");
        fieldKeys.add("serialno_entry");
        fieldKeys.add("mulseatgrade");
        fieldKeys.add("invoiceno_entry");
        fieldKeys.add("tripexchangerate");
        fieldKeys.add("tripcurrency");
        fieldKeys.add("tripentry");
        fieldKeys.add("tripentrystatus");
        fieldKeys.add("tripentrysourceid");
        fieldKeys.add("travelers");
        fieldKeys.add("istravelers");
        fieldKeys.add("itemfrom");
        fieldKeys.add("excludeamount");
        fieldKeys.add("itementryid");
        fieldKeys.add("invoiceitemtaxamout");
        fieldKeys.add("ismapexpense");
        fieldKeys.add("mapexpenseinfo");
        fieldKeys.add("invoicefrom");
        fieldKeys.add("personalinvoice");
        fieldKeys.add("passverifybuyername");
        fieldKeys.add("passverifybuyertaxno");
        fieldKeys.add("ie_validatest");
        fieldKeys.add("automapinvoice");
        fieldKeys.add("invoiceandexpense");
        fieldKeys.add("invoiceandexpense.expenseentryid");
        fieldKeys.add("invoiceandexpense.invoiceentryid");
        fieldKeys.add("tripentry");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("company");
        fieldKeys.add("costcompany");
        fieldKeys.add("costdept");
        fieldKeys.add("billno");
        fieldKeys.add("entryentity");
        fieldKeys.add("orderformid");
        fieldKeys.add("ordernum");
        fieldKeys.add("provider");
        fieldKeys.add("clearloanentry");
        fieldKeys.add("loanclearoriamount");
        fieldKeys.add("payername");
        fieldKeys.add("writeoffapply");
        fieldKeys.add("applybillno");
        fieldKeys.add("billkind");
        fieldKeys.add("trip2from");
        fieldKeys.add("trip2to");
        fieldKeys.add("trip2startdate");
        fieldKeys.add("trip2enddate");
        fieldKeys.add("needsuppleinvoice");
        fieldKeys.addAll(InvoiceEntryfields.getInstance().getAllFiedName());
        fieldKeys.add("isover");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("rowseq");
        fieldKeys.add("entryentity");
        fieldKeys.add("accountentry");
        fieldKeys.add("accountentry.payerbank");
        fieldKeys.add("tripvehicleamount");
        fieldKeys.add("tripvehicleover");
        fieldKeys.add("tripaccommodationamt");
        fieldKeys.add("tripaccommodationover");
        fieldKeys.add("tripallowanceamount");
        fieldKeys.add("tripallowanceover");
        fieldKeys.add("tripotheramount");
        fieldKeys.add("stdexpquotetype");
        fieldKeys.add("stdentrycurrency");
        fieldKeys.add("stdexchangerate");
        fieldKeys.add("billkind");
        fieldKeys.add("tripentryarea");
        fieldKeys.add("triparea");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TripReimburseSubmitValidator());
        e.addValidator((AbstractValidator)new TripReimburseLoanValidator());
        e.addValidator((AbstractValidator)new TripStandardValidator());
        e.addValidator((AbstractValidator)new ReverseBillSubmitValidator());
        e.addValidator((AbstractValidator)new SameCurrencySubmitValidator());
        e.addValidator((AbstractValidator)new TripReimSubmitCheckInvoiceValidator());
        e.addValidator((AbstractValidator)new TripNoReimburseOrderValidator());
        e.addValidator((AbstractValidator)new TripDateControlValidator());
        e.addValidator((AbstractValidator)new LoanAndAccountCurrencyUniqueValidator());
        e.addValidator((AbstractValidator)new TripChangedValidator());
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        String clearloanentry_of_tripreimbill = ErStdConfig.get((String)"clearloanentry_of_tripreimbill");
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            CalculateTripSumUtil.calculate((DynamicObject)dynamicObject, null);
            DynamicObjectCollection clearLoanEntry = dynamicObject.getDynamicObjectCollection("clearloanentry");
            Iterator clearLoanIterator = clearLoanEntry.iterator();
            while (clearLoanIterator.hasNext()) {
                DynamicObject clearLoan = (DynamicObject)clearLoanIterator.next();
                BigDecimal clearLoanAmount = clearLoan.getBigDecimal("loanclearoriamount");
                boolean isTripReqBill = "er_tripreqbill".equalsIgnoreCase(clearLoan.getString("srcbilltype"));
                if (null != clearLoanAmount && clearLoanAmount.compareTo(BigDecimal.ZERO) != 0 || "1".equals(clearloanentry_of_tripreimbill) && isTripReqBill) continue;
                clearLoanIterator.remove();
            }
            DynamicObjectCollection accpEntrys = dynamicObject.getDynamicObjectCollection("accountentry");
            for (DynamicObject accEntry : accpEntrys) {
                BigDecimal accEntryAmount = accEntry.getBigDecimal("receiveamount");
                if (null != accEntryAmount && accEntryAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                accEntry.set("oriaccnotpayamount", (Object)BigDecimal.ZERO);
                accEntry.set("accnotpayamount", (Object)BigDecimal.ZERO);
            }
            DynamicObjectCollection tripEntrys = dynamicObject.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripEntry : tripEntrys) {
                DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
                Iterator entrysIterator = entrys.iterator();
                int index = 1;
                while (entrysIterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)entrysIterator.next();
                    BigDecimal entryAmount = entry.getBigDecimal("entryamount");
                    String entryInvoiceNo = entry.getString("invoiceno_entry");
                    if (!ErStdConfig.getBoolean((String)"orientryamount_of_tripreimbill") && StringUtils.isBlank((CharSequence)entryInvoiceNo) && (null == entryAmount || entryAmount.compareTo(BigDecimal.ZERO) == 0)) {
                        entrysIterator.remove();
                        continue;
                    }
                    entry.set("seq", (Object)index);
                    entry.set("rowseq", (Object)index++);
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)((String)this.operateMeta.get("key")), (CharSequence)"submit")) continue;
            InvoiceUtils.checkTaxAmount((DynamicObject)dynamicObject, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.TripReimburse);
        }
        this.beforeSaveSubmitOperation(dataEntities);
    }

    private void beforeSaveSubmitOperation(DynamicObject[] dataEntities) {
        for (DynamicObject dynamicObject : dataEntities) {
            dynamicObject.set("notpayamount", dynamicObject.get("encashamount"));
            DynamicObjectCollection clearloanentrys = dynamicObject.getDynamicObjectCollection("clearloanentry");
            if (clearloanentrys.size() <= 0) continue;
            BigDecimal checkloanamount = BigDecimal.ZERO;
            for (DynamicObject entry : clearloanentrys) {
                BigDecimal loanclearoriamount = entry.getBigDecimal("loanclearamount");
                checkloanamount = checkloanamount.add(loanclearoriamount);
                entry.set("snaploanclearoriamount", (Object)entry.getBigDecimal("loanclearoriamount"));
                entry.set("snaploanclearamount", (Object)entry.getBigDecimal("loanclearamount"));
            }
            dynamicObject.set("checkloanamount", (Object)checkloanamount);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Arrays.stream(e.getDataEntities()).forEach(tripReimburseBill -> ReverseBillServiceHelper.writeTripreqbillFromTripreimbursebill((DynamicObject)tripReimburseBill, (boolean)false, (boolean)true, (boolean)false, (boolean)false));
    }
}

