/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripReqChangeUtil;
import kd.fi.er.business.utils.BillRelateUtils;
import kd.fi.er.business.utils.TripReqBillUtil;
import kd.fi.er.validator.PayeraccountSubmitValidator;
import kd.fi.er.validator.SameCurrencySubmitValidator;
import kd.fi.er.validator.TripReqSubmitValidator;
import kd.fi.er.validator.TripRequestDateValidator;
import org.apache.commons.lang3.StringUtils;

public class TripRequestSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(TripRequestSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("formid");
        fieldKeys.add("isloan");
        fieldKeys.add("notpayamount");
        fieldKeys.add("loanamount");
        fieldKeys.add("plandays");
        fieldKeys.add("createtime");
        fieldKeys.add("balanceamount");
        fieldKeys.add("payamount");
        fieldKeys.add("usedamount");
        fieldKeys.add("modifytime");
        fieldKeys.add("approveamount");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("tel");
        fieldKeys.add("repaymentdate");
        fieldKeys.add("triptype");
        fieldKeys.add("creator");
        fieldKeys.add("company");
        fieldKeys.add("costdept");
        fieldKeys.add("costcompany");
        fieldKeys.add("rfirstto");
        fieldKeys.add("rfirstenddate");
        fieldKeys.add("encashamount");
        fieldKeys.add("origin");
        fieldKeys.add("applier");
        fieldKeys.add("bizdate");
        fieldKeys.add("from");
        fieldKeys.add("vehicle");
        fieldKeys.add("to");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("rstartdate");
        fieldKeys.add("renddate");
        fieldKeys.add("rvehicle");
        fieldKeys.add("rfrom");
        fieldKeys.add("rto");
        fieldKeys.add("amount");
        fieldKeys.add("tripcurrency");
        fieldKeys.add("triporiamount");
        fieldKeys.add("tripexchangerate");
        fieldKeys.add("tripexpenseitem");
        fieldKeys.add("tripamount");
        fieldKeys.add("triporiaccappamount");
        fieldKeys.add("tripaccappamount");
        fieldKeys.add("tripentrystatus");
        fieldKeys.add("entryentity");
        fieldKeys.add("tripentry");
        fieldKeys.add("accountentry");
        fieldKeys.add("receiveamount");
        fieldKeys.add("entryrepaydate");
        fieldKeys.add("orireceiveamount");
        fieldKeys.add("accexchangerate");
        fieldKeys.add("payerbank");
        fieldKeys.add("payeraccount02");
        fieldKeys.add("accountcurrency");
        fieldKeys.add("payer");
        fieldKeys.add("paymode");
        fieldKeys.add("payerbank");
        fieldKeys.add("payeraccount");
        fieldKeys.add("payerdeptid");
        fieldKeys.add("payercompid");
        fieldKeys.add("istravelers");
        fieldKeys.add("travelers");
        fieldKeys.add("ischange");
        fieldKeys.add("changetime");
        fieldKeys.add("srcentryid");
        fieldKeys.add("accountentry.payertype");
        fieldKeys.add("accountentry.casorg");
        fieldKeys.add("accountentry.payer");
        fieldKeys.add("accountentry.payeraccount");
        for (Map.Entry entry : TripReqChangeUtil.getTriphistoryMappingresult().entrySet()) {
            fieldKeys.add(entry.getKey());
            fieldKeys.add(entry.getValue());
        }
        fieldKeys.add("multitravelers");
        fieldKeys.add("projectower");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new TripReqSubmitValidator());
        validators.add(new SameCurrencySubmitValidator());
        validators.add(new TripRequestDateValidator());
        validators.add(new PayeraccountSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects;
        super.beginOperationTransaction(e);
        for (DynamicObject dynamicObject : dynamicObjects = e.getDataEntities()) {
            CommonServiceHelper.executeRedundancyField((DynamicObject)dynamicObject);
            if (dynamicObject.getBoolean("isloan")) {
                CommonServiceHelper.handlePayerDeptAndCompInfo((DynamicObject)dynamicObject);
            }
            DynamicObjectCollection tripenrtys = dynamicObject.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripenrty : tripenrtys) {
                DynamicObject traveler = dynamicObject.getDynamicObject("applier");
                if (!StringUtils.equals((CharSequence)dynamicObject.getString("origin"), (CharSequence)"3") || traveler == null) continue;
                DynamicObjectCollection travelerSet = BillRelateUtils.generateMultiPropValue((DynamicObject)tripenrty, null, (String)"travelers", (DynamicObject)traveler);
                DynamicObjectCollection travelers = tripenrty.getDynamicObjectCollection("travelers");
                if (travelers != null && travelers.size() != 0) continue;
                tripenrty.set("travelers", (Object)travelerSet);
            }
        }
    }

    @Deprecated
    protected void compareAndDeleteHistoryTripWithOld(Map<Object, DynamicObject> currentTripInfo, DynamicObjectCollection oldTripHistoryColl) {
    }

    @Deprecated
    protected Map<String, String> getPropertyMapping() {
        return new HashMap<String, String>();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dos;
        for (DynamicObject dynamicObject : dos = e.getDataEntities()) {
            DynamicObjectCollection tripenrtys = dynamicObject.getDynamicObjectCollection("tripentry");
            TripReqBillUtil.setMultiTravelers((DynamicObject)dynamicObject, (DynamicObjectCollection)tripenrtys);
            TripReqBillUtil.synProjectOwer((DynamicObject)dynamicObject, (DynamicObjectCollection)tripenrtys);
        }
    }
}

