/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.ErReimburseAmountValidator;

public class ErReimCtlAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new ErReimburseAmountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        RequestContext requestContext = RequestContext.get();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("auditStatus", (Object)"1");
            dataEntity.set("auditor", (Object)requestContext.getUserId());
            dataEntity.set("modifier", (Object)requestContext.getUserId());
            dataEntity.set("modifytime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.wbSrcBill(e);
    }

    private void wbSrcBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>();
        for (DynamicObject bill : dataEntities) {
            Long srcId;
            String srcType = (String)bill.get("wbsrcbilltype");
            if (!"er_reimctl_modify".equals(srcType) || (srcId = (Long)bill.get("wbsrcbillid")) == null || srcId == 0L) continue;
            srcBillIds.add(srcId);
        }
        if (srcBillIds.size() > 0) {
            QFilter qf = new QFilter("id", "in", srcBillIds);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id,auditStatus", (QFilter[])new QFilter[]{qf});
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject applyBill = bills[i];
                applyBill.set("auditStatus", (Object)Character.valueOf('2'));
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }
}

