/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.validator.ErReimburseAmountValidator;

public class ErReimCtlSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ErReimCtlSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("totalamount");
        keys.add("wbsrcbilltype");
        keys.add("wbsrcbillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new ErReimburseAmountValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        RequestContext requestContext = RequestContext.get();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("modifier", (Object)requestContext.getUserId());
            dataEntity.set("modifytime", (Object)new Date());
            BigDecimal totalAmount = dataEntity.getBigDecimal("totalamount");
            if (totalAmount.compareTo(BigDecimal.ZERO) > 0) continue;
            BigDecimal totalYearAmount = BigDecimal.ZERO;
            String monthPrefix = "month";
            for (int i = 1; i <= 12; ++i) {
                BigDecimal monthAmount = dataEntity.getBigDecimal(monthPrefix + "" + i);
                totalYearAmount = totalYearAmount.add(monthAmount);
            }
            dataEntity.set("totalamount", (Object)totalYearAmount);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.writeBackState(e);
    }

    private void writeBackState(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>();
        for (DynamicObject bill : dataEntities) {
            Long srcId;
            String srcType = (String)bill.get("wbsrcbilltype");
            if (!"er_reimctlapplybill".equals(srcType) || (srcId = (Long)bill.get("wbsrcbillid")) == null || srcId == 0L) continue;
            srcBillIds.add(srcId);
        }
        if (srcBillIds.size() > 0) {
            log.info("\u53cd\u5199\u989d\u5ea6\u7533\u8bf7\u5355\u201c\u5173\u95ed\u201d\u72b6\u6001,\u66f4\u65b0\u7684\u6570\u636e:" + SerializationUtils.toJsonString(srcBillIds));
            QFilter qf = new QFilter("id", "in", srcBillIds);
            DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"er_reimctlapplybill", (String)"id,billstatus", (QFilter[])new QFilter[]{qf});
            for (int i = 0; i < applyBills.length; ++i) {
                DynamicObject applyBill = applyBills[i];
                applyBill.set("billstatus", (Object)Character.valueOf('I'));
            }
            SaveServiceHelper.save((DynamicObject[])applyBills);
        }
    }
}

