/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.deptrelation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.utils.Er;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReimCtlDeptRelationExcelImport
extends BatchImportPlugin {
    public ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ArrayList afterFilterRowDatas = Lists.newArrayListWithExpectedSize((int)rowdatas.size());
        if (this.UnifiedVerification(rowdatas, logger)) {
            for (ImportBillData rowData : rowdatas) {
                afterFilterRowDatas.add(rowData);
                JSONArray deptRelationEntryRows = rowData.getData().getJSONArray("deptrelation");
                for (int rowIndex = 0; rowIndex < deptRelationEntryRows.size(); ++rowIndex) {
                    DynamicObject deptStructureDO;
                    ImportBasedata dept;
                    DynamicObject reimDeptStructureDO;
                    JSONObject row = deptRelationEntryRows.getJSONObject(rowIndex);
                    ImportBasedata reimDept = (ImportBasedata)row.getObject("reimdept", ImportBasedata.class);
                    if (StringUtils.isNotBlank((CharSequence)reimDept.getNumber()) && (reimDeptStructureDO = this.getOrgStructureDO("reimdept", reimDept.getNumber())) != null) {
                        JSONObject reimDeptStructure = new JSONObject();
                        reimDeptStructure.put("importprop", (Object)"id");
                        reimDeptStructure.put("id", reimDeptStructureDO.getPkValue());
                        row.put("reimdeptstruct", (Object)reimDeptStructure);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(dept = (ImportBasedata)row.getObject("dept", ImportBasedata.class)).getNumber()) || (deptStructureDO = this.getOrgStructureDO("dept", dept.getNumber())) == null) continue;
                    JSONObject reimDeptStructure = new JSONObject();
                    reimDeptStructure.put("importprop", (Object)"id");
                    reimDeptStructure.put("id", deptStructureDO.getPkValue());
                    row.put("deptstruct", (Object)reimDeptStructure);
                }
            }
        }
        return super.save((List)afterFilterRowDatas, logger);
    }

    protected boolean isForceBatch() {
        return true;
    }

    private boolean UnifiedVerification(List<ImportBillData> rowdatas, ImportLogger logger) {
        return this.validateAllExpItem(rowdatas, logger) && this.validateAllOrg(rowdatas, logger);
    }

    private boolean validateAllOrg(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<Integer, Tuple<String, String>> importIndexAndReimdeptNum = new HashMap<Integer, Tuple<String, String>>(rowdatas.size());
        HashSet<String> orgNumbers = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONArray deptrelation = (JSONArray)rowdata.getData().get((Object)"deptrelation");
            for (int i = 0; i < deptrelation.size(); ++i) {
                JSONObject deptrelationRow = (JSONObject)deptrelation.get(i);
                int rowIndex = deptrelationRow.getInteger("rowNum");
                String deptNum = deptrelationRow.getJSONObject("dept").getString("number");
                if (deptNum == null || deptNum.isEmpty()) {
                    return this.assertFalse(logger, rowIndex, ResManager.loadKDString((String)"\u90e8\u95e8\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ReimCtlDeptRelationExcelImport_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                String reimdeptNum = deptrelationRow.getJSONObject("reimdept").getString("number");
                if (reimdeptNum == null || reimdeptNum.isEmpty()) {
                    return this.assertFalse(logger, rowIndex, ResManager.loadKDString((String)"\u989d\u5ea6\u5f52\u53e3\u90e8\u95e8\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ReimCtlDeptRelationExcelImport_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                orgNumbers.add(deptNum);
                orgNumbers.add(reimdeptNum);
                importIndexAndReimdeptNum.put(rowIndex, (Tuple<String, String>)new Tuple((Object)reimdeptNum, (Object)deptNum));
            }
        }
        DynamicObjectCollection bos_orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumbers)});
        if (bos_orgs.size() < orgNumbers.size()) {
            orgNumbers.removeIf(e -> bos_orgs.stream().anyMatch(org -> org.getString("number").equals(e)));
            return this.unmatchOrg(logger, orgNumbers, importIndexAndReimdeptNum, ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%1$s\u672a\u627e\u5230\u76f8\u5e94\u7684\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ReimCtlDeptRelationExcelImport_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        Map<Long, String> orgNumAndPk = bos_orgs.stream().collect(Collectors.toMap(org -> org.getLong("id"), org -> org.getString("number"), (a, b) -> a));
        List unfreezeOrg = BusinessDataServiceHelper.loadFromCache((String)"bos_adminorg_structure", (QFilter[])new QFilter[]{new QFilter("org", "in", orgNumAndPk.keySet()), new QFilter("view.number", "=", (Object)"01"), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)}).values().stream().map(org -> ErCommonUtils.getPk((Object)org.getDynamicObject("org"))).collect(Collectors.toList());
        orgNumAndPk.entrySet().removeIf(next -> unfreezeOrg.contains(next.getKey()));
        return this.unmatchOrg(logger, orgNumAndPk.values(), importIndexAndReimdeptNum, ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s\u7684\u7ec4\u7ec7\u5df2\u5c01\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ReimCtlDeptRelationExcelImport_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
    }

    private boolean unmatchOrg(ImportLogger logger, Collection<String> compareSet, Map<Integer, Tuple<String, String>> comparedMap, String msg) {
        Set<Map.Entry<Integer, Tuple<String, String>>> entries = comparedMap.entrySet();
        for (Map.Entry<Integer, Tuple<String, String>> entry : entries) {
            Integer index = entry.getKey();
            Tuple<String, String> reimdeptAnddept = comparedMap.get(index);
            Collection intersection = CollectionUtils.intersection(compareSet, new HashSet<String>(Arrays.asList((String)reimdeptAnddept.item1, (String)reimdeptAnddept.item2)));
            if (intersection.isEmpty()) continue;
            return this.assertFalse(logger, index, String.format(msg, intersection.toString()));
        }
        return true;
    }

    private boolean validateAllExpItem(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<String, Integer> importExpNumAndIndex = new HashMap<String, Integer>();
        for (ImportBillData rowData : rowdatas) {
            String[] expItemNumbers;
            int index = rowData.getStartIndex();
            Map expItemMap = (Map)rowData.getData().get((Object)"expenseitems");
            for (String expItemNumber : expItemNumbers = ((String)expItemMap.get("number")).split(",")) {
                importExpNumAndIndex.put(expItemNumber, index);
            }
        }
        DynamicObjectCollection exsitExpItemDOs = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id,number, enable, isreimburseamountctl", (QFilter[])new QFilter[]{new QFilter("number", "in", importExpNumAndIndex.keySet())});
        HashMap<Long, String> exsitExpPkAndNum = new HashMap<Long, String>();
        for (Object expItem : exsitExpItemDOs) {
            String expNumber = expItem.getString("number");
            Long expPk = expItem.getLong("id");
            if (!expItem.getBoolean("enable")) {
                return this.assertFalse(logger, (Integer)importExpNumAndIndex.get(expNumber), ResManager.loadKDString((String)"\u8be5\u8d39\u7528\u9879\u76ee\u672a\u542f\u7528", (String)"ReimCtlDeptRelationExcelImport_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)expItem.getString("isreimburseamountctl"), (CharSequence)"2")) {
                return this.assertFalse(logger, (Integer)importExpNumAndIndex.get(expNumber), ResManager.loadKDString((String)"\u8be5\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u91c7\u7528\u90e8\u95e8\u989d\u5ea6\u63a7\u5236\u3002", (String)"ReimCtlDeptRelationExcelImport_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            exsitExpPkAndNum.put(expPk, expNumber);
        }
        Collection disjunctionColl = CollectionUtils.disjunction(importExpNumAndIndex.keySet(), exsitExpPkAndNum.values());
        for (String disjunction : disjunctionColl) {
            this.assertFalse(logger, (Integer)importExpNumAndIndex.get(disjunction), ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u68c0\u7d22\u5230\u8d39\u7528\u9879\u76ee\u7f16\u7801\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"ReimCtlDeptRelationExcelImport_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        String sql = String.format("select fbasedataid from t_er_reimctl_expenseitems where fbasedataid in (%s)", Er.join(exsitExpPkAndNum.keySet(), (String)","));
        Map usedItemNumbers = (Map)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, rs -> {
            HashMap<Integer, HashSet<String>> usedItemNumber = new HashMap<Integer, HashSet<String>>(exsitExpPkAndNum.size());
            while (rs.next()) {
                Long fbasedataid = rs.getLong("fbasedataid");
                String expNumber = (String)exsitExpPkAndNum.get(fbasedataid);
                if (expNumber == null) continue;
                Integer index = (Integer)importExpNumAndIndex.get(expNumber);
                HashSet<String> expItems = (HashSet<String>)usedItemNumber.get(index);
                if (expItems == null || expItems.isEmpty()) {
                    expItems = new HashSet<String>();
                }
                expItems.add(expNumber);
                usedItemNumber.put(index, expItems);
            }
            return usedItemNumber;
        });
        if (!usedItemNumbers.isEmpty()) {
            List rowIndexs = usedItemNumbers.keySet().stream().sorted().collect(Collectors.toList());
            return this.assertFalse(logger, (Integer)rowIndexs.get(0), String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee%s\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReimCtlDeptRelationExcelImport_9", (String)"fi-er-opplugin", (Object[])new Object[0]), usedItemNumbers.get(rowIndexs.get(0))));
        }
        return true;
    }

    private boolean assertFalse(ImportLogger logger, int rowIndex, String msg) {
        logger.log(Integer.valueOf(rowIndex), msg);
        logger.fail();
        return false;
    }

    public String getDefaultKeyFields() {
        return "expenseitem";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        return Lists.newArrayList((Object[])new ComboItem[]{new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ReimCtlDeptRelationExcelImport_4", (String)"fi-er-opplugin", (Object[])new Object[0])), "expenseitem")});
    }

    private DynamicObject getOrgStructureDO(String orgFieldName, String orgNumber) {
        OrgProp reimDeptProp = (OrgProp)((EntityType)MetadataServiceHelper.getDataEntityType((String)"er_reimctldept_relation").getAllEntities().get("deptrelation")).getProperty(orgFieldName);
        String orgViewId = reimDeptProp.getOrgViewScheme().getId();
        DynamicObject orgDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{orgNumber})});
        if (orgDO == null) {
            return null;
        }
        DynamicObject bosOrgStructureDO = OrgServiceHelper.getBosOrgStructureDO((Long)((Long)orgDO.getPkValue()), (Long)Long.valueOf(orgViewId));
        return bosOrgStructureDO;
    }

    public static class ImportBasedata {
        private String importprop;
        private String number;

        public ImportBasedata(String importprop, String number) {
            this.importprop = importprop;
            this.number = number;
        }

        public String getImportprop() {
            return this.importprop;
        }

        public void setImportprop(String importprop) {
            this.importprop = importprop;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public JSONObject toJSONObject() {
            return JSON.parseObject((String)JSON.toJSONString((Object)this));
        }
    }
}

