/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.tips;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReimburseTipsOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("tipsinfoentry");
        e.getFieldKeys().add("tipsinfoentry.billtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
                if (extendedDataEntities == null) {
                    return;
                }
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    DynamicObjectCollection tipsInfo = dataEntity.getDynamicObjectCollection("tipsinfoentry");
                    if (tipsInfo != null && !tipsInfo.isEmpty()) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u63d0\u793a\u4fe1\u606f\u201d\u7b2c1\u884c:\u201c\u5355\u636e\u201d\u201c\u63d0\u793a\u5185\u5bb9\u201d\u3002", (String)"ReimburseTipsOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length != 0) {
            QFilter formIdFilter;
            DynamicObject[] usersFirstLoginInfo;
            Set billTypes = Arrays.stream(dataEntities).flatMap(bill -> bill.getDynamicObjectCollection("tipsinfoentry").stream()).map(r -> r.getString("billtype")).collect(Collectors.toSet());
            if (billTypes.contains("er_tripreimbill_grid")) {
                billTypes.add("er_tripreim_grid_mb");
            }
            if ((usersFirstLoginInfo = BusinessDataServiceHelper.load((String)"bos_devp_firstlogin", (String)"isfirstlogin", (QFilter[])new QFilter[]{formIdFilter = new QFilter("pageid", "in", billTypes)})) != null && usersFirstLoginInfo.length != 0) {
                ((Stream)Arrays.stream(usersFirstLoginInfo).parallel()).forEach(user -> user.set("isfirstlogin", (Object)"0"));
                SaveServiceHelper.save((DynamicObject[])usersFirstLoginInfo);
            }
        }
    }
}

