/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;

public abstract class AbstractPayByHeadSubmitValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("accountentry");
        preparePropertys.add("accountcurrency");
        preparePropertys.add("ispaybyhead");
        return preparePropertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!this.isNeedValidate(bill)) continue;
            String payByHeadPropName = bill.getDynamicObjectType().getProperty("ispaybyhead").getDisplayName().getLocaleValue();
            DynamicObjectCollection acctEntryCollection = bill.getDynamicObjectCollection("accountentry");
            if (acctEntryCollection == null || acctEntryCollection.size() <= 0) continue;
            if (acctEntryCollection.size() > 1) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u53ea\u5141\u8bb8\u5f55\u5165\u4e00\u6761\u6536\u6b3e\u4fe1\u606f\u3002", (String)"AbstractPayByHeadSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), payByHeadPropName));
                continue;
            }
            String[] errorArray = new String[1];
            Object acctCurrencyId = ((DynamicObject)acctEntryCollection.get(0)).getDynamicObject("accountcurrency").getPkValue();
            if (this.isSameCurrencyOfExpEntry(bill, errorArray, acctCurrencyId, payByHeadPropName) || PayeeServiceHelper.storageLimits((DynamicObject)bill)) continue;
            this.addErrorMessage(dataEntity, errorArray[0]);
        }
    }

    protected abstract boolean isSameCurrencyOfExpEntry(DynamicObject var1, String[] var2, Object var3, String var4);

    protected boolean isNeedValidate(DynamicObject bill) {
        return bill.getBoolean("ispaybyhead");
    }
}

