/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang.StringUtils;

public class ErBillCheckExpItemCanUseValidator
extends AbstractValidator {
    private final Map<Long, List<Long>> enableExpItemMap = new HashMap<Long, List<Long>>();

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billhead_lk");
        preparePropertys.add("billhead_lk_stableid");
        preparePropertys.add("billhead_lk_sbillid");
        preparePropertys.add("expenseentryentity_lk");
        preparePropertys.add("expenseentryentity_lk_stableid");
        preparePropertys.add("expenseentryentity_lk_sbillid");
        preparePropertys.add("specialbill");
        preparePropertys.add("detailtype");
        preparePropertys.add("reimbursetype");
        preparePropertys.add("bizitem");
        return preparePropertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject company = bill.getDynamicObject("company");
            if (company == null) continue;
            if (!this.isNeedToCheck(bill)) {
                return;
            }
            DynamicObjectCollection expColl = bill.getDynamicObjectCollection("expenseentryentity");
            for (int rowIndex = 0; rowIndex < expColl.size(); ++rowIndex) {
                DynamicObject expenseItem;
                Long expenseItemId;
                DynamicObject row = (DynamicObject)expColl.get(rowIndex);
                Long costDept = ErCommonUtils.getPk((Object)row.getDynamicObject("entrycostdept"));
                List relExpenseItems = null;
                relExpenseItems = this.enableExpItemMap.get(costDept);
                if (relExpenseItems == null) {
                    relExpenseItems = ExpenseItemServiceHelper.getAllEnableExpItemNoLeaf((DynamicObject)row);
                    this.enableExpItemMap.put(costDept, relExpenseItems);
                }
                if (null == (expenseItemId = ErCommonUtils.getPk((Object)(expenseItem = row.getDynamicObject("expenseitem")))) || relExpenseItems.contains(expenseItemId)) continue;
                String errorMessage2 = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8d39\u7528\u9879\u76ee\u6ca1\u6709\u5173\u8054\u6b64\u5355\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"ErBillCheckExpItemCanUseValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(errorMessage2, rowIndex + 1));
            }
        }
    }

    protected boolean isNeedToCheck(DynamicObject bill) {
        String formId = bill.getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isApplyPayBill((String)formId)) {
            return false;
        }
        String needCheck = ErStdConfig.get((String)"datacheck.expitem_can_use");
        if (StringUtils.isNotBlank((String)needCheck)) {
            return Boolean.parseBoolean(needCheck);
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)formId) || ErEntityTypeUtils.isDailyApplyBill((String)formId) || ErEntityTypeUtils.isDailyReimburseBill((String)formId) || ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
            if (bill.getDataEntityType().getProperties().containsKey((Object)"detailtype") && !StringUtils.equalsIgnoreCase((String)bill.getString("detailtype"), (String)"biztype_other") && ErEntityTypeUtils.isPublicReimburseBill((String)formId)) {
                return false;
            }
            return !bill.getDataEntityType().getProperties().containsKey((Object)"specialbill") || !StringUtils.isNotBlank((String)bill.getString("specialbill"));
        }
        return false;
    }
}

