/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class IncludeEmployeeSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(IncludeEmployeeSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkIncludeEmployee(dataEntity);
        }
    }

    private void checkIncludeEmployee(ExtendedDataEntity dataEntity) {
        Object pkValue = dataEntity.getValue("tripstandard");
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        List userIds = dynamicObjectCollection.stream().filter(v -> v.getDynamicObject("user") != null).map(v -> (Long)v.getDynamicObject("user").getPkValue()).collect(Collectors.toList());
        Set<Long> userIdSet = userIds.stream().collect(Collectors.toSet());
        if (userIds.size() != userIdSet.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u6dfb\u52a0\u76f8\u540c\u7684\u4eba\u5458\u3002", (String)"IncludeEmployeeSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return;
        }
        String sourcebilltype = dataEntity.getValue("sourcebilltype").toString();
        QFilter qFilter = new QFilter("entryentity.user", "in", userIdSet);
        DynamicObject[] includeEmployee = BusinessDataServiceHelper.load((String)"er_include_employee", (String)"id,tripstandard,entryentity.user_id", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("tripstandard", "!=", pkValue)).and(new QFilter("sourcebilltype", "=", (Object)sourcebilltype))});
        if (includeEmployee == null || includeEmployee.length == 0) {
            return;
        }
        String entityId = dataEntity.getValue("sourcebilltype").toString();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.equals((CharSequence)entityId, (CharSequence)"er_tripstandard_vehicle")) {
            sb.append("standardtype,cabinstr,");
        }
        sb.append("reimburselevel,createorg,entryentity.tripstandardtype,entryentity.triparea,entryentity.currency");
        String selectClumn = sb.toString();
        DynamicObject[] currentStandard = BusinessDataServiceHelper.load((String)entityId, (String)selectClumn, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
        DynamicObjectCollection reimLevelColl = currentStandard[0].getDynamicObjectCollection("reimburselevel");
        Set<Long> reimLvlIdSet = reimLevelColl.stream().map(reimLevel -> (Long)reimLevel.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        boolean isStdVhc = StringUtils.equals((CharSequence)entityId, (CharSequence)"er_tripstandard_vehicle");
        String standardType = "";
        if (isStdVhc) {
            standardType = currentStandard[0].getString("standardtype");
        }
        StdIncludeEmployeeModel currentUserInfo = new StdIncludeEmployeeModel();
        currentUserInfo.setCreateOrgId(ErCommonUtils.getPk((Object)currentStandard[0].getDynamicObject("createorg")));
        currentUserInfo.setReimLvlIdSets(reimLvlIdSet);
        currentUserInfo.setUserSet(userIdSet);
        currentUserInfo.setStandardType(standardType);
        if (!isStdVhc) {
            currentUserInfo.setReimStdSets(this.buildStdInfo(currentStandard[0].getDynamicObjectCollection("entryentity")));
        } else {
            currentUserInfo.setReimStdSets(Sets.newHashSet((Object[])new String[]{currentStandard[0].getString("cabinstr")}));
        }
        ArrayList existUserInfoList = Lists.newArrayListWithExpectedSize((int)includeEmployee.length);
        log.info("sourcebilltype : " + sourcebilltype + ", selectClumn : " + selectClumn);
        for (int i = 0; i < includeEmployee.length; ++i) {
            log.info("id : " + includeEmployee[i].get("tripstandard"));
            DynamicObject[] existStandard = BusinessDataServiceHelper.load((String)sourcebilltype, (String)selectClumn, (QFilter[])new QFilter[]{new QFilter("id", "=", includeEmployee[i].get("tripstandard"))});
            if (existStandard == null || existStandard.length < 1) continue;
            DynamicObjectCollection existReimLevelColl = existStandard[0].getDynamicObjectCollection("reimburselevel");
            Set<Long> existReimLvlIdSet = existReimLevelColl.stream().map(reimLevel -> (Long)reimLevel.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            DynamicObjectCollection userColl = includeEmployee[i].getDynamicObjectCollection("entryentity");
            Set<Long> existUserIdSet = userColl.stream().map(user -> user.getLong("user_id")).collect(Collectors.toSet());
            StdIncludeEmployeeModel existUserInfo = new StdIncludeEmployeeModel();
            String exitStdType = "";
            if (isStdVhc) {
                exitStdType = existStandard[0].getString("standardtype");
                existUserInfo.setReimStdSets(Sets.newHashSet((Object[])new String[]{existStandard[0].getString("cabinstr")}));
            } else {
                existUserInfo.setReimStdSets(this.buildStdInfo(existStandard[0].getDynamicObjectCollection("entryentity")));
            }
            existUserInfo.setCreateOrgId(ErCommonUtils.getPk((Object)existStandard[0].getDynamicObject("createorg")));
            existUserInfo.setReimLvlIdSets(existReimLvlIdSet);
            existUserInfo.setUserSet(existUserIdSet);
            existUserInfo.setStandardType(exitStdType);
            existUserInfoList.add(existUserInfo);
        }
        for (StdIncludeEmployeeModel stdIncludeEmployeeModel : existUserInfoList) {
            boolean isSame;
            if (!stdIncludeEmployeeModel.getCreateOrgId().equals(currentUserInfo.getCreateOrgId())) continue;
            HashSet tempSet = Sets.newHashSet(stdIncludeEmployeeModel.getUserSet());
            tempSet.addAll(currentUserInfo.getUserSet());
            if (tempSet.size() == stdIncludeEmployeeModel.getUserSet().size() + currentUserInfo.getUserSet().size() || isStdVhc && !StringUtils.equals((CharSequence)stdIncludeEmployeeModel.getStandardType(), (CharSequence)currentUserInfo.getStandardType()) || !(isSame = stdIncludeEmployeeModel.getReimStdSets().stream().anyMatch(v -> currentUserInfo.getReimStdSets().contains(v)))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u6dfb\u52a0\u76f8\u540c\u7684\u4eba\u5458\u3002", (String)"IncludeEmployeeSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private Set<String> buildStdInfo(DynamicObjectCollection standardInfoColl) {
        HashSet standardInfoSet = Sets.newHashSetWithExpectedSize((int)standardInfoColl.size());
        StringBuilder stdInfo = new StringBuilder();
        for (DynamicObject standardInfo : standardInfoColl) {
            Long tripStdTypeId = ErCommonUtils.getPk((Object)standardInfo.get("tripstandardtype"));
            stdInfo.append(tripStdTypeId);
            stdInfo.append(":");
            Long tripAreaId = ErCommonUtils.getPk((Object)standardInfo.get("triparea"));
            stdInfo.append(tripAreaId);
            stdInfo.append(":");
            Long tripCurId = ErCommonUtils.getPk((Object)standardInfo.get("currency"));
            stdInfo.append(tripCurId);
            standardInfoSet.add(stdInfo.toString());
            stdInfo.delete(0, stdInfo.length());
        }
        return standardInfoSet;
    }

    public static class StdIncludeEmployeeModel {
        private Long createOrgId;
        private String standardType;
        private Set<Long> userSet;
        private Set<Long> reimLvlIdSets;
        private Set<String> reimStdSets;

        public Long getCreateOrgId() {
            return this.createOrgId;
        }

        public void setCreateOrgId(Long createOrgId) {
            this.createOrgId = createOrgId;
        }

        public String getStandardType() {
            return this.standardType;
        }

        public void setStandardType(String standardType) {
            this.standardType = standardType;
        }

        public Set<Long> getUserSet() {
            return this.userSet;
        }

        public void setUserSet(Set<Long> userSet) {
            this.userSet = userSet;
        }

        public Set<Long> getReimLvlIdSets() {
            return this.reimLvlIdSets;
        }

        public void setReimLvlIdSets(Set<Long> reimLvlIdSets) {
            this.reimLvlIdSets = reimLvlIdSets;
        }

        public Set<String> getReimStdSets() {
            return this.reimStdSets;
        }

        public void setReimStdSets(Set<String> reimStdSets) {
            this.reimStdSets = reimStdSets;
        }
    }
}

