/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.PayerTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class LoanBillSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(LoanBillSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            DynamicObjectCollection contracts;
            boolean frameworkcontract;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection expenseEntrys = dynamicObject.getDynamicObjectCollection("expenseentryentity");
            if (expenseEntrys == null || expenseEntrys.isEmpty()) continue;
            BigDecimal approveAmount = expenseEntrys.stream().map(v -> v.getBigDecimal("expeapprovecurramount")).reduce((v1, v2) -> v1.add((BigDecimal)v2)).orElse(BigDecimal.ZERO);
            DynamicObjectCollection accountEntrys = dynamicObject.getDynamicObjectCollection("accountentry");
            BigDecimal sumAmount = BigDecimal.ZERO;
            boolean isHavePayee = false;
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            int index = 1;
            for (DynamicObject accountEntry : accountEntrys) {
                DynamicObject payerbank;
                sumAmount = sumAmount.add(accountEntry.getBigDecimal("receiveamount"));
                String payerType = accountEntry.getString("payertype");
                if (PayerTypeEnum.PAYER.getType().equals(payerType)) {
                    isHavePayee = true;
                }
                if ((payerbank = accountEntry.getDynamicObject("payerbank")) != null && !payerbank.getBoolean("enable")) {
                    indexs.add(index);
                }
                ++index;
            }
            logger.info("approveAmount:" + approveAmount + ",sumAmount:" + sumAmount);
            if (sumAmount.compareTo(approveAmount) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7684\u6536\u6b3e\u91d1\u989d\u4e4b\u548c\u4e0d\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"LoanBillSubmitValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!indexs.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u4e2d\u7684\u5f00\u6237\u94f6\u884c\u5df2\u88ab\u7981\u7528\u3002", (String)"LoanBillSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[]{((Object)indexs).toString().replaceAll("[^\\d|,]", "").replaceAll(",", "\uff0c")}));
                continue;
            }
            if (isHavePayee || ErCommonUtils.storageLimits((Long)ErCommonUtils.getPk((Object)((DynamicObject)dynamicObject.get("company")).getPkValue()), (String)this.getEntityKey())) {
                Set itemSet = dynamicObject.getDynamicObjectCollection("expenseentryentity").stream().map(row -> ErCommonUtils.getPk((Object)row.getDynamicObject("expenseitem"))).filter(pk -> pk != null).collect(Collectors.toSet());
                String msg = LoanBalanceServiceHelper.getloanBillMsg((DynamicObject)dynamicObject.getDynamicObject("company"), (DynamicObject)dynamicObject.getDynamicObject("applier"), itemSet);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.addFatalErrorMessage(dataEntity, msg);
                    continue;
                }
            }
            if (!ErEntityTypeUtils.isPrePayBill((String)dynamicObject.getDataEntityType().getName())) continue;
            String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)((DynamicObject)dynamicObject.get("company")).getPkValue()), (String)"er010");
            BigDecimal currAmountTO = BigDecimal.ZERO;
            BigDecimal expenseAmountTO = BigDecimal.ZERO;
            if (expenseEntrys != null && !expenseEntrys.isEmpty()) {
                currAmountTO = expenseEntrys.stream().map(e -> (BigDecimal)e.get("currexpenseamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                expenseAmountTO = expenseEntrys.stream().map(e -> (BigDecimal)e.get("expenseamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            }
            if ((frameworkcontract = dynamicObject.getBoolean("frameworkcontract")) || (contracts = dynamicObject.getDynamicObjectCollection("contractentry")).size() <= 0) continue;
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType) && contracts != null && contracts.size() > 0) {
                Set concurrency = contracts.stream().map(v -> (Long)((DynamicObject)v.get("contractexpcurrency")).getPkValue()).collect(Collectors.toSet());
                Set expcurrency = expenseEntrys.stream().map(p -> (Long)((DynamicObject)p.get("entrycurrency")).getPkValue()).collect(Collectors.toSet());
                HashSet totalIds = Sets.newHashSet();
                totalIds.addAll(concurrency);
                totalIds.addAll(expcurrency);
                if (totalIds.size() > 1) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6240\u6709\u9884\u4ed8\u660e\u7ec6\u5206\u5f55\u5e01\u79cd\u3001\u5173\u8054\u5408\u540c\u5206\u5f55\u5e01\u79cd\u5fc5\u987b\u4e00\u81f4\u3002", (String)"RelationContractAmountValidator_11", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
            }
            BigDecimal currCanAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("concurrcanloanamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal canloanAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("contractcanloanamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
                if (PublicBillUtil.compareWithTail((BigDecimal)expenseAmountTO, (BigDecimal)canloanAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u4fe1\u606f\u7533\u8bf7\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u4e0d\u80fd\u8d85\u51fa\u5173\u8054\u5408\u540c\u53ef\u9884\u4ed8\u91d1\u989d\u539f\u5e01\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (PublicBillUtil.compareWithTail((BigDecimal)currAmountTO, (BigDecimal)currCanAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u4ed8\u4fe1\u606f\u7533\u8bf7\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1\u4e0d\u80fd\u8d85\u51fa\u5173\u8054\u5408\u540c\u53ef\u9884\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }
}

