/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReqApproveSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObjectCollection accountEntrys;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            boolean isLoan = dynamicObject.getBoolean("isloan");
            if (!isLoan) continue;
            Date repaydate = dynamicObject.getDate("repaymentdate");
            Date bizdate = dynamicObject.getDate("bizdate");
            if (repaydate == null || repaydate.before(bizdate)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u6b3e\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u7533\u8bf7\u65e5\u671f\u3002", (String)"TripReqApproveSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if ((accountEntrys = dynamicObject.getDynamicObjectCollection("accountentry")) == null || accountEntrys.size() == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"TripReqApproveSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            BigDecimal totalReceiveAmount = BigDecimal.ZERO;
            for (DynamicObject accountEntry : accountEntrys) {
                BigDecimal receiveAmount = accountEntry.getBigDecimal("receiveamount");
                totalReceiveAmount = totalReceiveAmount.add(receiveAmount);
                if (accountEntry.get("payer") != null) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"TripReqApproveSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            BigDecimal encashamount = dynamicObject.getBigDecimal("encashamount");
            if (totalReceiveAmount.compareTo(encashamount) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01\u4e4b\u548c\u5e94\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"TripReqApproveSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            Set itemSet = dynamicObject.getDynamicObjectCollection("tripentry").stream().map(row -> ErCommonUtils.getPk((Object)row.getDynamicObject("tripexpenseitem"))).filter(pk -> pk != null).collect(Collectors.toSet());
            String msg = LoanBalanceServiceHelper.getloanBillMsg((DynamicObject)dynamicObject.getDynamicObject("company"), (DynamicObject)dynamicObject.getDynamicObject("applier"), itemSet);
            if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }
}

