/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.tripstd.service.IErTripStdControlService;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.TripStandardCheckUtil;
import kd.fi.er.common.ControlMethodEnum;
import org.apache.commons.lang.StringUtils;

public class TripStandardValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(TripStandardValidator.class);
    private static String EXPENSE_ITEM_ACCOMMODATION = "5";
    private static String EXPENSE_ITEM_SUBSIDY = "1";
    private static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};
    protected static final String TRIPEXP_ATTRIBUTE = "attribute";
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long companyId = Long.valueOf(((DynamicObject)dataEntity.getValue("company")).getPkValue().toString());
            Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.enableTripStandCtrl", "enableTripStandCtrl", new Object[]{dynamicObject}, new Class[]{DynamicObject.class});
            Boolean isControl = SystemParamterUtil.isEnableTripStandard((Long)companyId);
            if (!"-1".equals(invokeExtService)) {
                isControl = (Boolean)invokeExtService;
            }
            List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_TRIPSTANDARDCTL, (Object[])new Object[]{dynamicObject});
            for (Object item : result) {
                if (!Boolean.FALSE.equals(item)) continue;
                isControl = (Boolean)item;
            }
            if (!isControl.booleanValue()) continue;
            String tripStandardControlMethod = SystemParamterUtil.getTripStandardControlLevel((long)companyId).getValue();
            String vehicleConType = SystemParamterUtil.getVehicleStdControlLevel((long)companyId).getValue();
            logger.info(String.format("\u662f\u5426\u5f00\u542f\u63a7\u5236\uff1a%s,\u4ea4\u901a\u5de5\u5177\u63a7\u5236\u65b9\u5f0f\uff1a%s,\u5dee\u65c5\u6807\u51c6\u63a7\u5236\u65b9\u5f0f\uff1a%s", isControl, vehicleConType, tripStandardControlMethod));
            DynamicObjectCollection tripEntrys = dynamicObject.getDynamicObjectCollection("tripentry");
            this.tripStdValidator(dataEntity, tripStandardControlMethod, vehicleConType, tripEntrys);
        }
    }

    private void tripStdValidator(ExtendedDataEntity dataEntity, String tripStandardControlMethod, String vehicleConType, DynamicObjectCollection tripEntrys) {
        for (int tripIndex = 0; tripIndex < tripEntrys.size(); ++tripIndex) {
            DynamicObjectCollection entrys = ((DynamicObject)tripEntrys.get(tripIndex)).getDynamicObjectCollection("entryentity");
            for (int detailIndex = 0; detailIndex < entrys.size(); ++detailIndex) {
                BigDecimal amount;
                DynamicObject entry = (DynamicObject)entrys.get(detailIndex);
                DynamicObject expenseItem = entry.getDynamicObject("expenseitem");
                if (expenseItem == null) continue;
                String attribute = expenseItem.getString(TRIPEXP_ATTRIBUTE);
                String noticeCoordinate = DailyBillServiceHelper.isNewTripReim((DynamicObject)dataEntity.getDataEntity()) ? ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6", (String)"TripStandardValidator_13", (String)"fi-er-opplugin", (Object[])new Object[]{detailIndex + 1}) : ResManager.loadKDString((String)"\u7b2c%s\u6bb5\u884c\u7a0b\uff0c\u7b2c%d\u884c\u660e\u7ec6", (String)"TripStandardValidator_20", (String)"fi-er-opplugin", (Object[])new Object[]{tripIndex + 1, detailIndex + 1});
                if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute) && !ControlMethodEnum.NO_CONTROL.getValue().equals(vehicleConType) && (amount = entry.getBigDecimal("orientryamount")) != null && amount.compareTo(BigDecimal.ZERO) != 0 && !this.checkMustInputIsFill(dataEntity, entry, noticeCoordinate, "mulseatgrade") || !"1".equals(entry.get("isover"))) continue;
                if (this.strictControl(expenseItem, vehicleConType, tripStandardControlMethod)) {
                    if (TripStandardCheckUtil.checkTripArea((DynamicObject)entry)) {
                        this.addErrorMessage(dataEntity, noticeCoordinate + String.format(ResManager.loadKDString((String)"\u51fa\u5dee\u5730\u57df\u4e3a\u7a7a\u3002", (String)"TripStandardValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    this.addFatalErrorMessage(dataEntity, noticeCoordinate + this.getDetailName(expenseItem, attribute) + String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TripStandardValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (!this.descControl(expenseItem, vehicleConType, tripStandardControlMethod) || !StringUtils.isBlank((String)entry.getString("overdesc"))) continue;
                if (TripStandardCheckUtil.checkTripArea((DynamicObject)entry)) {
                    this.addErrorMessage(dataEntity, noticeCoordinate + String.format(ResManager.loadKDString((String)"\u51fa\u5dee\u5730\u57df\u4e3a\u7a7a\u3002", (String)"TripStandardValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                this.addErrorMessage(dataEntity, noticeCoordinate + this.getDetailName(expenseItem, attribute) + String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u6807\uff0c\u8bf7\u586b\u5199\u8d85\u6807\u8bf4\u660e\u3002", (String)"TripStandardValidator_16", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    private String getDetailName(DynamicObject expenseItem, String attribute) {
        if (Arrays.asList(VEHIC_ATTRIBUTE).contains(attribute)) {
            return ResManager.loadKDString((String)"\u5ea7\u4f4d\u7b49\u7ea7", (String)"AbstractTripStdCtrlForGridStylePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(attribute)) {
            return ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d", (String)"AbstractTripStdCtrlForGridStylePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        return expenseItem.getLocaleString("name").getLocaleValue();
    }

    private boolean descControl(DynamicObject expenseItem, String vehicleConType, String tripStandardControlMethod) {
        if (this.vehicleAttible(expenseItem)) {
            return ControlMethodEnum.DESC_CONTROL.getValue().equals(vehicleConType);
        }
        return ControlMethodEnum.DESC_CONTROL.getValue().equals(tripStandardControlMethod);
    }

    private boolean strictControl(DynamicObject expenseItem, String vehicleConType, String tripStandardControlMethod) {
        if (this.vehicleAttible(expenseItem)) {
            return ControlMethodEnum.STRICT_CONTROL.getValue().equals(vehicleConType);
        }
        return ControlMethodEnum.STRICT_CONTROL.getValue().equals(tripStandardControlMethod);
    }

    private boolean checkMustInputIsFill(ExtendedDataEntity dataEntity, DynamicObject entryEntity, String noticeCoordinate, String ... propers) {
        boolean isFill = true;
        for (String pro : propers) {
            Object value = entryEntity.get(pro);
            boolean isNull = false;
            if (value == null) {
                isNull = true;
            } else if (value instanceof Collection) {
                isNull = ((Collection)value).isEmpty();
            } else if (value instanceof String) {
                isNull = StringUtils.isEmpty((String)value.toString());
            }
            if (isNull) {
                String localName = entryEntity.getDynamicObjectType().getProperty(pro).getDisplayName().getLocaleValue();
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripStandardValidator_15", (String)"fi-er-opplugin", (Object[])new Object[0]), noticeCoordinate, localName));
            }
            if (!isFill) continue;
            isFill = isFill && !isNull;
        }
        return isFill;
    }

    @Deprecated
    protected void cardTripReimValidator(IErTripStdControlService conService, ExtendedDataEntity dataEntity, Long companyId, Boolean isControl, Long userId, String trippartneraccstdtype, String tripStandardControlMethod, String vehicleConType, DynamicObjectCollection tripEntrys) {
    }

    private boolean vehicleAttible(DynamicObject expenseItem) {
        return Arrays.asList(VEHIC_ATTRIBUTE).contains(expenseItem.getString(TRIPEXP_ATTRIBUTE));
    }

    private boolean checkMustInput(DynamicObject tripEntry, ExtendedDataEntity dataEntity) {
        if (tripEntry.get("tripentryarea") == null) {
            DynamicObject to = tripEntry.getDynamicObject("to");
            String toName = null;
            if (to != null) {
                toName = to.getLocaleString("name").getLocaleValue();
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4%s\u5bf9\u5e94\u7684\u51fa\u5dee\u5730\u57df\u3002", (String)"TripStandardValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), toName));
        }
        return true;
    }

    private void addErrorMessage(ExtendedDataEntity dataEntity, int tripIndex, String errorMessage) {
        if (!DailyBillServiceHelper.isNewTripReim((DynamicObject)dataEntity.getDataEntity())) {
            errorMessage = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b, %2$s", (String)"TripStandardValidator_18", (String)"fi-er-opplugin", (Object[])new Object[0]), tripIndex, errorMessage);
        }
        this.addErrorMessage(dataEntity, errorMessage);
    }
}

